## Autonomous Economic Agent Framework

The AEA framework provides the tools for creating Autonomous Economic Agents (AEA). AEAs work continuously for your benefit without you having to do anything more than writing them and starting them up.

<iframe width="560" height="315" src="https://www.youtube.com/embed/xpJA4IT5X88" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

AEAs act independently of constant user input and autonomously execute actions to achieve their objective. Their goal is to create economic value for you, their owner. AEAs have a wide range of application areas. Check out the <a href="app-areas">application areas section</a>  and <a href="car-park-skills">demo guides</a> for some examples.

The AEA framework is a Python-based development suite which equips you with an efficient and easy to understand set of tools for building autonomous economic agents. The framework is truly modular, easily extensible, and highly composable. This framework attempts to make agent development as straightforward an experience as possible, similar to web development using popular web frameworks.

To get started developing your own AEA, check out the <a href="quickstart">quick start</a>.

To start learning about some of the distinctive characteristics of agent-oriented development, check out the guide on <a href="agent-oriented-development">agent-oriented development</a>.

AEAs achieve their goals with the help of the OEF - a search and discovery platform for agents by Fetch.ai - and using Fetch.ai's blockchain as a financial settlement layer. Third-party blockchains, such as Ethereum, may also allow AEA integration.

<div class="admonition note">
  <p class="admonition-title">Note</p>
  <p>This developer documentation is a work in progress. If you spot any errors please open an issue <a href="https://github.com/fetchai/agents-aea" target="_blank">here</a>.</p>
</div>

<br />
