import { IKey } from 'aws-cdk-lib/aws-kms';
import { Construct } from 'constructs';
import { IWorkspace, LoggingConfiguration, QueryLoggingConfiguration, WorkspaceBase, WorkspaceConfiguration } from './workspace-base';
/**
 * Properties for creating an Amazon Managed Service for Prometheus Workspace.
 */
export interface WorkspaceProps {
    /**
     * The alert manager definition, a YAML configuration for the alert manager in your Amazon
     * Managed Service for Prometheus workspace.
     */
    readonly alertManagerDefinition?: string;
    /**
     * The alias that is assigned to this workspace to help identify it. It does not need to be
     * unique.
     *
     * 0 to 100 characters
     */
    readonly alias?: string;
    /**
     * The customer managed AWS KMS key to use for encrypting data within your workspace.
     */
    readonly kmsKey?: IKey;
    /**
     * Contains information about the current rules and alerting logging configuration for the
     * workspace.
     *
     * Note: These logging configurations are only for rules and alerting logs.
     */
    readonly loggingConfiguration?: LoggingConfiguration;
    /**
     * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
     */
    readonly queryLoggingConfiguration?: QueryLoggingConfiguration;
    /**
     * Use this structure to define label sets and the ingestion limits for time series that match
     * label sets, and to specify the retention period of the workspace.
     */
    readonly workspaceConfiguration?: WorkspaceConfiguration;
}
/**
 * Properties for importing an Amazon Managed Service for Prometheus Workspace from attributes.
 */
export interface WorkspaceAttributes {
    /**
     * The alert manager definition, a YAML configuration for the alert manager in your Amazon
     * Managed Service for Prometheus workspace.
     */
    readonly alertManagerDefinition?: string;
    /**
     * The alias that is assigned to this workspace to help identify it. It does not need to be
     * unique.
     */
    readonly alias?: string;
    /**
     * The customer managed AWS KMS key to use for encrypting data within your workspace.
     */
    readonly kmsKey?: IKey;
    /**
     * Contains information about the current rules and alerting logging configuration for the
     * workspace.
     *
     * Note: These logging configurations are only for rules and alerting logs.
     */
    readonly loggingConfiguration?: LoggingConfiguration;
    /**
     * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
     */
    readonly queryLoggingConfiguration?: QueryLoggingConfiguration;
    /**
     * Use this structure to define label sets and the ingestion limits for time series that match
     * label sets, and to specify the retention period of the workspace.
     */
    readonly workspaceConfiguration?: WorkspaceConfiguration;
    /**
     * The arn of this workspace.
     */
    readonly workspaceArn: string;
}
export declare class Workspace extends WorkspaceBase {
    static isWorkspace(x: any): x is Workspace;
    static fromWorkspaceAttributes(scope: Construct, id: string, attrs: WorkspaceAttributes): IWorkspace;
    /**
     * Validates all workspace properties.
     *
     * @param props - The workspace properties to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * This method aggregates validation results from all individual property validators.
     * It throws an error if props is not an object.
     */
    private static validateProps;
    /**
     * The alert manager definition, a YAML configuration for the alert manager in your Amazon
     * Managed Service for Prometheus workspace.
     */
    readonly alertManagerDefinition?: string;
    /**
     * The alias that is assigned to this workspace to help identify it. It does not need to be
     * unique.
     */
    readonly alias?: string;
    /**
     * The customer managed AWS KMS key to use for encrypting data within your workspace.
     */
    readonly kmsKey?: IKey;
    /**
     * Contains information about the current rules and alerting logging configuration for the
     * workspace.
     *
     * Note: These logging configurations are only for rules and alerting logs.
     */
    readonly loggingConfiguration?: LoggingConfiguration;
    /**
     * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
     */
    readonly queryLoggingConfiguration?: QueryLoggingConfiguration;
    /**
     * Use this structure to define label sets and the ingestion limits for time series that match
     * label sets, and to specify the retention period of the workspace.
     */
    readonly workspaceConfiguration?: WorkspaceConfiguration;
    /**
     * The underlying CloudFormation resource.
     */
    private readonly workspace;
    /**
     * The unique ID for the workspace.
     */
    readonly workspaceId: string;
    /**
     * The ARN of the workspace.
     */
    readonly workspaceArn: string;
    /**
     * The Prometheus endpoint available for this workspace..
     */
    readonly prometheusEndpoint: string;
    constructor(scope: Construct, id: string, props: WorkspaceProps);
}
