"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scraper = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("@robhan-cdk-lib/utils");
const aws_aps_1 = require("aws-cdk-lib/aws-aps");
const scraper_base_1 = require("./scraper-base");
const scraper_base_2 = require("./validation/scraper-base");
const IS_SCRAPER = Symbol.for('@robhan-cdk-lib/aws_aps.Scraper');
class Scraper extends scraper_base_1.ScraperBase {
    static isScraper(x) {
        return IS_SCRAPER in x;
    }
    static fromScraperAttributes(scope, id, attrs) {
        class Import extends scraper_base_1.ScraperBase {
            constructor(attributes) {
                super(scope, id);
                this.alias = attributes.alias;
                this.destination = attributes.destination;
                this.roleConfiguration = attributes.roleConfiguration;
                this.scrapeConfiguration = attributes.scrapeConfiguration;
                this.source = attributes.source;
                this.scraperId = this.getScraperId(attributes.scraperArn);
                this.scraperArn = attributes.scraperArn;
            }
        }
        return new Import(attrs);
    }
    /**
     * Validates all scraper properties.
     *
     * @param props - The scraper properties to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * This method aggregates validation results from all individual property validators.
     * It throws an error if props is not an object.
     */
    static validateProps(props) {
        const errors = [];
        if (!props || typeof props !== 'object') {
            throw new Error('Scraper constructor properties must be an object');
        }
        errors.push(...(0, utils_1.validateObjectAttributes)({
            inputObject: props,
            mandatoryAttributes: ['destination', 'scrapeConfiguration', 'source'],
            optionalAttributes: ['alias', 'roleConfiguration'],
        }));
        const scraperProps = props;
        if (scraperProps.alias !== undefined) {
            errors.push(...(0, scraper_base_2.validateAlias)(scraperProps.alias).map((e) => `alias: ${e}`));
        }
        if (scraperProps.destination !== undefined) {
            errors.push(...(0, scraper_base_2.validateDestination)(scraperProps.destination).map((e) => `destination: ${e}`));
        }
        if (scraperProps.roleConfiguration !== undefined) {
            errors.push(...(0, scraper_base_2.validateRoleConfiguration)(scraperProps.roleConfiguration).map((e) => `roleConfiguration: ${e}`));
        }
        if (scraperProps.scrapeConfiguration !== undefined) {
            errors.push(...(0, scraper_base_2.validateScrapeConfiguration)(scraperProps.scrapeConfiguration).map((e) => `scrapeConfiguration: ${e}`));
        }
        if (scraperProps.source !== undefined) {
            errors.push(...(0, scraper_base_2.validateSource)(scraperProps.source).map((e) => `source: ${e}`));
        }
        return errors;
    }
    constructor(scope, id, props) {
        super(scope, id);
        Object.defineProperty(this, IS_SCRAPER, { value: true });
        const errors = Scraper.validateProps(props);
        if (errors.length > 0) {
            throw new Error(`Invalid props:\n${errors.join('\n')}`);
        }
        this.alias = props.alias;
        this.destination = props.destination;
        this.roleConfiguration = props.roleConfiguration;
        this.scrapeConfiguration = props.scrapeConfiguration;
        this.source = props.source;
        let cfnScraperProps = {
            alias: props.alias,
            destination: {
                ampConfiguration: {
                    workspaceArn: props.destination.ampConfiguration.workspace.workspaceArn,
                },
            },
            roleConfiguration: {
                sourceRoleArn: props.roleConfiguration?.sourceRole?.roleArn,
                targetRoleArn: props.roleConfiguration?.targetRole?.roleArn,
            },
            scrapeConfiguration: props.scrapeConfiguration,
            source: {
                eksConfiguration: {
                    clusterArn: props.source.eksConfiguration.cluster.clusterArn,
                    securityGroupIds: props.source.eksConfiguration.securityGroups?.map(x => x.securityGroupId),
                    subnetIds: props.source.eksConfiguration.subnets.map(x => x.subnetId),
                },
            },
        };
        this.scraper = new aws_aps_1.CfnScraper(this, 'Resource', cfnScraperProps);
        this.node.defaultChild = this.scraper;
        this.scraperId = this.scraper.attrArn;
        this.scraperArn = this.scraper.attrArn;
    }
}
exports.Scraper = Scraper;
_a = JSII_RTTI_SYMBOL_1;
Scraper[_a] = { fqn: "@robhan-cdk-lib/aws_aps.Scraper", version: "0.0.94" };
//# sourceMappingURL=data:application/json;base64,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