import { Construct } from 'constructs';
import { Destination, IScraper, RoleConfiguration, ScrapeConfiguration, ScraperBase, Source } from './scraper-base';
/**
 * Properties for creating an Amazon Managed Service for Prometheus Scraper.
 */
export interface ScraperProps {
    /**
     * An optional user-assigned scraper alias.
     *
     * 1-100 characters.
     *
     * Pattern: ^[0-9A-Za-z][-.0-9A-Z_a-z]*$
     */
    readonly alias?: string;
    /**
     * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
     */
    readonly destination: Destination;
    /**
     * The role configuration in an Amazon Managed Service for Prometheus scraper.
     */
    readonly roleConfiguration?: RoleConfiguration;
    /**
     * The configuration in use by the scraper.
     */
    readonly scrapeConfiguration: ScrapeConfiguration;
    /**
     * The Amazon EKS cluster from which the scraper collects metrics.
     */
    readonly source: Source;
}
/**
 * Properties for importing an Amazon Managed Service for Prometheus Scraper from attributes.
 */
export interface ScraperAttributes {
    /**
     * An optional user-assigned scraper alias.
     *
     * 1-100 characters.
     *
     * Pattern: ^[0-9A-Za-z][-.0-9A-Z_a-z]*$
     */
    readonly alias?: string;
    /**
     * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
     */
    readonly destination: Destination;
    /**
     * The role configuration in an Amazon Managed Service for Prometheus scraper.
     */
    readonly roleConfiguration?: RoleConfiguration;
    /**
     * The configuration in use by the scraper.
     */
    readonly scrapeConfiguration: ScrapeConfiguration;
    /**
     * The Amazon EKS cluster from which the scraper collects metrics.
     */
    readonly source: Source;
    /**
     * The ARN of the scraper.
     */
    readonly scraperArn: string;
}
export declare class Scraper extends ScraperBase {
    static isScraper(x: any): x is Scraper;
    static fromScraperAttributes(scope: Construct, id: string, attrs: ScraperAttributes): IScraper;
    /**
     * Validates all scraper properties.
     *
     * @param props - The scraper properties to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * This method aggregates validation results from all individual property validators.
     * It throws an error if props is not an object.
     */
    private static validateProps;
    /**
     * An optional user-assigned scraper alias.
     */
    readonly alias?: string;
    /**
     * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
     */
    readonly destination: Destination;
    /**
     * The role configuration in an Amazon Managed Service for Prometheus scraper.
     */
    readonly roleConfiguration?: RoleConfiguration;
    /**
     * The configuration in use by the scraper.
     */
    readonly scrapeConfiguration: ScrapeConfiguration;
    /**
     * The Amazon EKS cluster from which the scraper collects metrics.
     */
    readonly source: Source;
    /**
     * The ID of the scraper.
     */
    readonly scraperId: string;
    /**
     * The ARN of the scraper.
     */
    readonly scraperArn: string;
    /**
     * The underlying CloudFormation resource.
     */
    private readonly scraper;
    constructor(scope: Construct, id: string, props: ScraperProps);
}
