"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleGroupsNamespace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("@robhan-cdk-lib/utils");
const aws_aps_1 = require("aws-cdk-lib/aws-aps");
const rule_groups_namespace_base_1 = require("./rule-groups-namespace-base");
const rule_groups_namespace_base_2 = require("./validation/rule-groups-namespace-base");
const IS_RULE_GROUPS_NAMESPACE = Symbol.for('@robhan-cdk-lib/aws_aps.RuleGroupsNamespace');
/**
 * The definition of a rule groups namespace in an Amazon Managed Service for Prometheus workspace.
 * A rule groups namespace is associated with exactly one rules file. A workspace can have multiple
 * rule groups namespaces.
 */
class RuleGroupsNamespace extends rule_groups_namespace_base_1.RuleGroupsNamespaceBase {
    static isRuleGroupsNamespace(x) {
        return IS_RULE_GROUPS_NAMESPACE in x;
    }
    static fromRuleGroupsNamespaceAttributes(scope, id, attrs) {
        class Import extends rule_groups_namespace_base_1.RuleGroupsNamespaceBase {
            constructor(attributes) {
                super(scope, id);
                this.data = attributes.data;
                this.name = attributes.name;
                this.workspace = attributes.workspace;
                this.ruleGroupsNamespaceArn = attributes.ruleGroupsNamespaceArn;
            }
        }
        return new Import(attrs);
    }
    /**
     * Validates all rule groups namespace properties.
     *
     * @param props - The rule group namespace properties to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * This method aggregates validation results from all individual property validators.
     * It throws an error if props is not an object.
     */
    static validateProps(props) {
        const errors = [];
        if (!props || typeof props !== 'object') {
            throw new Error('RuleGroupsNamespace constructor properties must be an object');
        }
        const ruleGroupsNamespaceProps = props;
        errors.push(...(0, utils_1.validateObjectAttributes)({
            inputObject: ruleGroupsNamespaceProps,
            mandatoryAttributes: ['data', 'name', 'workspace'],
            optionalAttributes: [],
        }));
        if (ruleGroupsNamespaceProps.name !== undefined) {
            errors.push(...(0, rule_groups_namespace_base_2.validateName)(ruleGroupsNamespaceProps.name).map((err) => `name: ${err}`));
        }
        if (ruleGroupsNamespaceProps.data !== undefined) {
            errors.push(...(0, rule_groups_namespace_base_2.validateData)(ruleGroupsNamespaceProps.data).map((err) => `data: ${err}`));
        }
        return errors;
    }
    constructor(scope, id, props) {
        super(scope, id);
        Object.defineProperty(this, IS_RULE_GROUPS_NAMESPACE, { value: true });
        const errors = RuleGroupsNamespace.validateProps(props);
        if (errors.length > 0) {
            throw new Error(`Invalid props:\n${errors.join('\n')}`);
        }
        this.data = props.data;
        this.name = props.name;
        this.workspace = props.workspace;
        let cfnRuleGroupsNamespaceProps = {
            data: props.data,
            name: props.name,
            workspace: props.workspace.workspaceId,
        };
        this.ruleGroupsNamespace = new aws_aps_1.CfnRuleGroupsNamespace(this, 'Resource', cfnRuleGroupsNamespaceProps);
        this.node.defaultChild = this.ruleGroupsNamespace;
        this.ruleGroupsNamespaceArn = this.ruleGroupsNamespace.attrArn;
    }
}
exports.RuleGroupsNamespace = RuleGroupsNamespace;
_a = JSII_RTTI_SYMBOL_1;
RuleGroupsNamespace[_a] = { fqn: "@robhan-cdk-lib/aws_aps.RuleGroupsNamespace", version: "0.0.94" };
//# sourceMappingURL=data:application/json;base64,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