# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class TaskFormData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'form_key': 'str',
        'form_properties': 'list[FormProperty]',
        'task_id': 'str',
        'contains_activity_stream': 'bool',
        'subtitle': 'str'
    }

    attribute_map = {
        'form_key': 'formKey',
        'form_properties': 'formProperties',
        'task_id': 'taskId',
        'contains_activity_stream': 'containsActivityStream',
        'subtitle': 'subtitle'
    }

    def __init__(self, form_key=None, form_properties=None, task_id=None, contains_activity_stream=None, subtitle=None, local_vars_configuration=None):  # noqa: E501
        """TaskFormData - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._form_key = None
        self._form_properties = None
        self._task_id = None
        self._contains_activity_stream = None
        self._subtitle = None
        self.discriminator = None

        if form_key is not None:
            self.form_key = form_key
        if form_properties is not None:
            self.form_properties = form_properties
        if task_id is not None:
            self.task_id = task_id
        if contains_activity_stream is not None:
            self.contains_activity_stream = contains_activity_stream
        if subtitle is not None:
            self.subtitle = subtitle

    @property
    def form_key(self):
        """Gets the form_key of this TaskFormData.  # noqa: E501

        The form key.  # noqa: E501

        :return: The form_key of this TaskFormData.  # noqa: E501
        :rtype: str
        """
        return self._form_key

    @form_key.setter
    def form_key(self, form_key):
        """Sets the form_key of this TaskFormData.

        The form key.  # noqa: E501

        :param form_key: The form_key of this TaskFormData.  # noqa: E501
        :type: str
        """

        self._form_key = form_key

    @property
    def form_properties(self):
        """Gets the form_properties of this TaskFormData.  # noqa: E501

        The list of form properties.  # noqa: E501

        :return: The form_properties of this TaskFormData.  # noqa: E501
        :rtype: list[FormProperty]
        """
        return self._form_properties

    @form_properties.setter
    def form_properties(self, form_properties):
        """Sets the form_properties of this TaskFormData.

        The list of form properties.  # noqa: E501

        :param form_properties: The form_properties of this TaskFormData.  # noqa: E501
        :type: list[FormProperty]
        """

        self._form_properties = form_properties

    @property
    def task_id(self):
        """Gets the task_id of this TaskFormData.  # noqa: E501

        The <code>id</code> of the task.  # noqa: E501

        :return: The task_id of this TaskFormData.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this TaskFormData.

        The <code>id</code> of the task.  # noqa: E501

        :param task_id: The task_id of this TaskFormData.  # noqa: E501
        :type: str
        """

        self._task_id = task_id

    @property
    def contains_activity_stream(self):
        """Gets the contains_activity_stream of this TaskFormData.  # noqa: E501

        Whether the task form contains a activity stream.  # noqa: E501

        :return: The contains_activity_stream of this TaskFormData.  # noqa: E501
        :rtype: bool
        """
        return self._contains_activity_stream

    @contains_activity_stream.setter
    def contains_activity_stream(self, contains_activity_stream):
        """Sets the contains_activity_stream of this TaskFormData.

        Whether the task form contains a activity stream.  # noqa: E501

        :param contains_activity_stream: The contains_activity_stream of this TaskFormData.  # noqa: E501
        :type: bool
        """

        self._contains_activity_stream = contains_activity_stream

    @property
    def subtitle(self):
        """Gets the subtitle of this TaskFormData.  # noqa: E501

        The subtitle of the task if any.  # noqa: E501

        :return: The subtitle of this TaskFormData.  # noqa: E501
        :rtype: str
        """
        return self._subtitle

    @subtitle.setter
    def subtitle(self, subtitle):
        """Sets the subtitle of this TaskFormData.

        The subtitle of the task if any.  # noqa: E501

        :param subtitle: The subtitle of this TaskFormData.  # noqa: E501
        :type: str
        """

        self._subtitle = subtitle

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskFormData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskFormData):
            return True

        return self.to_dict() != other.to_dict()
