# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class SetAssetRelationsRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type_id': 'str',
        'related_asset_ids': 'list[str]',
        'relation_direction': 'str'
    }

    attribute_map = {
        'type_id': 'typeId',
        'related_asset_ids': 'relatedAssetIds',
        'relation_direction': 'relationDirection'
    }

    def __init__(self, type_id=None, related_asset_ids=None, relation_direction=None, local_vars_configuration=None):  # noqa: E501
        """SetAssetRelationsRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type_id = None
        self._related_asset_ids = None
        self._relation_direction = None
        self.discriminator = None

        self.type_id = type_id
        self.related_asset_ids = related_asset_ids
        self.relation_direction = relation_direction

    @property
    def type_id(self):
        """Gets the type_id of this SetAssetRelationsRequest.  # noqa: E501

        The ID of the relation type for the relations to be set.  # noqa: E501

        :return: The type_id of this SetAssetRelationsRequest.  # noqa: E501
        :rtype: str
        """
        return self._type_id

    @type_id.setter
    def type_id(self, type_id):
        """Sets the type_id of this SetAssetRelationsRequest.

        The ID of the relation type for the relations to be set.  # noqa: E501

        :param type_id: The type_id of this SetAssetRelationsRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `type_id`, must not be `None`")  # noqa: E501

        self._type_id = type_id

    @property
    def related_asset_ids(self):
        """Gets the related_asset_ids of this SetAssetRelationsRequest.  # noqa: E501

        The IDs of the related assets.  # noqa: E501

        :return: The related_asset_ids of this SetAssetRelationsRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._related_asset_ids

    @related_asset_ids.setter
    def related_asset_ids(self, related_asset_ids):
        """Sets the related_asset_ids of this SetAssetRelationsRequest.

        The IDs of the related assets.  # noqa: E501

        :param related_asset_ids: The related_asset_ids of this SetAssetRelationsRequest.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and related_asset_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `related_asset_ids`, must not be `None`")  # noqa: E501

        self._related_asset_ids = related_asset_ids

    @property
    def relation_direction(self):
        """Gets the relation_direction of this SetAssetRelationsRequest.  # noqa: E501

        The relation direction. If TO_SOURCE then related assets will become source assets. Otherwise they will become target assets for created relations.  # noqa: E501

        :return: The relation_direction of this SetAssetRelationsRequest.  # noqa: E501
        :rtype: str
        """
        return self._relation_direction

    @relation_direction.setter
    def relation_direction(self, relation_direction):
        """Sets the relation_direction of this SetAssetRelationsRequest.

        The relation direction. If TO_SOURCE then related assets will become source assets. Otherwise they will become target assets for created relations.  # noqa: E501

        :param relation_direction: The relation_direction of this SetAssetRelationsRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and relation_direction is None:  # noqa: E501
            raise ValueError("Invalid value for `relation_direction`, must not be `None`")  # noqa: E501
        allowed_values = ["TO_TARGET", "TO_SOURCE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and relation_direction not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `relation_direction` ({0}), must be one of {1}"  # noqa: E501
                .format(relation_direction, allowed_values)
            )

        self._relation_direction = relation_direction

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SetAssetRelationsRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SetAssetRelationsRequest):
            return True

        return self.to_dict() != other.to_dict()
