# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class NavigationStatisticsEntry(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'asset_id': 'str',
        'name': 'str',
        'number_of_views': 'int',
        'last_viewed_date': 'int'
    }

    attribute_map = {
        'asset_id': 'assetId',
        'name': 'name',
        'number_of_views': 'numberOfViews',
        'last_viewed_date': 'lastViewedDate'
    }

    def __init__(self, asset_id=None, name=None, number_of_views=None, last_viewed_date=None, local_vars_configuration=None):  # noqa: E501
        """NavigationStatisticsEntry - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._asset_id = None
        self._name = None
        self._number_of_views = None
        self._last_viewed_date = None
        self.discriminator = None

        if asset_id is not None:
            self.asset_id = asset_id
        if name is not None:
            self.name = name
        if number_of_views is not None:
            self.number_of_views = number_of_views
        if last_viewed_date is not None:
            self.last_viewed_date = last_viewed_date

    @property
    def asset_id(self):
        """Gets the asset_id of this NavigationStatisticsEntry.  # noqa: E501

        The id of the asset for which the statistics are calculated  # noqa: E501

        :return: The asset_id of this NavigationStatisticsEntry.  # noqa: E501
        :rtype: str
        """
        return self._asset_id

    @asset_id.setter
    def asset_id(self, asset_id):
        """Sets the asset_id of this NavigationStatisticsEntry.

        The id of the asset for which the statistics are calculated  # noqa: E501

        :param asset_id: The asset_id of this NavigationStatisticsEntry.  # noqa: E501
        :type: str
        """

        self._asset_id = asset_id

    @property
    def name(self):
        """Gets the name of this NavigationStatisticsEntry.  # noqa: E501

        The name of the asset for which the statistics are calculated  # noqa: E501

        :return: The name of this NavigationStatisticsEntry.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NavigationStatisticsEntry.

        The name of the asset for which the statistics are calculated  # noqa: E501

        :param name: The name of this NavigationStatisticsEntry.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def number_of_views(self):
        """Gets the number_of_views of this NavigationStatisticsEntry.  # noqa: E501

        The number of times the Asset was viewed.  # noqa: E501

        :return: The number_of_views of this NavigationStatisticsEntry.  # noqa: E501
        :rtype: int
        """
        return self._number_of_views

    @number_of_views.setter
    def number_of_views(self, number_of_views):
        """Sets the number_of_views of this NavigationStatisticsEntry.

        The number of times the Asset was viewed.  # noqa: E501

        :param number_of_views: The number_of_views of this NavigationStatisticsEntry.  # noqa: E501
        :type: int
        """

        self._number_of_views = number_of_views

    @property
    def last_viewed_date(self):
        """Gets the last_viewed_date of this NavigationStatisticsEntry.  # noqa: E501

        The timestamp (in UTC time standard) of the last time when the Asset was viewed by anyone.  # noqa: E501

        :return: The last_viewed_date of this NavigationStatisticsEntry.  # noqa: E501
        :rtype: int
        """
        return self._last_viewed_date

    @last_viewed_date.setter
    def last_viewed_date(self, last_viewed_date):
        """Sets the last_viewed_date of this NavigationStatisticsEntry.

        The timestamp (in UTC time standard) of the last time when the Asset was viewed by anyone.  # noqa: E501

        :param last_viewed_date: The last_viewed_date of this NavigationStatisticsEntry.  # noqa: E501
        :type: int
        """

        self._last_viewed_date = last_viewed_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NavigationStatisticsEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NavigationStatisticsEntry):
            return True

        return self.to_dict() != other.to_dict()
