# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ExportComplexRelationsToCSVRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'complex_relation_type_id': 'str',
        'domain_id': 'str',
        'store_as_attachment': 'bool',
        'file_name': 'str',
        'include_header_row': 'bool',
        'support_roundtrip': 'bool',
        'remove_formatting': 'bool',
        'separator': 'str',
        'quote': 'str',
        'escape': 'str'
    }

    attribute_map = {
        'complex_relation_type_id': 'complexRelationTypeId',
        'domain_id': 'domainId',
        'store_as_attachment': 'storeAsAttachment',
        'file_name': 'fileName',
        'include_header_row': 'includeHeaderRow',
        'support_roundtrip': 'supportRoundtrip',
        'remove_formatting': 'removeFormatting',
        'separator': 'separator',
        'quote': 'quote',
        'escape': 'escape'
    }

    def __init__(self, complex_relation_type_id=None, domain_id=None, store_as_attachment=None, file_name=None, include_header_row=None, support_roundtrip=None, remove_formatting=None, separator=None, quote=None, escape=None, local_vars_configuration=None):  # noqa: E501
        """ExportComplexRelationsToCSVRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._complex_relation_type_id = None
        self._domain_id = None
        self._store_as_attachment = None
        self._file_name = None
        self._include_header_row = None
        self._support_roundtrip = None
        self._remove_formatting = None
        self._separator = None
        self._quote = None
        self._escape = None
        self.discriminator = None

        self.complex_relation_type_id = complex_relation_type_id
        if domain_id is not None:
            self.domain_id = domain_id
        if store_as_attachment is not None:
            self.store_as_attachment = store_as_attachment
        if file_name is not None:
            self.file_name = file_name
        if include_header_row is not None:
            self.include_header_row = include_header_row
        if support_roundtrip is not None:
            self.support_roundtrip = support_roundtrip
        if remove_formatting is not None:
            self.remove_formatting = remove_formatting
        if separator is not None:
            self.separator = separator
        if quote is not None:
            self.quote = quote
        if escape is not None:
            self.escape = escape

    @property
    def complex_relation_type_id(self):
        """Gets the complex_relation_type_id of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        The Id of the ComplexRelationType for which the export will be executed.  # noqa: E501

        :return: The complex_relation_type_id of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: str
        """
        return self._complex_relation_type_id

    @complex_relation_type_id.setter
    def complex_relation_type_id(self, complex_relation_type_id):
        """Sets the complex_relation_type_id of this ExportComplexRelationsToCSVRequest.

        The Id of the ComplexRelationType for which the export will be executed.  # noqa: E501

        :param complex_relation_type_id: The complex_relation_type_id of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and complex_relation_type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `complex_relation_type_id`, must not be `None`")  # noqa: E501

        self._complex_relation_type_id = complex_relation_type_id

    @property
    def domain_id(self):
        """Gets the domain_id of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        The Id of the Domain to filter on (optional).  # noqa: E501

        :return: The domain_id of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: str
        """
        return self._domain_id

    @domain_id.setter
    def domain_id(self, domain_id):
        """Sets the domain_id of this ExportComplexRelationsToCSVRequest.

        The Id of the Domain to filter on (optional).  # noqa: E501

        :param domain_id: The domain_id of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: str
        """

        self._domain_id = domain_id

    @property
    def store_as_attachment(self):
        """Gets the store_as_attachment of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        Sets if the export should be stored as an attachment (<code>true</code>) or not (<code>false</code>)<br/>of the provided {@link #domainId}.  # noqa: E501

        :return: The store_as_attachment of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: bool
        """
        return self._store_as_attachment

    @store_as_attachment.setter
    def store_as_attachment(self, store_as_attachment):
        """Sets the store_as_attachment of this ExportComplexRelationsToCSVRequest.

        Sets if the export should be stored as an attachment (<code>true</code>) or not (<code>false</code>)<br/>of the provided {@link #domainId}.  # noqa: E501

        :param store_as_attachment: The store_as_attachment of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: bool
        """

        self._store_as_attachment = store_as_attachment

    @property
    def file_name(self):
        """Gets the file_name of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        The name of the file. (optional) if not provided a name is generated.  # noqa: E501

        :return: The file_name of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """Sets the file_name of this ExportComplexRelationsToCSVRequest.

        The name of the file. (optional) if not provided a name is generated.  # noqa: E501

        :param file_name: The file_name of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: str
        """

        self._file_name = file_name

    @property
    def include_header_row(self):
        """Gets the include_header_row of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        Set if the file will include a header (<code>true</code>) or not (<code>false</code>)<br/>Default value is <code>false</code>.  # noqa: E501

        :return: The include_header_row of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: bool
        """
        return self._include_header_row

    @include_header_row.setter
    def include_header_row(self, include_header_row):
        """Sets the include_header_row of this ExportComplexRelationsToCSVRequest.

        Set if the file will include a header (<code>true</code>) or not (<code>false</code>)<br/>Default value is <code>false</code>.  # noqa: E501

        :param include_header_row: The include_header_row of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: bool
        """

        self._include_header_row = include_header_row

    @property
    def support_roundtrip(self):
        """Gets the support_roundtrip of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        Adds characteristics to support reimport (<code>true</code>) or not (<code>false</code>)<br/>Default value is <code>false</code>.  # noqa: E501

        :return: The support_roundtrip of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: bool
        """
        return self._support_roundtrip

    @support_roundtrip.setter
    def support_roundtrip(self, support_roundtrip):
        """Sets the support_roundtrip of this ExportComplexRelationsToCSVRequest.

        Adds characteristics to support reimport (<code>true</code>) or not (<code>false</code>)<br/>Default value is <code>false</code>.  # noqa: E501

        :param support_roundtrip: The support_roundtrip of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: bool
        """

        self._support_roundtrip = support_roundtrip

    @property
    def remove_formatting(self):
        """Gets the remove_formatting of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        Remove text formatting (<code>true</code>) or not (<code>false</code>)<br/>Default value is <code>false</code>.  # noqa: E501

        :return: The remove_formatting of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: bool
        """
        return self._remove_formatting

    @remove_formatting.setter
    def remove_formatting(self, remove_formatting):
        """Sets the remove_formatting of this ExportComplexRelationsToCSVRequest.

        Remove text formatting (<code>true</code>) or not (<code>false</code>)<br/>Default value is <code>false</code>.  # noqa: E501

        :param remove_formatting: The remove_formatting of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: bool
        """

        self._remove_formatting = remove_formatting

    @property
    def separator(self):
        """Gets the separator of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        The delimiter character used to separate entries.<br/>If not provided default value <code>';'</code> is used.  # noqa: E501

        :return: The separator of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: str
        """
        return self._separator

    @separator.setter
    def separator(self, separator):
        """Sets the separator of this ExportComplexRelationsToCSVRequest.

        The delimiter character used to separate entries.<br/>If not provided default value <code>';'</code> is used.  # noqa: E501

        :param separator: The separator of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: str
        """

        self._separator = separator

    @property
    def quote(self):
        """Gets the quote of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        The delimiter character used for quoted entries.<br/>If not provided default value <code>'\\\"'</code> is used.  # noqa: E501

        :return: The quote of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: str
        """
        return self._quote

    @quote.setter
    def quote(self, quote):
        """Sets the quote of this ExportComplexRelationsToCSVRequest.

        The delimiter character used for quoted entries.<br/>If not provided default value <code>'\\\"'</code> is used.  # noqa: E501

        :param quote: The quote of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: str
        """

        self._quote = quote

    @property
    def escape(self):
        """Gets the escape of this ExportComplexRelationsToCSVRequest.  # noqa: E501

        The delimiter character used to escape separator or quote character.<br/>If not provided default value <code>'\\\\'</code> is used.  # noqa: E501

        :return: The escape of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :rtype: str
        """
        return self._escape

    @escape.setter
    def escape(self, escape):
        """Sets the escape of this ExportComplexRelationsToCSVRequest.

        The delimiter character used to escape separator or quote character.<br/>If not provided default value <code>'\\\\'</code> is used.  # noqa: E501

        :param escape: The escape of this ExportComplexRelationsToCSVRequest.  # noqa: E501
        :type: str
        """

        self._escape = escape

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExportComplexRelationsToCSVRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExportComplexRelationsToCSVRequest):
            return True

        return self.to_dict() != other.to_dict()
