# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ChangeUserRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'enabled': 'bool',
        'username': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'email': 'str',
        'gender': 'str',
        'language': 'str',
        'license_type': 'str',
        'addresses': 'list[Address]',
        'phones': 'list[PhoneNumber]',
        'additional_email_addresses': 'list[Email]',
        'instant_messaging_accounts': 'list[InstantMessagingAccount]',
        'websites': 'list[Website]'
    }

    attribute_map = {
        'enabled': 'enabled',
        'username': 'username',
        'first_name': 'firstName',
        'last_name': 'lastName',
        'email': 'email',
        'gender': 'gender',
        'language': 'language',
        'license_type': 'licenseType',
        'addresses': 'addresses',
        'phones': 'phones',
        'additional_email_addresses': 'additionalEmailAddresses',
        'instant_messaging_accounts': 'instantMessagingAccounts',
        'websites': 'websites'
    }

    def __init__(self, enabled=None, username=None, first_name=None, last_name=None, email=None, gender=None, language=None, license_type=None, addresses=None, phones=None, additional_email_addresses=None, instant_messaging_accounts=None, websites=None, local_vars_configuration=None):  # noqa: E501
        """ChangeUserRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._enabled = None
        self._username = None
        self._first_name = None
        self._last_name = None
        self._email = None
        self._gender = None
        self._language = None
        self._license_type = None
        self._addresses = None
        self._phones = None
        self._additional_email_addresses = None
        self._instant_messaging_accounts = None
        self._websites = None
        self.discriminator = None

        if enabled is not None:
            self.enabled = enabled
        if username is not None:
            self.username = username
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if email is not None:
            self.email = email
        if gender is not None:
            self.gender = gender
        if language is not None:
            self.language = language
        if license_type is not None:
            self.license_type = license_type
        if addresses is not None:
            self.addresses = addresses
        if phones is not None:
            self.phones = phones
        if additional_email_addresses is not None:
            self.additional_email_addresses = additional_email_addresses
        if instant_messaging_accounts is not None:
            self.instant_messaging_accounts = instant_messaging_accounts
        if websites is not None:
            self.websites = websites

    @property
    def enabled(self):
        """Gets the enabled of this ChangeUserRequest.  # noqa: E501

        The new enabled flag for the user  # noqa: E501

        :return: The enabled of this ChangeUserRequest.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ChangeUserRequest.

        The new enabled flag for the user  # noqa: E501

        :param enabled: The enabled of this ChangeUserRequest.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def username(self):
        """Gets the username of this ChangeUserRequest.  # noqa: E501

        The new username for the user  # noqa: E501

        :return: The username of this ChangeUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this ChangeUserRequest.

        The new username for the user  # noqa: E501

        :param username: The username of this ChangeUserRequest.  # noqa: E501
        :type: str
        """

        self._username = username

    @property
    def first_name(self):
        """Gets the first_name of this ChangeUserRequest.  # noqa: E501

        The new first name for the user  # noqa: E501

        :return: The first_name of this ChangeUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this ChangeUserRequest.

        The new first name for the user  # noqa: E501

        :param first_name: The first_name of this ChangeUserRequest.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this ChangeUserRequest.  # noqa: E501

        The new last name for the user  # noqa: E501

        :return: The last_name of this ChangeUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this ChangeUserRequest.

        The new last name for the user  # noqa: E501

        :param last_name: The last_name of this ChangeUserRequest.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def email(self):
        """Gets the email of this ChangeUserRequest.  # noqa: E501

        The new e-mail address for the user  # noqa: E501

        :return: The email of this ChangeUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this ChangeUserRequest.

        The new e-mail address for the user  # noqa: E501

        :param email: The email of this ChangeUserRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) > 2147483647):
            raise ValueError("Invalid value for `email`, length must be less than or equal to `2147483647`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) < 1):
            raise ValueError("Invalid value for `email`, length must be greater than or equal to `1`")  # noqa: E501

        self._email = email

    @property
    def gender(self):
        """Gets the gender of this ChangeUserRequest.  # noqa: E501

        The new gender for the user  # noqa: E501

        :return: The gender of this ChangeUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._gender

    @gender.setter
    def gender(self, gender):
        """Sets the gender of this ChangeUserRequest.

        The new gender for the user  # noqa: E501

        :param gender: The gender of this ChangeUserRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["MALE", "FEMALE", "UNKNOWN"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and gender not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `gender` ({0}), must be one of {1}"  # noqa: E501
                .format(gender, allowed_values)
            )

        self._gender = gender

    @property
    def language(self):
        """Gets the language of this ChangeUserRequest.  # noqa: E501

        The new language for the user  # noqa: E501

        :return: The language of this ChangeUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this ChangeUserRequest.

        The new language for the user  # noqa: E501

        :param language: The language of this ChangeUserRequest.  # noqa: E501
        :type: str
        """

        self._language = language

    @property
    def license_type(self):
        """Gets the license_type of this ChangeUserRequest.  # noqa: E501

        The license type of the user. LicenseType will be removed in the future.  # noqa: E501

        :return: The license_type of this ChangeUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """Sets the license_type of this ChangeUserRequest.

        The license type of the user. LicenseType will be removed in the future.  # noqa: E501

        :param license_type: The license_type of this ChangeUserRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["CONSUMER", "AUTHOR"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and license_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `license_type` ({0}), must be one of {1}"  # noqa: E501
                .format(license_type, allowed_values)
            )

        self._license_type = license_type

    @property
    def addresses(self):
        """Gets the addresses of this ChangeUserRequest.  # noqa: E501

        The postal addresses of the user  # noqa: E501

        :return: The addresses of this ChangeUserRequest.  # noqa: E501
        :rtype: list[Address]
        """
        return self._addresses

    @addresses.setter
    def addresses(self, addresses):
        """Sets the addresses of this ChangeUserRequest.

        The postal addresses of the user  # noqa: E501

        :param addresses: The addresses of this ChangeUserRequest.  # noqa: E501
        :type: list[Address]
        """

        self._addresses = addresses

    @property
    def phones(self):
        """Gets the phones of this ChangeUserRequest.  # noqa: E501

        The phone numbers of the user  # noqa: E501

        :return: The phones of this ChangeUserRequest.  # noqa: E501
        :rtype: list[PhoneNumber]
        """
        return self._phones

    @phones.setter
    def phones(self, phones):
        """Sets the phones of this ChangeUserRequest.

        The phone numbers of the user  # noqa: E501

        :param phones: The phones of this ChangeUserRequest.  # noqa: E501
        :type: list[PhoneNumber]
        """

        self._phones = phones

    @property
    def additional_email_addresses(self):
        """Gets the additional_email_addresses of this ChangeUserRequest.  # noqa: E501

        The additional e-mail addresses of the user  # noqa: E501

        :return: The additional_email_addresses of this ChangeUserRequest.  # noqa: E501
        :rtype: list[Email]
        """
        return self._additional_email_addresses

    @additional_email_addresses.setter
    def additional_email_addresses(self, additional_email_addresses):
        """Sets the additional_email_addresses of this ChangeUserRequest.

        The additional e-mail addresses of the user  # noqa: E501

        :param additional_email_addresses: The additional_email_addresses of this ChangeUserRequest.  # noqa: E501
        :type: list[Email]
        """

        self._additional_email_addresses = additional_email_addresses

    @property
    def instant_messaging_accounts(self):
        """Gets the instant_messaging_accounts of this ChangeUserRequest.  # noqa: E501

        The instant messaging accounts of the user  # noqa: E501

        :return: The instant_messaging_accounts of this ChangeUserRequest.  # noqa: E501
        :rtype: list[InstantMessagingAccount]
        """
        return self._instant_messaging_accounts

    @instant_messaging_accounts.setter
    def instant_messaging_accounts(self, instant_messaging_accounts):
        """Sets the instant_messaging_accounts of this ChangeUserRequest.

        The instant messaging accounts of the user  # noqa: E501

        :param instant_messaging_accounts: The instant_messaging_accounts of this ChangeUserRequest.  # noqa: E501
        :type: list[InstantMessagingAccount]
        """

        self._instant_messaging_accounts = instant_messaging_accounts

    @property
    def websites(self):
        """Gets the websites of this ChangeUserRequest.  # noqa: E501

        The websites of the user  # noqa: E501

        :return: The websites of this ChangeUserRequest.  # noqa: E501
        :rtype: list[Website]
        """
        return self._websites

    @websites.setter
    def websites(self, websites):
        """Sets the websites of this ChangeUserRequest.

        The websites of the user  # noqa: E501

        :param websites: The websites of this ChangeUserRequest.  # noqa: E501
        :type: list[Website]
        """

        self._websites = websites

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChangeUserRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChangeUserRequest):
            return True

        return self.to_dict() != other.to_dict()
