# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ChangeComplexRelationRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'legs': 'list[ComplexRelationLegRequest]',
        'relations': 'dict(str, list[RelatedAssetId])',
        'attributes': 'dict(str, list[AttributeValue])'
    }

    attribute_map = {
        'legs': 'legs',
        'relations': 'relations',
        'attributes': 'attributes'
    }

    def __init__(self, legs=None, relations=None, attributes=None, local_vars_configuration=None):  # noqa: E501
        """ChangeComplexRelationRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._legs = None
        self._relations = None
        self._attributes = None
        self.discriminator = None

        if legs is not None:
            self.legs = legs
        if relations is not None:
            self.relations = relations
        if attributes is not None:
            self.attributes = attributes

    @property
    def legs(self):
        """Gets the legs of this ChangeComplexRelationRequest.  # noqa: E501

        The new list of legs that the changed complex relation should contain.  # noqa: E501

        :return: The legs of this ChangeComplexRelationRequest.  # noqa: E501
        :rtype: list[ComplexRelationLegRequest]
        """
        return self._legs

    @legs.setter
    def legs(self, legs):
        """Sets the legs of this ChangeComplexRelationRequest.

        The new list of legs that the changed complex relation should contain.  # noqa: E501

        :param legs: The legs of this ChangeComplexRelationRequest.  # noqa: E501
        :type: list[ComplexRelationLegRequest]
        """

        self._legs = legs

    @property
    def relations(self):
        """Gets the relations of this ChangeComplexRelationRequest.  # noqa: E501

        The new relations that the new complex relation should contain.  # noqa: E501

        :return: The relations of this ChangeComplexRelationRequest.  # noqa: E501
        :rtype: dict(str, list[RelatedAssetId])
        """
        return self._relations

    @relations.setter
    def relations(self, relations):
        """Sets the relations of this ChangeComplexRelationRequest.

        The new relations that the new complex relation should contain.  # noqa: E501

        :param relations: The relations of this ChangeComplexRelationRequest.  # noqa: E501
        :type: dict(str, list[RelatedAssetId])
        """

        self._relations = relations

    @property
    def attributes(self):
        """Gets the attributes of this ChangeComplexRelationRequest.  # noqa: E501

        The new attributes that the new complex relation should contain.  # noqa: E501

        :return: The attributes of this ChangeComplexRelationRequest.  # noqa: E501
        :rtype: dict(str, list[AttributeValue])
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """Sets the attributes of this ChangeComplexRelationRequest.

        The new attributes that the new complex relation should contain.  # noqa: E501

        :param attributes: The attributes of this ChangeComplexRelationRequest.  # noqa: E501
        :type: dict(str, list[AttributeValue])
        """

        self._attributes = attributes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChangeComplexRelationRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChangeComplexRelationRequest):
            return True

        return self.to_dict() != other.to_dict()
