# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ChangeAttributeTypeRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'language': 'str',
        'statistics_enabled': 'bool',
        'is_integer': 'bool',
        'allowed_values': 'list[str]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'language': 'language',
        'statistics_enabled': 'statisticsEnabled',
        'is_integer': 'isInteger',
        'allowed_values': 'allowedValues'
    }

    def __init__(self, id=None, name=None, description=None, language=None, statistics_enabled=None, is_integer=None, allowed_values=None, local_vars_configuration=None):  # noqa: E501
        """ChangeAttributeTypeRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._description = None
        self._language = None
        self._statistics_enabled = None
        self._is_integer = None
        self._allowed_values = None
        self.discriminator = None

        self.id = id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if language is not None:
            self.language = language
        if statistics_enabled is not None:
            self.statistics_enabled = statistics_enabled
        if is_integer is not None:
            self.is_integer = is_integer
        if allowed_values is not None:
            self.allowed_values = allowed_values

    @property
    def id(self):
        """Gets the id of this ChangeAttributeTypeRequest.  # noqa: E501

        The ID of the Attribute Type to be changed. Silently ignored if the ID is provided as path parameter of the request.  # noqa: E501

        :return: The id of this ChangeAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ChangeAttributeTypeRequest.

        The ID of the Attribute Type to be changed. Silently ignored if the ID is provided as path parameter of the request.  # noqa: E501

        :param id: The id of this ChangeAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this ChangeAttributeTypeRequest.  # noqa: E501

        The new name for the Attribute Type.  # noqa: E501

        :return: The name of this ChangeAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ChangeAttributeTypeRequest.

        The new name for the Attribute Type.  # noqa: E501

        :param name: The name of this ChangeAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 255):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this ChangeAttributeTypeRequest.  # noqa: E501

        The new description for the Attribute Type.  # noqa: E501

        :return: The description of this ChangeAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ChangeAttributeTypeRequest.

        The new description for the Attribute Type.  # noqa: E501

        :param description: The description of this ChangeAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 4000):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `4000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def language(self):
        """Gets the language of this ChangeAttributeTypeRequest.  # noqa: E501

        The new language for the Attribute Type.  # noqa: E501

        :return: The language of this ChangeAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this ChangeAttributeTypeRequest.

        The new language for the Attribute Type.  # noqa: E501

        :param language: The language of this ChangeAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                language is not None and len(language) > 255):
            raise ValueError("Invalid value for `language`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                language is not None and len(language) < 0):
            raise ValueError("Invalid value for `language`, length must be greater than or equal to `0`")  # noqa: E501

        self._language = language

    @property
    def statistics_enabled(self):
        """Gets the statistics_enabled of this ChangeAttributeTypeRequest.  # noqa: E501

        Whether statistics should be enabled.  # noqa: E501

        :return: The statistics_enabled of this ChangeAttributeTypeRequest.  # noqa: E501
        :rtype: bool
        """
        return self._statistics_enabled

    @statistics_enabled.setter
    def statistics_enabled(self, statistics_enabled):
        """Sets the statistics_enabled of this ChangeAttributeTypeRequest.

        Whether statistics should be enabled.  # noqa: E501

        :param statistics_enabled: The statistics_enabled of this ChangeAttributeTypeRequest.  # noqa: E501
        :type: bool
        """

        self._statistics_enabled = statistics_enabled

    @property
    def is_integer(self):
        """Gets the is_integer of this ChangeAttributeTypeRequest.  # noqa: E501

        Whether Attribute Type holds integer value.  # noqa: E501

        :return: The is_integer of this ChangeAttributeTypeRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_integer

    @is_integer.setter
    def is_integer(self, is_integer):
        """Sets the is_integer of this ChangeAttributeTypeRequest.

        Whether Attribute Type holds integer value.  # noqa: E501

        :param is_integer: The is_integer of this ChangeAttributeTypeRequest.  # noqa: E501
        :type: bool
        """

        self._is_integer = is_integer

    @property
    def allowed_values(self):
        """Gets the allowed_values of this ChangeAttributeTypeRequest.  # noqa: E501

        List of allowed values.  # noqa: E501

        :return: The allowed_values of this ChangeAttributeTypeRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_values

    @allowed_values.setter
    def allowed_values(self, allowed_values):
        """Sets the allowed_values of this ChangeAttributeTypeRequest.

        List of allowed values.  # noqa: E501

        :param allowed_values: The allowed_values of this ChangeAttributeTypeRequest.  # noqa: E501
        :type: list[str]
        """

        self._allowed_values = allowed_values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChangeAttributeTypeRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChangeAttributeTypeRequest):
            return True

        return self.to_dict() != other.to_dict()
