# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AttributeType(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'name': 'str',
        'created_on': 'int',
        'last_modified_on': 'int',
        'resource_type': 'str',
        'created_by': 'str',
        'last_modified_by': 'str',
        'system': 'bool',
        'id': 'str'
    }

    attribute_map = {
        'description': 'description',
        'name': 'name',
        'created_on': 'createdOn',
        'last_modified_on': 'lastModifiedOn',
        'resource_type': 'resourceType',
        'created_by': 'createdBy',
        'last_modified_by': 'lastModifiedBy',
        'system': 'system',
        'id': 'id'
    }

    discriminator_value_class_map = {
        'BooleanAttributeType': 'BooleanAttributeType',
        'ScriptAttributeType': 'ScriptAttributeType',
        'SingleValueListAttributeType': 'SingleValueListAttributeType',
        'MultiValueListAttributeType': 'MultiValueListAttributeType',
        'DateAttributeType': 'DateAttributeType',
        'NumericAttributeType': 'NumericAttributeType',
        'StringAttributeType': 'StringAttributeType'
    }

    def __init__(self, description=None, name=None, created_on=None, last_modified_on=None, resource_type=None, created_by=None, last_modified_by=None, system=None, id=None, local_vars_configuration=None):  # noqa: E501
        """AttributeType - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._description = None
        self._name = None
        self._created_on = None
        self._last_modified_on = None
        self._resource_type = None
        self._created_by = None
        self._last_modified_by = None
        self._system = None
        self._id = None
        self.discriminator = 'resource_type'

        if description is not None:
            self.description = description
        if name is not None:
            self.name = name
        if created_on is not None:
            self.created_on = created_on
        if last_modified_on is not None:
            self.last_modified_on = last_modified_on
        if resource_type is not None:
            self.resource_type = resource_type
        if created_by is not None:
            self.created_by = created_by
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        if system is not None:
            self.system = system
        if id is not None:
            self.id = id

    @property
    def description(self):
        """Gets the description of this AttributeType.  # noqa: E501

        The description of the resource.  # noqa: E501

        :return: The description of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AttributeType.

        The description of the resource.  # noqa: E501

        :param description: The description of this AttributeType.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this AttributeType.  # noqa: E501

        The name of the resource.  # noqa: E501

        :return: The name of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AttributeType.

        The name of the resource.  # noqa: E501

        :param name: The name of this AttributeType.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def created_on(self):
        """Gets the created_on of this AttributeType.  # noqa: E501

        The timestamp (in UTC time standard) of the creation of this resource.  # noqa: E501

        :return: The created_on of this AttributeType.  # noqa: E501
        :rtype: int
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this AttributeType.

        The timestamp (in UTC time standard) of the creation of this resource.  # noqa: E501

        :param created_on: The created_on of this AttributeType.  # noqa: E501
        :type: int
        """

        self._created_on = created_on

    @property
    def last_modified_on(self):
        """Gets the last_modified_on of this AttributeType.  # noqa: E501

        The timestamp (in UTC time standard) of the last modification of this resource.  # noqa: E501

        :return: The last_modified_on of this AttributeType.  # noqa: E501
        :rtype: int
        """
        return self._last_modified_on

    @last_modified_on.setter
    def last_modified_on(self, last_modified_on):
        """Sets the last_modified_on of this AttributeType.

        The timestamp (in UTC time standard) of the last modification of this resource.  # noqa: E501

        :param last_modified_on: The last_modified_on of this AttributeType.  # noqa: E501
        :type: int
        """

        self._last_modified_on = last_modified_on

    @property
    def resource_type(self):
        """Gets the resource_type of this AttributeType.  # noqa: E501

        The type of this resource, i.e. [Community, Asset, Domain, Attribute, Relation, WorkflowInstance].  # noqa: E501

        :return: The resource_type of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this AttributeType.

        The type of this resource, i.e. [Community, Asset, Domain, Attribute, Relation, WorkflowInstance].  # noqa: E501

        :param resource_type: The resource_type of this AttributeType.  # noqa: E501
        :type: str
        """
        allowed_values = ["View", "Asset", "Community", "Domain", "AssetType", "DomainType", "Status", "User", "ClassificationMatch", "UserGroup", "Attribute", "StringAttribute", "ScriptAttribute", "BooleanAttribute", "DateAttribute", "NumericAttribute", "SingleValueListAttribute", "MultiValueListAttribute", "Comment", "Attachment", "Responsibility", "Workflow", "Job", "Relation", "RelationType", "ComplexRelation", "ComplexRelationType", "ArticulationRule", "Assignment", "Scope", "RelationTrace", "ValidationRule", "DataQualityRule", "DataQualityMetric", "Address", "InstantMessagingAccount", "Email", "PhoneNumber", "Website", "Activity", "FormProperty", "WorkflowTask", "ActivityChange", "WorkflowInstance", "Role", "AttributeType", "BooleanAttributeType", "DateAttributeType", "DateTimeAttributeType", "MultiValueListAttributeType", "NumericAttributeType", "ScriptAttributeType", "SingleValueListAttributeType", "StringAttributeType", "ViewSharingRule", "ViewAssignmentRule", "JdbcDriverFile", "JdbcDriver", "JdbcIngestionProperties", "CsvIngestionProperties", "ExcelIngestionProperties", "ConnectionStringParameter", "AssignedCharacteristicType", "Notification", "Tag", "ComplexRelationLegType", "ComplexRelationAttributeType", "ComplexRelationLeg", "BaseDataType", "AdvancedDataType", "DiagramPicture", "DiagramPictureSharingRule", "DiagramPictureAssignmentRule", "Rating", "Classification", "PhysicalDataConnector", "Context"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resource_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resource_type` ({0}), must be one of {1}"  # noqa: E501
                .format(resource_type, allowed_values)
            )

        self._resource_type = resource_type

    @property
    def created_by(self):
        """Gets the created_by of this AttributeType.  # noqa: E501

        The id of the user that created this resource.  # noqa: E501

        :return: The created_by of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this AttributeType.

        The id of the user that created this resource.  # noqa: E501

        :param created_by: The created_by of this AttributeType.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this AttributeType.  # noqa: E501

        The id of the user who modified this resource the last time.  # noqa: E501

        :return: The last_modified_by of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this AttributeType.

        The id of the user who modified this resource the last time.  # noqa: E501

        :param last_modified_by: The last_modified_by of this AttributeType.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def system(self):
        """Gets the system of this AttributeType.  # noqa: E501

        Whether this is a system resource or not.  # noqa: E501

        :return: The system of this AttributeType.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this AttributeType.

        Whether this is a system resource or not.  # noqa: E501

        :param system: The system of this AttributeType.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def id(self):
        """Gets the id of this AttributeType.  # noqa: E501

        The id of the represented object (entity).  # noqa: E501

        :return: The id of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AttributeType.

        The id of the represented object (entity).  # noqa: E501

        :param id: The id of this AttributeType.  # noqa: E501
        :type: str
        """

        self._id = id

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_key = self.attribute_map[self.discriminator]
        discriminator_value = data[discriminator_key]
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AttributeType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AttributeType):
            return True

        return self.to_dict() != other.to_dict()
