# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AssignedCharacteristicType(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'minimum_occurrences': 'int',
        'maximum_occurrences': 'int',
        'assigned_resource_id': 'str',
        'assigned_resource_type': 'str',
        'read_only': 'bool',
        'system': 'bool',
        'id': 'str'
    }

    attribute_map = {
        'minimum_occurrences': 'minimumOccurrences',
        'maximum_occurrences': 'maximumOccurrences',
        'assigned_resource_id': 'assignedResourceId',
        'assigned_resource_type': 'assignedResourceType',
        'read_only': 'readOnly',
        'system': 'system',
        'id': 'id'
    }

    discriminator_value_class_map = {
        'AssignedComplexRelationType': 'AssignedComplexRelationType',
        'AssignedAttributeType': 'AssignedAttributeType',
        'AssignedRelationType': 'AssignedRelationType'
    }

    def __init__(self, minimum_occurrences=None, maximum_occurrences=None, assigned_resource_id=None, assigned_resource_type=None, read_only=None, system=None, id=None, local_vars_configuration=None):  # noqa: E501
        """AssignedCharacteristicType - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._minimum_occurrences = None
        self._maximum_occurrences = None
        self._assigned_resource_id = None
        self._assigned_resource_type = None
        self._read_only = None
        self._system = None
        self._id = None
        self.discriminator = 'assigned_resource_type'

        if minimum_occurrences is not None:
            self.minimum_occurrences = minimum_occurrences
        if maximum_occurrences is not None:
            self.maximum_occurrences = maximum_occurrences
        if assigned_resource_id is not None:
            self.assigned_resource_id = assigned_resource_id
        self.assigned_resource_type = assigned_resource_type
        if read_only is not None:
            self.read_only = read_only
        if system is not None:
            self.system = system
        if id is not None:
            self.id = id

    @property
    def minimum_occurrences(self):
        """Gets the minimum_occurrences of this AssignedCharacteristicType.  # noqa: E501

        How many times at least the assigned characteristic must be added to the resource. Zero means no restriction.  # noqa: E501

        :return: The minimum_occurrences of this AssignedCharacteristicType.  # noqa: E501
        :rtype: int
        """
        return self._minimum_occurrences

    @minimum_occurrences.setter
    def minimum_occurrences(self, minimum_occurrences):
        """Sets the minimum_occurrences of this AssignedCharacteristicType.

        How many times at least the assigned characteristic must be added to the resource. Zero means no restriction.  # noqa: E501

        :param minimum_occurrences: The minimum_occurrences of this AssignedCharacteristicType.  # noqa: E501
        :type: int
        """

        self._minimum_occurrences = minimum_occurrences

    @property
    def maximum_occurrences(self):
        """Gets the maximum_occurrences of this AssignedCharacteristicType.  # noqa: E501

        How many times at least the assigned characteristic may be added to the resource. Null means no limit.  # noqa: E501

        :return: The maximum_occurrences of this AssignedCharacteristicType.  # noqa: E501
        :rtype: int
        """
        return self._maximum_occurrences

    @maximum_occurrences.setter
    def maximum_occurrences(self, maximum_occurrences):
        """Sets the maximum_occurrences of this AssignedCharacteristicType.

        How many times at least the assigned characteristic may be added to the resource. Null means no limit.  # noqa: E501

        :param maximum_occurrences: The maximum_occurrences of this AssignedCharacteristicType.  # noqa: E501
        :type: int
        """

        self._maximum_occurrences = maximum_occurrences

    @property
    def assigned_resource_id(self):
        """Gets the assigned_resource_id of this AssignedCharacteristicType.  # noqa: E501

        The id of the resource the characteristic refers to.  # noqa: E501

        :return: The assigned_resource_id of this AssignedCharacteristicType.  # noqa: E501
        :rtype: str
        """
        return self._assigned_resource_id

    @assigned_resource_id.setter
    def assigned_resource_id(self, assigned_resource_id):
        """Sets the assigned_resource_id of this AssignedCharacteristicType.

        The id of the resource the characteristic refers to.  # noqa: E501

        :param assigned_resource_id: The assigned_resource_id of this AssignedCharacteristicType.  # noqa: E501
        :type: str
        """

        self._assigned_resource_id = assigned_resource_id

    @property
    def assigned_resource_type(self):
        """Gets the assigned_resource_type of this AssignedCharacteristicType.  # noqa: E501

        The type of the resource the characteristic refers to. The value can be one of : AttributeType, RelationType or ComplexRelationType  # noqa: E501

        :return: The assigned_resource_type of this AssignedCharacteristicType.  # noqa: E501
        :rtype: str
        """
        return self._assigned_resource_type

    @assigned_resource_type.setter
    def assigned_resource_type(self, assigned_resource_type):
        """Sets the assigned_resource_type of this AssignedCharacteristicType.

        The type of the resource the characteristic refers to. The value can be one of : AttributeType, RelationType or ComplexRelationType  # noqa: E501

        :param assigned_resource_type: The assigned_resource_type of this AssignedCharacteristicType.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and assigned_resource_type is None:  # noqa: E501
            raise ValueError("Invalid value for `assigned_resource_type`, must not be `None`")  # noqa: E501
        allowed_values = ["View", "Asset", "Community", "Domain", "AssetType", "DomainType", "Status", "User", "ClassificationMatch", "UserGroup", "Attribute", "StringAttribute", "ScriptAttribute", "BooleanAttribute", "DateAttribute", "NumericAttribute", "SingleValueListAttribute", "MultiValueListAttribute", "Comment", "Attachment", "Responsibility", "Workflow", "Job", "Relation", "RelationType", "ComplexRelation", "ComplexRelationType", "ArticulationRule", "Assignment", "Scope", "RelationTrace", "ValidationRule", "DataQualityRule", "DataQualityMetric", "Address", "InstantMessagingAccount", "Email", "PhoneNumber", "Website", "Activity", "FormProperty", "WorkflowTask", "ActivityChange", "WorkflowInstance", "Role", "AttributeType", "BooleanAttributeType", "DateAttributeType", "DateTimeAttributeType", "MultiValueListAttributeType", "NumericAttributeType", "ScriptAttributeType", "SingleValueListAttributeType", "StringAttributeType", "ViewSharingRule", "ViewAssignmentRule", "JdbcDriverFile", "JdbcDriver", "JdbcIngestionProperties", "CsvIngestionProperties", "ExcelIngestionProperties", "ConnectionStringParameter", "AssignedCharacteristicType", "Notification", "Tag", "ComplexRelationLegType", "ComplexRelationAttributeType", "ComplexRelationLeg", "BaseDataType", "AdvancedDataType", "DiagramPicture", "DiagramPictureSharingRule", "DiagramPictureAssignmentRule", "Rating", "Classification", "PhysicalDataConnector", "Context"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and assigned_resource_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `assigned_resource_type` ({0}), must be one of {1}"  # noqa: E501
                .format(assigned_resource_type, allowed_values)
            )

        self._assigned_resource_type = assigned_resource_type

    @property
    def read_only(self):
        """Gets the read_only of this AssignedCharacteristicType.  # noqa: E501

        Whether the characteristic value of the assigned type can be edited by the user.  # noqa: E501

        :return: The read_only of this AssignedCharacteristicType.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this AssignedCharacteristicType.

        Whether the characteristic value of the assigned type can be edited by the user.  # noqa: E501

        :param read_only: The read_only of this AssignedCharacteristicType.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def system(self):
        """Gets the system of this AssignedCharacteristicType.  # noqa: E501

        Whether the characteristic type can be unassigned.  # noqa: E501

        :return: The system of this AssignedCharacteristicType.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this AssignedCharacteristicType.

        Whether the characteristic type can be unassigned.  # noqa: E501

        :param system: The system of this AssignedCharacteristicType.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def id(self):
        """Gets the id of this AssignedCharacteristicType.  # noqa: E501

        The id of the represented object (entity).  # noqa: E501

        :return: The id of this AssignedCharacteristicType.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AssignedCharacteristicType.

        The id of the represented object (entity).  # noqa: E501

        :param id: The id of this AssignedCharacteristicType.  # noqa: E501
        :type: str
        """

        self._id = id

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_key = self.attribute_map[self.discriminator]
        discriminator_value = data[discriminator_key]
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssignedCharacteristicType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssignedCharacteristicType):
            return True

        return self.to_dict() != other.to_dict()
