# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ApplicationInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'base_url': 'str',
        'build_number': 'str',
        'solutions': 'list[SolutionInfo]',
        'version': 'ApplicationVersionImpl'
    }

    attribute_map = {
        'base_url': 'baseUrl',
        'build_number': 'buildNumber',
        'solutions': 'solutions',
        'version': 'version'
    }

    def __init__(self, base_url=None, build_number=None, solutions=None, version=None, local_vars_configuration=None):  # noqa: E501
        """ApplicationInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._base_url = None
        self._build_number = None
        self._solutions = None
        self._version = None
        self.discriminator = None

        if base_url is not None:
            self.base_url = base_url
        if build_number is not None:
            self.build_number = build_number
        if solutions is not None:
            self.solutions = solutions
        if version is not None:
            self.version = version

    @property
    def base_url(self):
        """Gets the base_url of this ApplicationInfo.  # noqa: E501


        :return: The base_url of this ApplicationInfo.  # noqa: E501
        :rtype: str
        """
        return self._base_url

    @base_url.setter
    def base_url(self, base_url):
        """Sets the base_url of this ApplicationInfo.


        :param base_url: The base_url of this ApplicationInfo.  # noqa: E501
        :type: str
        """

        self._base_url = base_url

    @property
    def build_number(self):
        """Gets the build_number of this ApplicationInfo.  # noqa: E501


        :return: The build_number of this ApplicationInfo.  # noqa: E501
        :rtype: str
        """
        return self._build_number

    @build_number.setter
    def build_number(self, build_number):
        """Sets the build_number of this ApplicationInfo.


        :param build_number: The build_number of this ApplicationInfo.  # noqa: E501
        :type: str
        """

        self._build_number = build_number

    @property
    def solutions(self):
        """Gets the solutions of this ApplicationInfo.  # noqa: E501


        :return: The solutions of this ApplicationInfo.  # noqa: E501
        :rtype: list[SolutionInfo]
        """
        return self._solutions

    @solutions.setter
    def solutions(self, solutions):
        """Sets the solutions of this ApplicationInfo.


        :param solutions: The solutions of this ApplicationInfo.  # noqa: E501
        :type: list[SolutionInfo]
        """

        self._solutions = solutions

    @property
    def version(self):
        """Gets the version of this ApplicationInfo.  # noqa: E501


        :return: The version of this ApplicationInfo.  # noqa: E501
        :rtype: ApplicationVersionImpl
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ApplicationInfo.


        :param version: The version of this ApplicationInfo.  # noqa: E501
        :type: ApplicationVersionImpl
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApplicationInfo):
            return True

        return self.to_dict() != other.to_dict()
