# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddUserRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'user_name': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'email_address': 'str',
        'gender': 'str',
        'language': 'str',
        'user_group_ids': 'list[str]',
        'license_type': 'str',
        'addresses': 'list[Address]',
        'phones': 'list[PhoneNumber]',
        'additional_email_addresses': 'list[Email]',
        'instant_messaging_accounts': 'list[InstantMessagingAccount]',
        'websites': 'list[Website]'
    }

    attribute_map = {
        'user_name': 'userName',
        'first_name': 'firstName',
        'last_name': 'lastName',
        'email_address': 'emailAddress',
        'gender': 'gender',
        'language': 'language',
        'user_group_ids': 'userGroupIds',
        'license_type': 'licenseType',
        'addresses': 'addresses',
        'phones': 'phones',
        'additional_email_addresses': 'additionalEmailAddresses',
        'instant_messaging_accounts': 'instantMessagingAccounts',
        'websites': 'websites'
    }

    def __init__(self, user_name=None, first_name=None, last_name=None, email_address=None, gender=None, language=None, user_group_ids=None, license_type=None, addresses=None, phones=None, additional_email_addresses=None, instant_messaging_accounts=None, websites=None, local_vars_configuration=None):  # noqa: E501
        """AddUserRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._user_name = None
        self._first_name = None
        self._last_name = None
        self._email_address = None
        self._gender = None
        self._language = None
        self._user_group_ids = None
        self._license_type = None
        self._addresses = None
        self._phones = None
        self._additional_email_addresses = None
        self._instant_messaging_accounts = None
        self._websites = None
        self.discriminator = None

        self.user_name = user_name
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        self.email_address = email_address
        if gender is not None:
            self.gender = gender
        if language is not None:
            self.language = language
        if user_group_ids is not None:
            self.user_group_ids = user_group_ids
        if license_type is not None:
            self.license_type = license_type
        if addresses is not None:
            self.addresses = addresses
        if phones is not None:
            self.phones = phones
        if additional_email_addresses is not None:
            self.additional_email_addresses = additional_email_addresses
        if instant_messaging_accounts is not None:
            self.instant_messaging_accounts = instant_messaging_accounts
        if websites is not None:
            self.websites = websites

    @property
    def user_name(self):
        """Gets the user_name of this AddUserRequest.  # noqa: E501

        The username, which should be unique  # noqa: E501

        :return: The user_name of this AddUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """Sets the user_name of this AddUserRequest.

        The username, which should be unique  # noqa: E501

        :param user_name: The user_name of this AddUserRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_name is None:  # noqa: E501
            raise ValueError("Invalid value for `user_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                user_name is not None and len(user_name) > 255):
            raise ValueError("Invalid value for `user_name`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                user_name is not None and len(user_name) < 1):
            raise ValueError("Invalid value for `user_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._user_name = user_name

    @property
    def first_name(self):
        """Gets the first_name of this AddUserRequest.  # noqa: E501

        The first name of the new user  # noqa: E501

        :return: The first_name of this AddUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this AddUserRequest.

        The first name of the new user  # noqa: E501

        :param first_name: The first_name of this AddUserRequest.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this AddUserRequest.  # noqa: E501

        The last name of the new user  # noqa: E501

        :return: The last_name of this AddUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this AddUserRequest.

        The last name of the new user  # noqa: E501

        :param last_name: The last_name of this AddUserRequest.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def email_address(self):
        """Gets the email_address of this AddUserRequest.  # noqa: E501

        The e-mail address of the new user  # noqa: E501

        :return: The email_address of this AddUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._email_address

    @email_address.setter
    def email_address(self, email_address):
        """Sets the email_address of this AddUserRequest.

        The e-mail address of the new user  # noqa: E501

        :param email_address: The email_address of this AddUserRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and email_address is None:  # noqa: E501
            raise ValueError("Invalid value for `email_address`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                email_address is not None and len(email_address) > 255):
            raise ValueError("Invalid value for `email_address`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                email_address is not None and len(email_address) < 1):
            raise ValueError("Invalid value for `email_address`, length must be greater than or equal to `1`")  # noqa: E501

        self._email_address = email_address

    @property
    def gender(self):
        """Gets the gender of this AddUserRequest.  # noqa: E501

        The gender of the user  # noqa: E501

        :return: The gender of this AddUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._gender

    @gender.setter
    def gender(self, gender):
        """Sets the gender of this AddUserRequest.

        The gender of the user  # noqa: E501

        :param gender: The gender of this AddUserRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["MALE", "FEMALE", "UNKNOWN"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and gender not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `gender` ({0}), must be one of {1}"  # noqa: E501
                .format(gender, allowed_values)
            )

        self._gender = gender

    @property
    def language(self):
        """Gets the language of this AddUserRequest.  # noqa: E501

        The language for the user  # noqa: E501

        :return: The language of this AddUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this AddUserRequest.

        The language for the user  # noqa: E501

        :param language: The language of this AddUserRequest.  # noqa: E501
        :type: str
        """

        self._language = language

    @property
    def user_group_ids(self):
        """Gets the user_group_ids of this AddUserRequest.  # noqa: E501

        The groups this newly created user should be added to  # noqa: E501

        :return: The user_group_ids of this AddUserRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._user_group_ids

    @user_group_ids.setter
    def user_group_ids(self, user_group_ids):
        """Sets the user_group_ids of this AddUserRequest.

        The groups this newly created user should be added to  # noqa: E501

        :param user_group_ids: The user_group_ids of this AddUserRequest.  # noqa: E501
        :type: list[str]
        """

        self._user_group_ids = user_group_ids

    @property
    def license_type(self):
        """Gets the license_type of this AddUserRequest.  # noqa: E501

        The license type of the user. LicenseType will be removed in the future.  # noqa: E501

        :return: The license_type of this AddUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """Sets the license_type of this AddUserRequest.

        The license type of the user. LicenseType will be removed in the future.  # noqa: E501

        :param license_type: The license_type of this AddUserRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["CONSUMER", "AUTHOR"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and license_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `license_type` ({0}), must be one of {1}"  # noqa: E501
                .format(license_type, allowed_values)
            )

        self._license_type = license_type

    @property
    def addresses(self):
        """Gets the addresses of this AddUserRequest.  # noqa: E501

        The postal addresses of the user  # noqa: E501

        :return: The addresses of this AddUserRequest.  # noqa: E501
        :rtype: list[Address]
        """
        return self._addresses

    @addresses.setter
    def addresses(self, addresses):
        """Sets the addresses of this AddUserRequest.

        The postal addresses of the user  # noqa: E501

        :param addresses: The addresses of this AddUserRequest.  # noqa: E501
        :type: list[Address]
        """

        self._addresses = addresses

    @property
    def phones(self):
        """Gets the phones of this AddUserRequest.  # noqa: E501

        The phone numbers of the user  # noqa: E501

        :return: The phones of this AddUserRequest.  # noqa: E501
        :rtype: list[PhoneNumber]
        """
        return self._phones

    @phones.setter
    def phones(self, phones):
        """Sets the phones of this AddUserRequest.

        The phone numbers of the user  # noqa: E501

        :param phones: The phones of this AddUserRequest.  # noqa: E501
        :type: list[PhoneNumber]
        """

        self._phones = phones

    @property
    def additional_email_addresses(self):
        """Gets the additional_email_addresses of this AddUserRequest.  # noqa: E501

        The additional e-mail addresses of the user  # noqa: E501

        :return: The additional_email_addresses of this AddUserRequest.  # noqa: E501
        :rtype: list[Email]
        """
        return self._additional_email_addresses

    @additional_email_addresses.setter
    def additional_email_addresses(self, additional_email_addresses):
        """Sets the additional_email_addresses of this AddUserRequest.

        The additional e-mail addresses of the user  # noqa: E501

        :param additional_email_addresses: The additional_email_addresses of this AddUserRequest.  # noqa: E501
        :type: list[Email]
        """

        self._additional_email_addresses = additional_email_addresses

    @property
    def instant_messaging_accounts(self):
        """Gets the instant_messaging_accounts of this AddUserRequest.  # noqa: E501

        The instant messaging accounts of the user  # noqa: E501

        :return: The instant_messaging_accounts of this AddUserRequest.  # noqa: E501
        :rtype: list[InstantMessagingAccount]
        """
        return self._instant_messaging_accounts

    @instant_messaging_accounts.setter
    def instant_messaging_accounts(self, instant_messaging_accounts):
        """Sets the instant_messaging_accounts of this AddUserRequest.

        The instant messaging accounts of the user  # noqa: E501

        :param instant_messaging_accounts: The instant_messaging_accounts of this AddUserRequest.  # noqa: E501
        :type: list[InstantMessagingAccount]
        """

        self._instant_messaging_accounts = instant_messaging_accounts

    @property
    def websites(self):
        """Gets the websites of this AddUserRequest.  # noqa: E501

        The websites of the user  # noqa: E501

        :return: The websites of this AddUserRequest.  # noqa: E501
        :rtype: list[Website]
        """
        return self._websites

    @websites.setter
    def websites(self, websites):
        """Sets the websites of this AddUserRequest.

        The websites of the user  # noqa: E501

        :param websites: The websites of this AddUserRequest.  # noqa: E501
        :type: list[Website]
        """

        self._websites = websites

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddUserRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddUserRequest):
            return True

        return self.to_dict() != other.to_dict()
