# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddDomainRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'community_id': 'str',
        'type_id': 'str',
        'description': 'str',
        'id': 'str',
        'excluded_from_auto_hyperlinking': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'community_id': 'communityId',
        'type_id': 'typeId',
        'description': 'description',
        'id': 'id',
        'excluded_from_auto_hyperlinking': 'excludedFromAutoHyperlinking'
    }

    def __init__(self, name=None, community_id=None, type_id=None, description=None, id=None, excluded_from_auto_hyperlinking=None, local_vars_configuration=None):  # noqa: E501
        """AddDomainRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._community_id = None
        self._type_id = None
        self._description = None
        self._id = None
        self._excluded_from_auto_hyperlinking = None
        self.discriminator = None

        self.name = name
        self.community_id = community_id
        self.type_id = type_id
        if description is not None:
            self.description = description
        if id is not None:
            self.id = id
        if excluded_from_auto_hyperlinking is not None:
            self.excluded_from_auto_hyperlinking = excluded_from_auto_hyperlinking

    @property
    def name(self):
        """Gets the name of this AddDomainRequest.  # noqa: E501

        The name of the new domain. Should be unique within the community.  # noqa: E501

        :return: The name of this AddDomainRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AddDomainRequest.

        The name of the new domain. Should be unique within the community.  # noqa: E501

        :param name: The name of this AddDomainRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 255):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def community_id(self):
        """Gets the community_id of this AddDomainRequest.  # noqa: E501

        The ID of the community that the new domain should be added to.  # noqa: E501

        :return: The community_id of this AddDomainRequest.  # noqa: E501
        :rtype: str
        """
        return self._community_id

    @community_id.setter
    def community_id(self, community_id):
        """Sets the community_id of this AddDomainRequest.

        The ID of the community that the new domain should be added to.  # noqa: E501

        :param community_id: The community_id of this AddDomainRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and community_id is None:  # noqa: E501
            raise ValueError("Invalid value for `community_id`, must not be `None`")  # noqa: E501

        self._community_id = community_id

    @property
    def type_id(self):
        """Gets the type_id of this AddDomainRequest.  # noqa: E501

        The ID of the domain type of the new domain.  # noqa: E501

        :return: The type_id of this AddDomainRequest.  # noqa: E501
        :rtype: str
        """
        return self._type_id

    @type_id.setter
    def type_id(self, type_id):
        """Sets the type_id of this AddDomainRequest.

        The ID of the domain type of the new domain.  # noqa: E501

        :param type_id: The type_id of this AddDomainRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `type_id`, must not be `None`")  # noqa: E501

        self._type_id = type_id

    @property
    def description(self):
        """Gets the description of this AddDomainRequest.  # noqa: E501

        The description of the new domain.  # noqa: E501

        :return: The description of this AddDomainRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AddDomainRequest.

        The description of the new domain.  # noqa: E501

        :param description: The description of this AddDomainRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """Gets the id of this AddDomainRequest.  # noqa: E501

        The ID of the new domain. Should be unique within all domains.<br/>It should have a format of universally unique identifier (UUID) and should not start with <code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :return: The id of this AddDomainRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AddDomainRequest.

        The ID of the new domain. Should be unique within all domains.<br/>It should have a format of universally unique identifier (UUID) and should not start with <code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :param id: The id of this AddDomainRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def excluded_from_auto_hyperlinking(self):
        """Gets the excluded_from_auto_hyperlinking of this AddDomainRequest.  # noqa: E501


        :return: The excluded_from_auto_hyperlinking of this AddDomainRequest.  # noqa: E501
        :rtype: bool
        """
        return self._excluded_from_auto_hyperlinking

    @excluded_from_auto_hyperlinking.setter
    def excluded_from_auto_hyperlinking(self, excluded_from_auto_hyperlinking):
        """Sets the excluded_from_auto_hyperlinking of this AddDomainRequest.


        :param excluded_from_auto_hyperlinking: The excluded_from_auto_hyperlinking of this AddDomainRequest.  # noqa: E501
        :type: bool
        """

        self._excluded_from_auto_hyperlinking = excluded_from_auto_hyperlinking

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddDomainRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddDomainRequest):
            return True

        return self.to_dict() != other.to_dict()
