# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddCommunityRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'parent_id': 'str',
        'name': 'str',
        'description': 'str',
        'id': 'str'
    }

    attribute_map = {
        'parent_id': 'parentId',
        'name': 'name',
        'description': 'description',
        'id': 'id'
    }

    def __init__(self, parent_id=None, name=None, description=None, id=None, local_vars_configuration=None):  # noqa: E501
        """AddCommunityRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._parent_id = None
        self._name = None
        self._description = None
        self._id = None
        self.discriminator = None

        if parent_id is not None:
            self.parent_id = parent_id
        self.name = name
        if description is not None:
            self.description = description
        if id is not None:
            self.id = id

    @property
    def parent_id(self):
        """Gets the parent_id of this AddCommunityRequest.  # noqa: E501

        The ID of the parent for the new community  # noqa: E501

        :return: The parent_id of this AddCommunityRequest.  # noqa: E501
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this AddCommunityRequest.

        The ID of the parent for the new community  # noqa: E501

        :param parent_id: The parent_id of this AddCommunityRequest.  # noqa: E501
        :type: str
        """

        self._parent_id = parent_id

    @property
    def name(self):
        """Gets the name of this AddCommunityRequest.  # noqa: E501

        The name of the new community. Should be unique across all communities  # noqa: E501

        :return: The name of this AddCommunityRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AddCommunityRequest.

        The name of the new community. Should be unique across all communities  # noqa: E501

        :param name: The name of this AddCommunityRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 255):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this AddCommunityRequest.  # noqa: E501

        The description of the new community  # noqa: E501

        :return: The description of this AddCommunityRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AddCommunityRequest.

        The description of the new community  # noqa: E501

        :param description: The description of this AddCommunityRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """Gets the id of this AddCommunityRequest.  # noqa: E501

        The ID of the new community. Should be unique within all communities.<br/>It should have a format of universally unique identifier (UUID) and should not start with <code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :return: The id of this AddCommunityRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AddCommunityRequest.

        The ID of the new community. Should be unique within all communities.<br/>It should have a format of universally unique identifier (UUID) and should not start with <code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :param id: The id of this AddCommunityRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddCommunityRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddCommunityRequest):
            return True

        return self.to_dict() != other.to_dict()
