# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddAttributeTypeRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'kind': 'str',
        'language': 'str',
        'statistics_enabled': 'bool',
        'allowed_values': 'list[str]',
        'string_type': 'str',
        'id_string': 'str',
        'is_integer': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'kind': 'kind',
        'language': 'language',
        'statistics_enabled': 'statisticsEnabled',
        'allowed_values': 'allowedValues',
        'string_type': 'stringType',
        'id_string': 'idString',
        'is_integer': 'isInteger'
    }

    def __init__(self, id=None, name=None, description=None, kind=None, language=None, statistics_enabled=None, allowed_values=None, string_type=None, id_string=None, is_integer=None, local_vars_configuration=None):  # noqa: E501
        """AddAttributeTypeRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._description = None
        self._kind = None
        self._language = None
        self._statistics_enabled = None
        self._allowed_values = None
        self._string_type = None
        self._id_string = None
        self._is_integer = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        if description is not None:
            self.description = description
        self.kind = kind
        if language is not None:
            self.language = language
        if statistics_enabled is not None:
            self.statistics_enabled = statistics_enabled
        if allowed_values is not None:
            self.allowed_values = allowed_values
        if string_type is not None:
            self.string_type = string_type
        if id_string is not None:
            self.id_string = id_string
        if is_integer is not None:
            self.is_integer = is_integer

    @property
    def id(self):
        """Gets the id of this AddAttributeTypeRequest.  # noqa: E501

        The ID of the new Attribute Type. Should be unique within all Attribute Types.<br/>It should have a format of universally unique identifier (UUID) and should not start with <code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :return: The id of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AddAttributeTypeRequest.

        The ID of the new Attribute Type. Should be unique within all Attribute Types.<br/>It should have a format of universally unique identifier (UUID) and should not start with <code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :param id: The id of this AddAttributeTypeRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this AddAttributeTypeRequest.  # noqa: E501

        The name of the new Attribute Type. Should be unique within all Attribute Types.  # noqa: E501

        :return: The name of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AddAttributeTypeRequest.

        The name of the new Attribute Type. Should be unique within all Attribute Types.  # noqa: E501

        :param name: The name of this AddAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 255):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this AddAttributeTypeRequest.  # noqa: E501

        The description of the new Attribute Type.  # noqa: E501

        :return: The description of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AddAttributeTypeRequest.

        The description of the new Attribute Type.  # noqa: E501

        :param description: The description of this AddAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 4000):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `4000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def kind(self):
        """Gets the kind of this AddAttributeTypeRequest.  # noqa: E501

        The kind of the new Attribute Type.  # noqa: E501

        :return: The kind of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """Sets the kind of this AddAttributeTypeRequest.

        The kind of the new Attribute Type.  # noqa: E501

        :param kind: The kind of this AddAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and kind is None:  # noqa: E501
            raise ValueError("Invalid value for `kind`, must not be `None`")  # noqa: E501
        allowed_values = ["BOOLEAN", "STRING", "NUMERIC", "DATE", "SINGLE_VALUE_LIST", "MULTI_VALUE_LIST", "SCRIPT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and kind not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `kind` ({0}), must be one of {1}"  # noqa: E501
                .format(kind, allowed_values)
            )

        self._kind = kind

    @property
    def language(self):
        """Gets the language of this AddAttributeTypeRequest.  # noqa: E501

        The language of the new Attribute Type (only applicable for Script Attribute Type).  # noqa: E501

        :return: The language of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this AddAttributeTypeRequest.

        The language of the new Attribute Type (only applicable for Script Attribute Type).  # noqa: E501

        :param language: The language of this AddAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                language is not None and len(language) > 255):
            raise ValueError("Invalid value for `language`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                language is not None and len(language) < 0):
            raise ValueError("Invalid value for `language`, length must be greater than or equal to `0`")  # noqa: E501

        self._language = language

    @property
    def statistics_enabled(self):
        """Gets the statistics_enabled of this AddAttributeTypeRequest.  # noqa: E501

        Whether statistics should be enabled.  # noqa: E501

        :return: The statistics_enabled of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: bool
        """
        return self._statistics_enabled

    @statistics_enabled.setter
    def statistics_enabled(self, statistics_enabled):
        """Sets the statistics_enabled of this AddAttributeTypeRequest.

        Whether statistics should be enabled.  # noqa: E501

        :param statistics_enabled: The statistics_enabled of this AddAttributeTypeRequest.  # noqa: E501
        :type: bool
        """

        self._statistics_enabled = statistics_enabled

    @property
    def allowed_values(self):
        """Gets the allowed_values of this AddAttributeTypeRequest.  # noqa: E501

        List of allowed values.  # noqa: E501

        :return: The allowed_values of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_values

    @allowed_values.setter
    def allowed_values(self, allowed_values):
        """Sets the allowed_values of this AddAttributeTypeRequest.

        List of allowed values.  # noqa: E501

        :param allowed_values: The allowed_values of this AddAttributeTypeRequest.  # noqa: E501
        :type: list[str]
        """

        self._allowed_values = allowed_values

    @property
    def string_type(self):
        """Gets the string_type of this AddAttributeTypeRequest.  # noqa: E501

        Rich text or plain text (only applicable for String Attribute Type).  # noqa: E501

        :return: The string_type of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._string_type

    @string_type.setter
    def string_type(self, string_type):
        """Sets the string_type of this AddAttributeTypeRequest.

        Rich text or plain text (only applicable for String Attribute Type).  # noqa: E501

        :param string_type: The string_type of this AddAttributeTypeRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["RICH_TEXT", "PLAIN_TEXT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and string_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `string_type` ({0}), must be one of {1}"  # noqa: E501
                .format(string_type, allowed_values)
            )

        self._string_type = string_type

    @property
    def id_string(self):
        """Gets the id_string of this AddAttributeTypeRequest.  # noqa: E501

        The ID of the Attribute Type. This field will be removed in the future.  # noqa: E501

        :return: The id_string of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._id_string

    @id_string.setter
    def id_string(self, id_string):
        """Sets the id_string of this AddAttributeTypeRequest.

        The ID of the Attribute Type. This field will be removed in the future.  # noqa: E501

        :param id_string: The id_string of this AddAttributeTypeRequest.  # noqa: E501
        :type: str
        """

        self._id_string = id_string

    @property
    def is_integer(self):
        """Gets the is_integer of this AddAttributeTypeRequest.  # noqa: E501

        Whether Attribute Type holds an integer value.  # noqa: E501

        :return: The is_integer of this AddAttributeTypeRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_integer

    @is_integer.setter
    def is_integer(self, is_integer):
        """Sets the is_integer of this AddAttributeTypeRequest.

        Whether Attribute Type holds an integer value.  # noqa: E501

        :param is_integer: The is_integer of this AddAttributeTypeRequest.  # noqa: E501
        :type: bool
        """

        self._is_integer = is_integer

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddAttributeTypeRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddAttributeTypeRequest):
            return True

        return self.to_dict() != other.to_dict()
