# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_core.api_client import ApiClient
from collibra_core.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WorkflowInstancesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_workflow_instances(self, workflow_instance_id, **kwargs):  # noqa: E501
        """Cancel workflow instance.  # noqa: E501

        Cancels the workflow instance with the specified ID with a reason. Canceling the workflow instance also cancels the workflow sub-processes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_workflow_instances(workflow_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_instance_id: The identifier of the workflow instance to be cancelled. (required)
        :param str body: The reason for the cancellation of the workflow instance.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_workflow_instances_with_http_info(workflow_instance_id, **kwargs)  # noqa: E501

    def cancel_workflow_instances_with_http_info(self, workflow_instance_id, **kwargs):  # noqa: E501
        """Cancel workflow instance.  # noqa: E501

        Cancels the workflow instance with the specified ID with a reason. Canceling the workflow instance also cancels the workflow sub-processes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_workflow_instances_with_http_info(workflow_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_instance_id: The identifier of the workflow instance to be cancelled. (required)
        :param str body: The reason for the cancellation of the workflow instance.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_instance_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_workflow_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_instance_id' is set
        if self.api_client.client_side_validation and ('workflow_instance_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_instance_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_instance_id` when calling `cancel_workflow_instances`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_instance_id' in local_var_params:
            path_params['workflowInstanceId'] = local_var_params['workflow_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowInstances/{workflowInstanceId}/canceled', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_workflow_instances(self, **kwargs):  # noqa: E501
        """Find workflow instances.  # noqa: E501

        Returns workflow instances matching given search criteria.<p>Only parameters that are specified in this request and have not <code>null</code> values are used for filtering. All other parameters are ignored. The returned workflow instances satisfy all constraints that are specified in this search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_workflow_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param str business_item_name: The display name of the business item that should be contained by the searched workflows.
        :param str business_item_id: The ID of the business item that should be contained by the searched workflows.
        :param str workflow_definition_id: The ID of the workflow definition.
        :param str sort_field: The field on which the results are sorted.
        :param str sort_order: The sorting order.
        :param str parent_workflow_instance_id: The ID of the parent workflow instance.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_workflow_instances_with_http_info(**kwargs)  # noqa: E501

    def find_workflow_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Find workflow instances.  # noqa: E501

        Returns workflow instances matching given search criteria.<p>Only parameters that are specified in this request and have not <code>null</code> values are used for filtering. All other parameters are ignored. The returned workflow instances satisfy all constraints that are specified in this search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_workflow_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param str business_item_name: The display name of the business item that should be contained by the searched workflows.
        :param str business_item_id: The ID of the business item that should be contained by the searched workflows.
        :param str workflow_definition_id: The ID of the workflow definition.
        :param str sort_field: The field on which the results are sorted.
        :param str sort_order: The sorting order.
        :param str parent_workflow_instance_id: The ID of the parent workflow instance.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'offset',
            'limit',
            'count_limit',
            'business_item_name',
            'business_item_id',
            'workflow_definition_id',
            'sort_field',
            'sort_order',
            'parent_workflow_instance_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_workflow_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'count_limit' in local_var_params and local_var_params['count_limit'] is not None:  # noqa: E501
            query_params.append(('countLimit', local_var_params['count_limit']))  # noqa: E501
        if 'business_item_name' in local_var_params and local_var_params['business_item_name'] is not None:  # noqa: E501
            query_params.append(('businessItemName', local_var_params['business_item_name']))  # noqa: E501
        if 'business_item_id' in local_var_params and local_var_params['business_item_id'] is not None:  # noqa: E501
            query_params.append(('businessItemId', local_var_params['business_item_id']))  # noqa: E501
        if 'workflow_definition_id' in local_var_params and local_var_params['workflow_definition_id'] is not None:  # noqa: E501
            query_params.append(('workflowDefinitionId', local_var_params['workflow_definition_id']))  # noqa: E501
        if 'sort_field' in local_var_params and local_var_params['sort_field'] is not None:  # noqa: E501
            query_params.append(('sortField', local_var_params['sort_field']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'parent_workflow_instance_id' in local_var_params and local_var_params['parent_workflow_instance_id'] is not None:  # noqa: E501
            query_params.append(('parentWorkflowInstanceId', local_var_params['parent_workflow_instance_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowInstances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_instance_diagram(self, workflow_instance_id, **kwargs):  # noqa: E501
        """Returns the file representing the diagram of workflow instance identified by the given ID.  # noqa: E501

        Returns the file representing the diagram of workflow instance identified by the given ID. The diagram input stream returned can be null as deployed workflow defintions without graphical notation included don't have a diagram  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_instance_diagram(workflow_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_instance_id: The ID of the workflow instance to return the diagram for. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_instance_diagram_with_http_info(workflow_instance_id, **kwargs)  # noqa: E501

    def get_workflow_instance_diagram_with_http_info(self, workflow_instance_id, **kwargs):  # noqa: E501
        """Returns the file representing the diagram of workflow instance identified by the given ID.  # noqa: E501

        Returns the file representing the diagram of workflow instance identified by the given ID. The diagram input stream returned can be null as deployed workflow defintions without graphical notation included don't have a diagram  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_instance_diagram_with_http_info(workflow_instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_instance_id: The ID of the workflow instance to return the diagram for. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_instance_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_instance_diagram" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_instance_id' is set
        if self.api_client.client_side_validation and ('workflow_instance_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_instance_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_instance_id` when calling `get_workflow_instance_diagram`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_instance_id' in local_var_params:
            path_params['workflowInstanceId'] = local_var_params['workflow_instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/png'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowInstances/{workflowInstanceId}/diagram', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def message_event_received(self, process_instance_id, message_name, **kwargs):  # noqa: E501
        """Pass message event to workflow engine.  # noqa: E501

        Passes the message event to the workflow engine. It will pass on this specific event to the engine with the given name, process instance and variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.message_event_received(process_instance_id, message_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_id: The ID of an instance of a process. Given process instance should have only one execution running at the time. Otherwise this method will fail. (required)
        :param str message_name: The name of the message to trigger. (required)
        :param MessageEventReceivedRequest message_event_received_request: The properties of the message event to be received.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.message_event_received_with_http_info(process_instance_id, message_name, **kwargs)  # noqa: E501

    def message_event_received_with_http_info(self, process_instance_id, message_name, **kwargs):  # noqa: E501
        """Pass message event to workflow engine.  # noqa: E501

        Passes the message event to the workflow engine. It will pass on this specific event to the engine with the given name, process instance and variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.message_event_received_with_http_info(process_instance_id, message_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_id: The ID of an instance of a process. Given process instance should have only one execution running at the time. Otherwise this method will fail. (required)
        :param str message_name: The name of the message to trigger. (required)
        :param MessageEventReceivedRequest message_event_received_request: The properties of the message event to be received.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_instance_id',
            'message_name',
            'message_event_received_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method message_event_received" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'process_instance_id' is set
        if self.api_client.client_side_validation and ('process_instance_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['process_instance_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `process_instance_id` when calling `message_event_received`")  # noqa: E501
        # verify the required parameter 'message_name' is set
        if self.api_client.client_side_validation and ('message_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['message_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `message_name` when calling `message_event_received`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'process_instance_id' in local_var_params:
            path_params['processInstanceId'] = local_var_params['process_instance_id']  # noqa: E501
        if 'message_name' in local_var_params:
            path_params['messageName'] = local_var_params['message_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'message_event_received_request' in local_var_params:
            body_params = local_var_params['message_event_received_request']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowInstances/{processInstanceId}/messageEvents/{messageName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_workflow_instances(self, **kwargs):  # noqa: E501
        """Start workflow instances.  # noqa: E501

        Starts multiple workflow instances based on the provided request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_workflow_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StartWorkflowInstancesRequest start_workflow_instances_request: The properties of the workflow to be started.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[WorkflowInstance]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.start_workflow_instances_with_http_info(**kwargs)  # noqa: E501

    def start_workflow_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Start workflow instances.  # noqa: E501

        Starts multiple workflow instances based on the provided request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_workflow_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StartWorkflowInstancesRequest start_workflow_instances_request: The properties of the workflow to be started.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[WorkflowInstance], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'start_workflow_instances_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_workflow_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'start_workflow_instances_request' in local_var_params:
            body_params = local_var_params['start_workflow_instances_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowInstances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WorkflowInstance]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_workflow_instances_in_job(self, **kwargs):  # noqa: E501
        """Start workflow instances.  # noqa: E501

        Starts multiple workflow instances asynchronously based on the provided request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_workflow_instances_in_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StartWorkflowInstancesRequest start_workflow_instances_request: Properties of the workflow to be started.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.start_workflow_instances_in_job_with_http_info(**kwargs)  # noqa: E501

    def start_workflow_instances_in_job_with_http_info(self, **kwargs):  # noqa: E501
        """Start workflow instances.  # noqa: E501

        Starts multiple workflow instances asynchronously based on the provided request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_workflow_instances_in_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StartWorkflowInstancesRequest start_workflow_instances_request: Properties of the workflow to be started.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Job, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'start_workflow_instances_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_workflow_instances_in_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'start_workflow_instances_request' in local_var_params:
            body_params = local_var_params['start_workflow_instances_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowInstances/startJobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
