# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_core.api_client import ApiClient
from collibra_core.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WorkflowDefinitionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_asset_type_assignment_rule(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Add asset type assignment rule.  # noqa: E501

        Adds an asset type assignment rule to the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_asset_type_assignment_rule(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param AddAssetTypeAssignmentRuleRequest add_asset_type_assignment_rule_request: The request describing assignment rule to be added.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetAssignmentRuleImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_asset_type_assignment_rule_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def add_asset_type_assignment_rule_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Add asset type assignment rule.  # noqa: E501

        Adds an asset type assignment rule to the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_asset_type_assignment_rule_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param AddAssetTypeAssignmentRuleRequest add_asset_type_assignment_rule_request: The request describing assignment rule to be added.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetAssignmentRuleImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id',
            'add_asset_type_assignment_rule_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_asset_type_assignment_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `add_asset_type_assignment_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_asset_type_assignment_rule_request' in local_var_params:
            body_params = local_var_params['add_asset_type_assignment_rule_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}/assetTypeAssignmentRules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetAssignmentRuleImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_domain_type_assignment_rule(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Add domain type assignment rule.  # noqa: E501

        Adds a domain type assignment rule to the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_domain_type_assignment_rule(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param AddDomainTypeAssignmentRuleRequest add_domain_type_assignment_rule_request: The request describing assignment rule to be added.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetAssignmentRuleImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_domain_type_assignment_rule_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def add_domain_type_assignment_rule_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Add domain type assignment rule.  # noqa: E501

        Adds a domain type assignment rule to the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_domain_type_assignment_rule_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param AddDomainTypeAssignmentRuleRequest add_domain_type_assignment_rule_request: The request describing assignment rule to be added.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetAssignmentRuleImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id',
            'add_domain_type_assignment_rule_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_domain_type_assignment_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `add_domain_type_assignment_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_domain_type_assignment_rule_request' in local_var_params:
            body_params = local_var_params['add_domain_type_assignment_rule_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}/domainTypeAssignmentRules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetAssignmentRuleImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_asset_type_assignment_rule(self, workflow_definition_id, rule_id, **kwargs):  # noqa: E501
        """Change asset type assignment rule.  # noqa: E501

        Modifies the asset type assignment rule with the specified ID of the workflow definition with the specified ID.<p>Only properties that are specified in this request and have not <code>null</code> values are updated.<p>All other properties are ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_asset_type_assignment_rule(workflow_definition_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param str rule_id: The ID of the assignment rule to be changed. (required)
        :param ChangeAssetTypeAssignmentRuleRequest change_asset_type_assignment_rule_request: Parameters for the assignment rule to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetAssignmentRuleImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_asset_type_assignment_rule_with_http_info(workflow_definition_id, rule_id, **kwargs)  # noqa: E501

    def change_asset_type_assignment_rule_with_http_info(self, workflow_definition_id, rule_id, **kwargs):  # noqa: E501
        """Change asset type assignment rule.  # noqa: E501

        Modifies the asset type assignment rule with the specified ID of the workflow definition with the specified ID.<p>Only properties that are specified in this request and have not <code>null</code> values are updated.<p>All other properties are ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_asset_type_assignment_rule_with_http_info(workflow_definition_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param str rule_id: The ID of the assignment rule to be changed. (required)
        :param ChangeAssetTypeAssignmentRuleRequest change_asset_type_assignment_rule_request: Parameters for the assignment rule to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetAssignmentRuleImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id',
            'rule_id',
            'change_asset_type_assignment_rule_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_asset_type_assignment_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `change_asset_type_assignment_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if self.api_client.client_side_validation and ('rule_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_id` when calling `change_asset_type_assignment_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501
        if 'rule_id' in local_var_params:
            path_params['ruleId'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_asset_type_assignment_rule_request' in local_var_params:
            body_params = local_var_params['change_asset_type_assignment_rule_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}/assetTypeAssignmentRules/{ruleId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetAssignmentRuleImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_domain_type_assignment_rule(self, workflow_definition_id, rule_id, **kwargs):  # noqa: E501
        """Change domain type assignment rule.  # noqa: E501

        Modifies the domain type assignment rule with the specified ID of the workflow definition with the specified ID.<p>Only properties that are specified in this request and have not <code>null</code> values are updated.<p>All other properties are ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_domain_type_assignment_rule(workflow_definition_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param str rule_id: The ID of the assignment rule to be changed. (required)
        :param ChangeDomainTypeAssignmentRuleRequest change_domain_type_assignment_rule_request: Parameters for the assignment rule to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetAssignmentRuleImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_domain_type_assignment_rule_with_http_info(workflow_definition_id, rule_id, **kwargs)  # noqa: E501

    def change_domain_type_assignment_rule_with_http_info(self, workflow_definition_id, rule_id, **kwargs):  # noqa: E501
        """Change domain type assignment rule.  # noqa: E501

        Modifies the domain type assignment rule with the specified ID of the workflow definition with the specified ID.<p>Only properties that are specified in this request and have not <code>null</code> values are updated.<p>All other properties are ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_domain_type_assignment_rule_with_http_info(workflow_definition_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param str rule_id: The ID of the assignment rule to be changed. (required)
        :param ChangeDomainTypeAssignmentRuleRequest change_domain_type_assignment_rule_request: Parameters for the assignment rule to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetAssignmentRuleImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id',
            'rule_id',
            'change_domain_type_assignment_rule_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_domain_type_assignment_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `change_domain_type_assignment_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if self.api_client.client_side_validation and ('rule_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_id` when calling `change_domain_type_assignment_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501
        if 'rule_id' in local_var_params:
            path_params['ruleId'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_domain_type_assignment_rule_request' in local_var_params:
            body_params = local_var_params['change_domain_type_assignment_rule_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}/domainTypeAssignmentRules/{ruleId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetAssignmentRuleImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_workflow_definition(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Change workflow definition.  # noqa: E501

        Modifies the workflow definition with the specified ID.<p>Only properties that are specified in this request and have not <code>null</code> values are updated.<p>All other properties are ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_workflow_definition(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param ChangeWorkflowDefinitionRequest change_workflow_definition_request: Parameters for the workflow definition to be changed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowDefinitionImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_workflow_definition_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def change_workflow_definition_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Change workflow definition.  # noqa: E501

        Modifies the workflow definition with the specified ID.<p>Only properties that are specified in this request and have not <code>null</code> values are updated.<p>All other properties are ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_workflow_definition_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param ChangeWorkflowDefinitionRequest change_workflow_definition_request: Parameters for the workflow definition to be changed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowDefinitionImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id',
            'change_workflow_definition_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_workflow_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `change_workflow_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_workflow_definition_request' in local_var_params:
            body_params = local_var_params['change_workflow_definition_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowDefinitionImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deploy_workflow_definition(self, **kwargs):  # noqa: E501
        """Deploy workflow definition.  # noqa: E501

        Deploys workflow definition (the business process and resources) using the specified request.<p> The input stream can represent a single file(e.g: .bpmn20.xml or .bpmn) or an archive file (e.g: .zip or .bar). It is not allowed to deploy a resource containing more than one process definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deploy_workflow_definition(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param file file: The file with described workflow definition.
        :param str file_name: The name of the file.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowDefinitionImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deploy_workflow_definition_with_http_info(**kwargs)  # noqa: E501

    def deploy_workflow_definition_with_http_info(self, **kwargs):  # noqa: E501
        """Deploy workflow definition.  # noqa: E501

        Deploys workflow definition (the business process and resources) using the specified request.<p> The input stream can represent a single file(e.g: .bpmn20.xml or .bpmn) or an archive file (e.g: .zip or .bar). It is not allowed to deploy a resource containing more than one process definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deploy_workflow_definition_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param file file: The file with described workflow definition.
        :param str file_name: The name of the file.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowDefinitionImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'file',
            'file_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_workflow_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'file_name' in local_var_params:
            form_params.append(('fileName', local_var_params['file_name']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowDefinitionImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_workflow_definitions(self, **kwargs):  # noqa: E501
        """Find workflow definitions.  # noqa: E501

        Finds the workflow definitions matching the criteria described in the request object. By default, the result contains up to 1000 workflow definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_workflow_definitions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param list[str] asset_id: The list of the IDs of business items (assets) for which the workflow definitions should be found.
        :param list[str] domain_id: The list of the IDs of business items (domains) for which the workflow definitions should be found.
        :param list[str] community_id: The list of the IDs of business items (communities) for which the workflow definitions should be found.
        :param bool enabled: Whether the found workflow definitions should be enabled.
        :param bool _global: Whether the found workflow definitions should be global.
        :param str name: The name (could be partial) of the workflow definition to search for.
        :param str sort_order: The sorting order.
        :param str description: The description (could be partial) of the workflow definition to search for.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowDefinitionPagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_workflow_definitions_with_http_info(**kwargs)  # noqa: E501

    def find_workflow_definitions_with_http_info(self, **kwargs):  # noqa: E501
        """Find workflow definitions.  # noqa: E501

        Finds the workflow definitions matching the criteria described in the request object. By default, the result contains up to 1000 workflow definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_workflow_definitions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param list[str] asset_id: The list of the IDs of business items (assets) for which the workflow definitions should be found.
        :param list[str] domain_id: The list of the IDs of business items (domains) for which the workflow definitions should be found.
        :param list[str] community_id: The list of the IDs of business items (communities) for which the workflow definitions should be found.
        :param bool enabled: Whether the found workflow definitions should be enabled.
        :param bool _global: Whether the found workflow definitions should be global.
        :param str name: The name (could be partial) of the workflow definition to search for.
        :param str sort_order: The sorting order.
        :param str description: The description (could be partial) of the workflow definition to search for.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowDefinitionPagedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'offset',
            'limit',
            'count_limit',
            'asset_id',
            'domain_id',
            'community_id',
            'enabled',
            '_global',
            'name',
            'sort_order',
            'description'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_workflow_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'count_limit' in local_var_params and local_var_params['count_limit'] is not None:  # noqa: E501
            query_params.append(('countLimit', local_var_params['count_limit']))  # noqa: E501
        if 'asset_id' in local_var_params and local_var_params['asset_id'] is not None:  # noqa: E501
            query_params.append(('assetId', local_var_params['asset_id']))  # noqa: E501
            collection_formats['assetId'] = 'multi'  # noqa: E501
        if 'domain_id' in local_var_params and local_var_params['domain_id'] is not None:  # noqa: E501
            query_params.append(('domainId', local_var_params['domain_id']))  # noqa: E501
            collection_formats['domainId'] = 'multi'  # noqa: E501
        if 'community_id' in local_var_params and local_var_params['community_id'] is not None:  # noqa: E501
            query_params.append(('communityId', local_var_params['community_id']))  # noqa: E501
            collection_formats['communityId'] = 'multi'  # noqa: E501
        if 'enabled' in local_var_params and local_var_params['enabled'] is not None:  # noqa: E501
            query_params.append(('enabled', local_var_params['enabled']))  # noqa: E501
        if '_global' in local_var_params and local_var_params['_global'] is not None:  # noqa: E501
            query_params.append(('global', local_var_params['_global']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowDefinitionPagedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_configuration_start_form_data(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get configuration start form data.  # noqa: E501

        Returns the task configuration start form data of the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_configuration_start_form_data(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition that should be used for the form data retrieval. (required)
        :param str form_property_type: The form type to be returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StartFormDataImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_configuration_start_form_data_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def get_configuration_start_form_data_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get configuration start form data.  # noqa: E501

        Returns the task configuration start form data of the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_configuration_start_form_data_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition that should be used for the form data retrieval. (required)
        :param str form_property_type: The form type to be returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StartFormDataImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id',
            'form_property_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_configuration_start_form_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `get_configuration_start_form_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []
        if 'form_property_type' in local_var_params and local_var_params['form_property_type'] is not None:  # noqa: E501
            query_params.append(('formPropertyType', local_var_params['form_property_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/workflowDefinition/{workflowDefinitionId}/configurationStartFormData', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StartFormDataImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_possible_start_events(self, **kwargs):  # noqa: E501
        """Get all possible workflow start events  # noqa: E501

        Returns all possible workflow start events, including event name and description  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_possible_start_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[NamedDescribedWorkflowStartEventType]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_possible_start_events_with_http_info(**kwargs)  # noqa: E501

    def get_possible_start_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get all possible workflow start events  # noqa: E501

        Returns all possible workflow start events, including event name and description  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_possible_start_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[NamedDescribedWorkflowStartEventType], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_possible_start_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/startEvents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NamedDescribedWorkflowStartEventType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_start_form_data(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get start form data.  # noqa: E501

        Returns the task start form data of the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_start_form_data(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition that should be used for the form data retrieval. (required)
        :param str form_property_type: The form type to be returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StartFormDataImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_start_form_data_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def get_start_form_data_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get start form data.  # noqa: E501

        Returns the task start form data of the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_start_form_data_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition that should be used for the form data retrieval. (required)
        :param str form_property_type: The form type to be returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StartFormDataImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id',
            'form_property_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_start_form_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `get_start_form_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []
        if 'form_property_type' in local_var_params and local_var_params['form_property_type'] is not None:  # noqa: E501
            query_params.append(('formPropertyType', local_var_params['form_property_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/workflowDefinition/{workflowDefinitionId}/startFormData', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StartFormDataImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_definition(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get workflow definition.  # noqa: E501

        Returns the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_definition(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowDefinitionImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_definition_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def get_workflow_definition_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get workflow definition.  # noqa: E501

        Returns the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_definition_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowDefinitionImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `get_workflow_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowDefinitionImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_definition_by_process_id(self, process_id, **kwargs):  # noqa: E501
        """Get workflow definition.  # noqa: E501

        Returns the workflow definition with the specified process ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_definition_by_process_id(process_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_id: The process ID of the workflow definition. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowDefinitionImpl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_definition_by_process_id_with_http_info(process_id, **kwargs)  # noqa: E501

    def get_workflow_definition_by_process_id_with_http_info(self, process_id, **kwargs):  # noqa: E501
        """Get workflow definition.  # noqa: E501

        Returns the workflow definition with the specified process ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_definition_by_process_id_with_http_info(process_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_id: The process ID of the workflow definition. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowDefinitionImpl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_definition_by_process_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'process_id' is set
        if self.api_client.client_side_validation and ('process_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['process_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `process_id` when calling `get_workflow_definition_by_process_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'process_id' in local_var_params:
            path_params['processId'] = local_var_params['process_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/process/{processId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowDefinitionImpl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_definition_diagram(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get process diagram.  # noqa: E501

        Returns the process diagram of the workflow definition with the specified ID. The diagram input stream returned can be null as deployed workflow definitions without graphical notation included do not have a diagram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_definition_diagram(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_definition_diagram_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def get_workflow_definition_diagram_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get process diagram.  # noqa: E501

        Returns the process diagram of the workflow definition with the specified ID. The diagram input stream returned can be null as deployed workflow definitions without graphical notation included do not have a diagram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_definition_diagram_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_definition_diagram" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `get_workflow_definition_diagram`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}/diagram', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_definition_xml(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get XML of workflow definition.  # noqa: E501

        Returns the XML source of the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_definition_xml(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_definition_xml_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def get_workflow_definition_xml_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Get XML of workflow definition.  # noqa: E501

        Returns the XML source of the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_definition_xml_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_definition_xml" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `get_workflow_definition_xml`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}/xml', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_assignment_rule(self, workflow_definition_id, rule_id, **kwargs):  # noqa: E501
        """Remove assignment rule.  # noqa: E501

        Removes the assignment rule with the specified ID from the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assignment_rule(workflow_definition_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param str rule_id: The ID of the assignment rule. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_assignment_rule_with_http_info(workflow_definition_id, rule_id, **kwargs)  # noqa: E501

    def remove_assignment_rule_with_http_info(self, workflow_definition_id, rule_id, **kwargs):  # noqa: E501
        """Remove assignment rule.  # noqa: E501

        Removes the assignment rule with the specified ID from the workflow definition with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_assignment_rule_with_http_info(workflow_definition_id, rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param str rule_id: The ID of the assignment rule. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id',
            'rule_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_assignment_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `remove_assignment_rule`")  # noqa: E501
        # verify the required parameter 'rule_id' is set
        if self.api_client.client_side_validation and ('rule_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_id` when calling `remove_assignment_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501
        if 'rule_id' in local_var_params:
            path_params['ruleId'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}/assignmentRules/{ruleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_workflow_definition(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Remove workflow definition.  # noqa: E501

        Removes the workflow definition with the specified ID. The workflow definition will be completely removed from the application, including any history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_workflow_definition(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_workflow_definition_with_http_info(workflow_definition_id, **kwargs)  # noqa: E501

    def remove_workflow_definition_with_http_info(self, workflow_definition_id, **kwargs):  # noqa: E501
        """Remove workflow definition.  # noqa: E501

        Removes the workflow definition with the specified ID. The workflow definition will be completely removed from the application, including any history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_workflow_definition_with_http_info(workflow_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_definition_id: The ID of the workflow definition. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_definition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_workflow_definition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_definition_id' is set
        if self.api_client.client_side_validation and ('workflow_definition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_definition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_definition_id` when calling `remove_workflow_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_definition_id' in local_var_params:
            path_params['workflowDefinitionId'] = local_var_params['workflow_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/{workflowDefinitionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_workflow_definitions_in_job(self, **kwargs):  # noqa: E501
        """Remove multiple workflow definitions.  # noqa: E501

        Removes multiple workflow definitions asynchronously. The workflow definition(s) will be completely removed from the application, including any history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_workflow_definitions_in_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] request_body: The list of IDs of the workflow definitions to remove.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_workflow_definitions_in_job_with_http_info(**kwargs)  # noqa: E501

    def remove_workflow_definitions_in_job_with_http_info(self, **kwargs):  # noqa: E501
        """Remove multiple workflow definitions.  # noqa: E501

        Removes multiple workflow definitions asynchronously. The workflow definition(s) will be completely removed from the application, including any history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_workflow_definitions_in_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] request_body: The list of IDs of the workflow definitions to remove.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Job, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_workflow_definitions_in_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowDefinitions/removalJobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
