/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import java.io.IOException;
import java.nio.ByteBuffer;

class MatFileInputStream {
    private int type;
    private ByteBuffer buf;

    public MatFileInputStream(ByteBuffer buf, int type) {
        this.type = type;
        this.buf = buf;
    }

    public int readInt() throws IOException {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt() & 0xFFFFFFFF;
            }
            case 5: {
                return this.buf.getInt();
            }
            case 9: {
                return (int)this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public char readChar() throws IOException {
        switch (this.type) {
            case 2: {
                return (char)(this.buf.get() & 0xFF);
            }
            case 1: {
                return (char)this.buf.get();
            }
            case 4: {
                return (char)(this.buf.getShort() & 0xFFFF);
            }
            case 3: {
                return (char)this.buf.getShort();
            }
            case 6: {
                return (char)(this.buf.getInt() & 0xFFFFFFFF);
            }
            case 5: {
                return (char)this.buf.getInt();
            }
            case 9: {
                return (char)this.buf.getDouble();
            }
            case 16: {
                return (char)this.buf.get();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public double readDouble() throws IOException {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt() & 0xFFFFFFFF;
            }
            case 5: {
                return this.buf.getInt();
            }
            case 9: {
                return this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }
}

