/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.ints;

import ch.javasoft.util.ints.AbstractIntListIterator;
import ch.javasoft.util.ints.IntList;
import java.util.NoSuchElementException;

public class DefaultIntListIterator
extends AbstractIntListIterator {
    private final int mStartIndex;
    private final IntList mList;
    private int mIndex;
    private int mIndexToMutate;

    public DefaultIntListIterator(int startIndex, IntList list) {
        this.mStartIndex = startIndex;
        this.mList = list;
        this.mIndex = this.mStartIndex;
        this.mIndexToMutate = -1;
    }

    public boolean hasNext() {
        return this.mIndex < this.mList.size();
    }

    public boolean hasPrevious() {
        return this.mIndex > this.mStartIndex;
    }

    public int nextIndex() {
        return this.hasNext() ? this.mIndex : this.mList.size();
    }

    public int nextInt() {
        if (this.hasNext()) {
            this.mIndexToMutate = this.mIndex;
            int val = this.mList.getInt(this.mIndex);
            ++this.mIndex;
            return val;
        }
        throw new NoSuchElementException();
    }

    public int previousIndex() {
        return this.hasPrevious() ? this.mIndex - 1 : -1;
    }

    public int previousInt() {
        if (this.hasPrevious()) {
            --this.mIndex;
            this.mIndexToMutate = this.mIndex;
            return this.mList.getInt(this.mIndex);
        }
        throw new NoSuchElementException();
    }

    public void addInt(int value) {
        if (this.mIndexToMutate == -1) {
            throw new IllegalStateException("next or previous not called, or element has already been mutated");
        }
        this.mList.addInt(this.mIndexToMutate, value);
        this.mIndexToMutate = -1;
    }

    public void setInt(int value) {
        if (this.mIndexToMutate == -1) {
            throw new IllegalStateException("next or previous not called, or element has already been mutated");
        }
        this.mList.setInt(this.mIndexToMutate, value);
        this.mIndexToMutate = -1;
    }

    public void remove() {
        if (this.mIndexToMutate == -1) {
            throw new IllegalStateException("next or previous not called, or element has already been mutated");
        }
        this.mList.removeIntAt(this.mIndexToMutate);
        this.mIndexToMutate = -1;
        --this.mIndex;
    }
}

