/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.genarr;

import ch.javasoft.util.genarr.AbstractArrayIterable;
import ch.javasoft.util.genarr.GenericArray;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenericArray<T>
extends AbstractArrayIterable<T>
implements GenericArray<T>,
List<T> {
    protected static final Object[] EMPTY = new Object[0];

    public AbstractGenericArray() {
    }

    public AbstractGenericArray(T[] array) {
        this.addAll(array);
    }

    public AbstractGenericArray(GenericArray<? extends T> genericArray) {
        this.addAll((Collection<? extends T>)genericArray);
    }

    public AbstractGenericArray(Iterable<T> iterable) {
        this.addAll(iterable);
    }

    @Override
    public ListIterator<T> iterator(int start, int end) {
        return new AbstractArrayIterable.ArrayListIterator(this, start, end){
            protected int mLast;
            {
                this.mLast = -1;
            }

            @Override
            public T next() {
                this.mLast = this.nextIndex();
                return super.next();
            }

            @Override
            public T previous() {
                this.mLast = this.previousIndex();
                return super.previous();
            }

            @Override
            public void set(T obj) {
                if (this.mLast >= this.mStart && this.mLast < this.mEnd) {
                    AbstractGenericArray.this.set(this.mLast, obj);
                    this.mLast = -1;
                    return;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.mLast >= this.mStart && this.mLast < this.mEnd) {
                    AbstractGenericArray.this.remove(this.mLast);
                    this.mLast = -1;
                    return;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void add(T obj) {
                AbstractGenericArray.this.set(this.mIndex, obj);
            }
        };
    }

    @Override
    public void set(int offset, T[] arr) {
        this.set(offset, arr, 0, arr.length);
    }

    public void addAll(Iterable<? extends T> it) {
        this.set(this.length(), it);
    }

    public void addAll(T[] arr) {
        this.set(this.length(), arr);
    }

    @Override
    public T first() throws IndexOutOfBoundsException {
        if (this.length() > 0) {
            return this.get(0);
        }
        throw new IndexOutOfBoundsException("empty array");
    }

    @Override
    public T last() throws IndexOutOfBoundsException {
        int len = this.length();
        if (len > 0) {
            return this.get(len - 1);
        }
        throw new IndexOutOfBoundsException("empty array");
    }

    @Override
    public void swap(int indexA, int indexB) {
        int len = this.length();
        if (Math.min(indexA, indexB) < 0 || Math.max(indexA, indexB) >= len) {
            throw new IndexOutOfBoundsException("index " + indexA + " or " + indexB + " out of bounds [0, " + (len - 1) + "]");
        }
        Object tmp = this.set(indexA, this.get(indexB));
        this.set(indexB, tmp);
    }

    @Override
    public void add(int index, T element) {
        this.set(index, element);
    }

    @Override
    public boolean add(T obj) {
        this.set(this.length(), obj);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        this.addAll((Iterable<? extends T>)coll);
        return !coll.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> coll) {
        this.set(index, coll);
        return !coll.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Object obj : coll) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.indexOf(obj);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public T remove(int index) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.iterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.iterator(index, this.length());
    }

    @Override
    public int size() {
        return this.length();
    }

    public String toString() {
        int len = this.length();
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int ii = 0;
        while (ii < len) {
            if (ii > 0) {
                sb.append(", ");
            }
            sb.append(this.get(ii));
            ++ii;
        }
        sb.append(']');
        return sb.toString();
    }

    protected T[] newArray(int size) {
        return new Object[size];
    }
}

