/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.math.BigFraction;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface GaussPivoting<M extends ReadableMatrix<?>> {
    public int checkCandidateRow(M var1, int var2, int var3);

    public boolean checkCandidateCol(M var1, int var2, int var3, int var4, int var5);

    public int getPivotRow();

    public int getPivotCol();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BiLenProductL
    implements GaussPivoting<ReadableBigIntegerRationalMatrix<BigFraction>> {
        int pivCol;
        int pivRow;
        int pivPro = Integer.MAX_VALUE;

        public BiLenProductL(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        @Override
        public int checkCandidateRow(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row) {
            return 0;
        }

        @Override
        public boolean checkCandidateCol(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row, int col, int rowResult) {
            BigInteger num = matrix.getBigIntegerNumeratorAt(row, col);
            BigInteger den = matrix.getBigIntegerDenominatorAt(row, col);
            int pro = num.abs().bitLength() * den.abs().bitLength();
            if (pro < this.pivPro) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivPro = pro;
            }
            return this.pivPro != 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BiLenProductLE
    implements GaussPivoting<ReadableBigIntegerRationalMatrix<BigFraction>> {
        int pivCol;
        int pivRow;
        int pivPro = Integer.MAX_VALUE;

        public BiLenProductLE(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        @Override
        public int checkCandidateRow(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row) {
            return 0;
        }

        @Override
        public boolean checkCandidateCol(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row, int col, int rowResult) {
            BigInteger num = matrix.getBigIntegerNumeratorAt(row, col);
            BigInteger den = matrix.getBigIntegerDenominatorAt(row, col);
            int pro = num.abs().bitLength() * den.abs().bitLength();
            if (pro <= this.pivPro) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivPro = pro;
            }
            return true;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BiLenProductLorEandMoreRowZeros
    implements GaussPivoting<ReadableBigIntegerRationalMatrix<BigFraction>> {
        int pivCol;
        int pivRow;
        int pivPro = Integer.MAX_VALUE;
        int pivCnt = 0;

        public BiLenProductLorEandMoreRowZeros(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        @Override
        public int checkCandidateRow(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row) {
            int cols = matrix.getColumnCount();
            int zerCnt = 0;
            int col = pivot;
            while (col < cols) {
                if (matrix.getSignumAt(row, col) == 0) {
                    ++zerCnt;
                }
                ++col;
            }
            return zerCnt;
        }

        @Override
        public boolean checkCandidateCol(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row, int col, int zerCnt) {
            BigInteger num = matrix.getBigIntegerNumeratorAt(row, col);
            BigInteger den = matrix.getBigIntegerDenominatorAt(row, col);
            int pro = num.abs().bitLength() * den.abs().bitLength();
            if (pro < this.pivPro || pro == this.pivPro && zerCnt > this.pivCnt) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivPro = pro;
                this.pivCnt = zerCnt;
            }
            return this.pivPro != 1 || this.pivCnt < matrix.getColumnCount() - 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BiLenSumLorEandMoreRowZeros
    implements GaussPivoting<ReadableBigIntegerRationalMatrix<BigFraction>> {
        int pivCol;
        int pivRow;
        int pivSum = Integer.MAX_VALUE;
        int pivCnt = 0;

        public BiLenSumLorEandMoreRowZeros(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        @Override
        public int checkCandidateRow(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row) {
            int cols = matrix.getColumnCount();
            int zerCnt = 0;
            int col = pivot;
            while (col < cols) {
                if (matrix.getSignumAt(row, col) == 0) {
                    ++zerCnt;
                }
                ++col;
            }
            return zerCnt;
        }

        @Override
        public boolean checkCandidateCol(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row, int col, int zerCnt) {
            BigInteger num = matrix.getBigIntegerNumeratorAt(row, col);
            BigInteger den = matrix.getBigIntegerDenominatorAt(row, col);
            int sum = num.abs().bitLength() + den.abs().bitLength();
            if (sum < this.pivSum || sum == this.pivSum && zerCnt > this.pivCnt) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivSum = sum;
                this.pivCnt = zerCnt;
            }
            return this.pivSum != 2 || this.pivCnt < matrix.getColumnCount() - 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BiMaxLenLorEandMoreRowZeros
    implements GaussPivoting<ReadableBigIntegerRationalMatrix<BigFraction>> {
        int pivCol;
        int pivRow;
        int pivLen = Integer.MAX_VALUE;
        int pivCnt = 0;

        public BiMaxLenLorEandMoreRowZeros(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        @Override
        public int checkCandidateRow(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row) {
            int cols = matrix.getColumnCount();
            int zerCnt = 0;
            int col = pivot;
            while (col < cols) {
                if (matrix.getSignumAt(row, col) == 0) {
                    ++zerCnt;
                }
                ++col;
            }
            return zerCnt;
        }

        @Override
        public boolean checkCandidateCol(ReadableBigIntegerRationalMatrix<BigFraction> matrix, int pivot, int row, int col, int zerCnt) {
            BigInteger num = matrix.getBigIntegerNumeratorAt(row, col);
            BigInteger den = matrix.getBigIntegerDenominatorAt(row, col);
            int len = Math.max(num.abs().bitLength(), den.abs().bitLength());
            if (len < this.pivLen || len == this.pivLen && zerCnt > this.pivCnt) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivLen = len;
                this.pivCnt = zerCnt;
            }
            return this.pivLen != 1 || this.pivCnt < matrix.getColumnCount() - 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }
}

