/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.main;

import ch.javasoft.factory.ConfigException;
import ch.javasoft.factory.FactoryNotFoundException;
import ch.javasoft.factory.IllegalFactoryException;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.ArithmeticCallback;
import ch.javasoft.polco.config.Phase;
import ch.javasoft.polco.config.PolcoConfig;
import ch.javasoft.polco.config.TypeConverter;
import ch.javasoft.polco.config.XmlElement;
import ch.javasoft.polco.main.LogPkg;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEnumerator;
import ch.javasoft.util.logging.LogPrintStream;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import ch.javasoft.xml.config.ConstConfigParser;
import ch.javasoft.xml.config.MissingReferableException;
import ch.javasoft.xml.config.XmlArgException;
import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlUtil;
import java.io.IOException;
import java.util.logging.Level;
import org.dom4j.DocumentException;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polco {
    private final XmlConfig config;

    public Polco(XmlConfig config) throws SecurityException, IOException, XmlConfigException {
        this.config = config;
        Loggers.initLogManagerConfiguration(config.getLoggingProperties());
        LogPrintStream logStream = new LogPrintStream(LogPkg.LOGGER, Level.INFO);
        PolcoConfig.printVersion(logStream, config);
        logStream.flush();
    }

    public static void main(String[] args) {
        try {
            XmlConfig xmlConfig;
            if (args.length == 0) {
                xmlConfig = PolcoConfig.parseXmlConfig(args);
                PolcoConfig.printNoArgs(System.err, xmlConfig);
                ExitVal.NoArgs.exit();
            } else if (args.length >= 1 && ("--help".equals(args[0]) || "-h".equals(args[0]) || "-?".equals(args[0]) || "?".equals(args[0]) || "--version".equals(args[0]) || "-v".equals(args[0]))) {
                boolean err;
                xmlConfig = PolcoConfig.parseXmlConfig(args);
                boolean bl = err = args.length > 1;
                if ("--help".equals(args[0]) || "-h".equals(args[0]) || "-?".equals(args[0]) || "?".equals(args[0])) {
                    PolcoConfig.printHelp(err ? System.err : System.out, xmlConfig);
                    if (err) {
                        ExitVal.ImpureHelpOrVersionInvocation.exit();
                    } else {
                        ExitVal.Ok.exit();
                    }
                }
                if ("--version".equals(args[0]) || "-v".equals(args[0])) {
                    PolcoConfig.printVersion(err ? System.err : System.out, xmlConfig);
                    if (err) {
                        ExitVal.ImpureHelpOrVersionInvocation.exit();
                    } else {
                        ExitVal.Ok.exit();
                    }
                }
            }
            try {
                xmlConfig = PolcoConfig.resolveXmlConfig(args);
                Polco polco = new Polco(xmlConfig);
                polco.call();
            }
            catch (XmlArgException ex) {
                ExitVal.InvalidConfigArg.exit();
            }
            catch (MissingReferableException ex) {
                ExitVal.InvalidConfigRef.exit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PolcoConfig.traceArgs(System.err, String.valueOf(Polco.class.getName()) + " with following arguments: ", args);
            ExitVal.UnexpectedException.exit();
        }
        ExitVal.Ok.exit();
    }

    private long call() throws Exception {
        PolcoConfig.tracePolcoConfig(LogPkg.LOGGER, Level.INFO, this.config);
        final Arithmetic arithmeticPre = PolcoConfig.getArithmetic(this.config, Phase.Pre);
        Arithmetic arithmeticPost = PolcoConfig.getArithmetic(this.config, Phase.Post);
        ArithmeticCallback<Long> postCb = new ArithmeticCallback<Long>(){

            @Override
            public <NPost extends Number, APost> Long callback(final Arithmetic<NPost, APost> arithmeticPost) throws Exception {
                ArithmeticCallback<Long> preCb = new ArithmeticCallback<Long>(){

                    @Override
                    public <NPre extends Number, APre> Long callback(Arithmetic<NPre, APre> arithmeticPre) throws FactoryNotFoundException, IllegalFactoryException, ConfigException, XmlConfigException, DocumentException {
                        long res = Polco.this.callInternal(arithmeticPre, arithmeticPost);
                        return res;
                    }
                };
                return arithmeticPre.callback(preCb);
            }
        };
        return arithmeticPost.callback(postCb);
    }

    private <NPost extends Number, APost, NPre extends Number, APre> long callInternal(Arithmetic<NPre, APre> arithmeticPre, Arithmetic<NPost, APost> arithmeticPost) throws FactoryNotFoundException, IllegalFactoryException, ConfigException, XmlConfigException, DocumentException {
        Element elParse = PolcoConfig.getPolcoParse(this.config);
        Element elCallback = PolcoConfig.getPolcoCallback(this.config);
        PolyhedralCone polycone = (PolyhedralCone)arithmeticPre.createNumeric(PolyhedralCone.class, elParse);
        ExtremeRayCallback cb = (ExtremeRayCallback)arithmeticPost.createNumeric(ExtremeRayCallback.class, elCallback);
        return this.callInternal(polycone, cb, arithmeticPost);
    }

    public <NPost extends Number, APost, NPre extends Number, APre> long call(final PolyhedralCone<NPre, APre> polycone, final ExtremeRayCallback<NPost, APost> callback, final LinAlgOperations<NPost, APost> linalgOpsPost) throws IllegalStateException {
        try {
            PolcoConfig.tracePolcoConfig(LogPkg.LOGGER, Level.INFO, this.config);
            final Arithmetic arithmeticPre = PolcoConfig.getArithmetic(this.config, Phase.Pre);
            Arithmetic arithmeticPost = PolcoConfig.getArithmetic(this.config, Phase.Post);
            final Zero zeroPre = PolcoConfig.getZero(this.config, Phase.Pre);
            final Zero zeroPost = PolcoConfig.getZero(this.config, Phase.Post);
            Element elConfig = PolcoConfig.getPolcoConfig(this.config);
            Element elConvert = XmlUtil.getRequiredSingleChildElement(elConfig, XmlElement.convert);
            Element elMatrix = XmlUtil.getRequiredSingleChildElement(elConvert, XmlElement.matrix_scaling);
            final boolean allowMatrixRowScaling = ConstConfigParser.parseBooleanConstant(elMatrix);
            ArithmeticCallback<Long> postCb = new ArithmeticCallback<Long>(){

                @Override
                public <NPo extends Number, APo> Long callback(final Arithmetic<NPo, APo> arithmeticPo) throws Exception {
                    TypeConverter postConverter = new TypeConverter(linalgOpsPost, arithmeticPo.getLinAlgOperations(zeroPost), allowMatrixRowScaling);
                    final ExtremeRayCallback<NPo, APo> cb = postConverter.convertCallback(callback);
                    ArithmeticCallback<Long> preCb = new ArithmeticCallback<Long>(){

                        @Override
                        public <NPr extends Number, APr> Long callback(Arithmetic<NPr, APr> arithmeticPr) throws Exception {
                            TypeConverter preConverter = new TypeConverter(polycone.getLinAlgOperations(), arithmeticPr.getLinAlgOperations(zeroPre), allowMatrixRowScaling);
                            PolyhedralCone<NPr, APr> cone = preConverter.convertPolyhedralCone(polycone);
                            long res = Polco.this.callInternal(cone, cb, arithmeticPo);
                            return res;
                        }
                    };
                    return arithmeticPre.callback(preCb);
                }
            };
            return arithmeticPost.callback(postCb);
        }
        catch (Error ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private <NPost extends Number, APost, NPre extends Number, APre> long callInternal(PolyhedralCone<NPre, APre> polycone, ExtremeRayCallback<NPost, APost> callback, Arithmetic<NPost, APost> arithmeticPost) throws FactoryNotFoundException, IllegalFactoryException, ConfigException, XmlConfigException, DocumentException {
        Element elXray = PolcoConfig.getPolcoExtremeRayEnum(this.config);
        Zero zeroPost = PolcoConfig.getZero(this.config, Phase.Post);
        ExtremeRayEnumerator alg = PolcoConfig.createFromFactory(ExtremeRayEnumerator.class, elXray);
        LinAlgOperations<NPost, APost> cbOps = arithmeticPost.getLinAlgOperations(zeroPost);
        return alg.enumerateExtremeRays(polycone, callback, cbOps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExitVal {
        Ok,
        NoArgs,
        ImpureHelpOrVersionInvocation,
        InvalidConfigArg,
        InvalidConfigRef,
        UnexpectedException,
        Unknown;


        public int getExitValue() {
            return -this.ordinal();
        }

        public void exit() {
            System.exit(this.getExitValue());
        }
    }
}

