/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.io.NullOutputStream;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.impl.FilteredMetabolicNetwork;
import ch.javasoft.metabolic.parse.LogPkg;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import ch.javasoft.metabolic.parse.junit.TestDelegate;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.textui.TestRunner;

public class JUnitTestCaseParser {
    public static MetabolicNetwork parse(AbstractParseTestCase testCase, String testMethod) {
        final class Result {
            MetabolicNetwork network;
            Set<String> suppressedReactions;

            Result() {
            }
        }
        final Result result = new Result();
        TestDelegate delegate = new TestDelegate(){
            {
            }

            @Override
            public void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
                result.network = network;
                result.suppressedReactions = suppressedReactions;
            }
        };
        testCase.setName(testMethod);
        testCase.setTestDelegate(delegate);
        TestRunner testRunner = new TestRunner(new PrintStream(NullOutputStream.INSTANCE));
        try {
            TestResult testResult = testRunner.doRun((Test)testCase, false);
            if (testResult.errorCount() > 0) {
                String msg = "junit parsing failed, errors occurred.";
                LogPkg.LOGGER.warning("junit parsing failed, errors occurred.");
                JUnitTestCaseParser.log(testResult.errors());
                throw new RuntimeException("junit parsing failed, errors occurred.");
            }
            if (testResult.failureCount() > 0) {
                String msg = "junit parsing completed with failures.";
                LogPkg.LOGGER.warning("junit parsing completed with failures.");
                JUnitTestCaseParser.log(testResult.failures());
                throw new RuntimeException("junit parsing completed with failures.");
            }
        }
        finally {
            testCase.setName(null);
            testCase.setTestDelegate(null);
        }
        if (result.suppressedReactions == null || result.suppressedReactions.isEmpty()) {
            return result.network;
        }
        FilteredMetabolicNetwork filtered = new FilteredMetabolicNetwork(result.network);
        filtered.excludeReactions(result.suppressedReactions.toArray(new String[0]));
        return filtered;
    }

    private static void log(Enumeration testFailures) {
        while (testFailures.hasMoreElements()) {
            LogPkg.LOGGER.warning("\t" + testFailures.nextElement());
        }
    }
}

