/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import ch.javasoft.util.numeric.DoubleUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class CddGenerator {
    public static final int PRECISION = 8;

    public static void writeIneFile(MetabolicNetwork net, File outFile) throws IOException {
        CddGenerator.writeIneFile(StoichiometricMatrices.createStoichiometricMatrixExpandReversible(net), outFile);
    }

    public static void writeIneFile(double[][] stoich, File outFile) throws IOException {
        PrintWriter pw = Print.createWriter(outFile);
        pw.println("H-representation");
        pw.println("begin");
        pw.println(String.valueOf(2 * stoich.length) + " " + (stoich.length > 0 ? stoich[0].length + 1 : 1) + " rational");
        int row = 0;
        while (row < stoich.length) {
            int sgn = 1;
            do {
                pw.print("0");
                int col = 0;
                while (col < (stoich.length > 0 ? stoich[0].length : 0)) {
                    pw.print(' ');
                    pw.print(CddGenerator.doubleToString(stoich[row][col] * (double)sgn, 8));
                    ++col;
                }
                pw.println();
            } while ((sgn = -sgn) == -1);
            ++row;
        }
        pw.println("end");
        pw.flush();
        pw.close();
    }

    private static String doubleToString(double orig, int precision) {
        double val = DoubleUtil.round(orig, precision);
        if ((double)((int)val) == val) {
            return String.valueOf((int)val);
        }
        String valStr = String.valueOf(val);
        int index = valStr.indexOf(46);
        try {
            String intg = valStr.substring(0, index);
            String frac = valStr.substring(index + 1);
            return String.valueOf(intg) + frac + "/" + (long)Math.pow(10.0, frac.length());
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot convert to rational: " + val + " / " + valStr, ex);
        }
    }

    private CddGenerator() {
    }
}

