/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.sort;

import ch.javasoft.metabolic.efm.sort.RowColSorter;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.util.numeric.Zero;

public class FewestNegPosSorter
extends RowColSorter {
    private final Zero mZero;

    public FewestNegPosSorter(boolean compareRows, int startRowCol, int endRowCol, int startColRow, int endColRow, Zero zero) {
        super(compareRows, startRowCol, endRowCol, startColRow, endColRow);
        this.mZero = zero;
    }

    public int compare(ReadableDoubleMatrix mx, int rowOrColA, int rowOrColB) {
        int start = this.startCol(mx);
        int cnt = this.count(mx);
        long cntNegA = 0L;
        long cntPosA = 0L;
        long cntNegB = 0L;
        long cntPosB = 0L;
        int colOrRow = start;
        while (colOrRow < cnt) {
            double valA = this.value(mx, rowOrColA, colOrRow);
            double valB = this.value(mx, rowOrColB, colOrRow);
            int sgnA = this.mZero.sgn(valA);
            int sgnB = this.mZero.sgn(valB);
            if (sgnA < 0) {
                ++cntNegA;
            } else if (sgnA > 0) {
                ++cntPosA;
            }
            if (sgnB < 0) {
                ++cntNegB;
            } else if (sgnB > 0) {
                ++cntPosB;
            }
            ++colOrRow;
        }
        long delta = cntNegA * cntPosA - cntNegB * cntPosB;
        return delta < 0L ? -1 : (delta > 0L ? 1 : 0);
    }
}

