/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifierFactory;
import ch.javasoft.metabolic.efm.model.DefaultEfmModel;
import ch.javasoft.metabolic.efm.model.DefaultIterationStateModel;
import ch.javasoft.metabolic.efm.model.DefaultIterationStepModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.MemoryAccessor;
import ch.javasoft.metabolic.efm.model.ModelPersister;
import ch.javasoft.metabolic.efm.util.MatrixUtil;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelPersister
implements ModelPersister {
    @Override
    public void writeStoich(ReadableMatrix matrix, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            MatrixUtil.writeMatrix(matrix, out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    @Override
    public <N extends Number, Col extends Column> void writeEfmModel(ColumnHome<N, Col> columnHome, EfmModel model, File file) throws IOException {
        PrintWriter pw = Print.createWriter(file);
        try {
            pw.println(model.getClass().getName());
            pw.println(model.getStoichRank());
            pw.println(model.getReactionSorting().length);
            int i = 0;
            while (i < model.getReactionSorting().length) {
                pw.println(model.getReactionSorting()[i]);
                ++i;
            }
            pw.println(model.getMetaboliteSorting().length);
            i = 0;
            while (i < model.getMetaboliteSorting().length) {
                pw.println(model.getMetaboliteSorting()[i]);
                ++i;
            }
            pw.println(model.getColumnInspectorModifierFactory().getClass().getName());
        }
        finally {
            pw.close();
        }
    }

    @Override
    public ReadableMatrix readStoich(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            ReadableMatrix<?> readableMatrix = MatrixUtil.readMatrix(in);
            return readableMatrix;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    @Override
    public EfmModel readEfmModel(Config config, ReadableMatrix stoich, File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String className = br.readLine();
        try {
            DefaultEfmModel.Init init = new DefaultEfmModel.Init();
            init.stoichiometricMatrixRational = MatrixUtil.convertToBigIntegerRationalMatrix(stoich, config.zero(), false);
            init.stoichRank = Integer.parseInt(br.readLine());
            init.reactionSorting = new int[Integer.parseInt(br.readLine())];
            int i = 0;
            while (i < init.reactionSorting.length) {
                init.reactionSorting[i] = Integer.parseInt(br.readLine());
                ++i;
            }
            init.metaboliteSorting = new int[Integer.parseInt(br.readLine())];
            i = 0;
            while (i < init.metaboliteSorting.length) {
                init.metaboliteSorting[i] = Integer.parseInt(br.readLine());
                ++i;
            }
            init.columnInspectorModifierFactory = (ColumnInspectorModifierFactory)Class.forName(br.readLine()).newInstance();
            init.config = config;
            DefaultEfmModel defaultEfmModel = new DefaultEfmModel(init);
            return defaultEfmModel;
        }
        catch (InstantiationException e) {
            throw ExceptionUtil.toIOException(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtil.toIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtil.toIOException(e);
        }
        finally {
            br.close();
        }
    }

    @Override
    public <N extends Number, Col extends Column> void writeAdjEnumModel(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> model, File file) throws IOException {
        Properties props = new Properties();
        this.writeAdjEnumModelToProperties(columnHome, model, props);
        props.store(new FileOutputStream(file), "adj-enum-model stored by " + this.getClass().getName());
    }

    protected <N extends Number, Col extends Column> void writeAdjEnumModelToProperties(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> model, Properties props) throws IOException {
        IterationStateModel cur = model.getCurrentState();
        IterationStateModel nex = model.getNextState();
        props.put("adj-enum-model-iteration-index", String.valueOf(model.getIterationIndex()));
        props.put("adj-enum-model-hyperplane-index", String.valueOf(cur.getHyperplaneIndex()));
        props.put("adj-enum-model-next-hyperplane-index", String.valueOf(nex.getHyperplaneIndex()));
        props.put("adj-enum-model-boolean-size", String.valueOf(cur.getBooleanSize()));
        props.put("adj-enum-model-next-boolean-size", String.valueOf(nex.getBooleanSize()));
        props.put("adj-enum-model-numeric-size", String.valueOf(cur.getNumericSize()));
        props.put("adj-enum-model-next-numeric-size", String.valueOf(nex.getNumericSize()));
    }

    @Override
    public <N extends Number, Col extends Column> AdjEnumModel<Col> readAdjEnumModel(ColumnHome<N, Col> columnHome, File file, MemoryAccessor<Col> memoryAccessor) throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(file);
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
        int iterationIndex = Integer.parseInt(props.getProperty("adj-enum-model-iteration-index"));
        int hyperplaneIndex = Integer.parseInt(props.getProperty("adj-enum-model-hyperplane-index"));
        int nextHyperplaneIndex = Integer.parseInt(props.getProperty("adj-enum-model-next-hyperplane-index"));
        int booleanSize = Integer.parseInt(props.getProperty("adj-enum-model-boolean-size"));
        int nextBooleanSize = Integer.parseInt(props.getProperty("adj-enum-model-next-boolean-size"));
        int numericSize = Integer.parseInt(props.getProperty("adj-enum-model-numeric-size"));
        int nextNumericSize = Integer.parseInt(props.getProperty("adj-enum-model-next-numeric-size"));
        DefaultIterationStateModel cur = new DefaultIterationStateModel(hyperplaneIndex, booleanSize, numericSize);
        DefaultIterationStateModel nex = new DefaultIterationStateModel(nextHyperplaneIndex, nextBooleanSize, nextNumericSize);
        DefaultIterationStepModel itModel = new DefaultIterationStepModel(iterationIndex, cur, nex);
        return this.readAdjEnumModelFromProperties(columnHome, props, itModel, memoryAccessor);
    }

    protected abstract <N extends Number, Col extends Column> AdjEnumModel<Col> readAdjEnumModelFromProperties(ColumnHome<N, Col> var1, Properties var2, IterationStepModel var3, MemoryAccessor<Col> var4) throws IOException;
}

