/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.dist.impl.file;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AbstractModelPersister;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.MemoryAccessor;
import ch.javasoft.util.ExceptionUtil;
import java.io.IOException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedModelPersister
extends AbstractModelPersister {
    @Override
    protected <N extends Number, Col extends Column> void writeAdjEnumModelToProperties(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> model, Properties props) throws IOException {
        super.writeAdjEnumModelToProperties(columnHome, model, props);
        props.put("adj-enum-model-pos-class", model.getMemoryPos().getClass().getName());
        props.put("adj-enum-model-pos-fileid", model.getMemoryPos().fileId());
        props.put("adj-enum-model-neg-class", model.getMemoryNeg().getClass().getName());
        props.put("adj-enum-model-neg-fileid", model.getMemoryNeg().fileId());
        props.put("adj-enum-model-zero-class", model.getMemoryZero().getClass().getName());
        props.put("adj-enum-model-zero-fileid", model.getMemoryZero().fileId());
    }

    @Override
    protected <N extends Number, Col extends Column> AdjEnumModel<Col> readAdjEnumModelFromProperties(ColumnHome<N, Col> columnHome, Properties props, IterationStepModel itModel, MemoryAccessor<Col> memoryAccessor) throws IOException {
        SortableMemory<Col> pos = FileBasedModelPersister.openMemory(columnHome, itModel, props, "adj-enum-model-pos");
        SortableMemory<Col> neg = FileBasedModelPersister.openMemory(columnHome, itModel, props, "adj-enum-model-neg");
        SortableMemory<Col> zer = FileBasedModelPersister.openMemory(columnHome, itModel, props, "adj-enum-model-zero");
        return new AdjEnumModel<Col>(itModel, pos, zer, neg, memoryAccessor.getAppendableMemory());
    }

    private static <Col extends Column> SortableMemory<Col> openMemory(ColumnHome<?, Col> columnHome, IterationStepModel stepModel, Properties props, String propPrefix) throws IOException {
        String className = props.getProperty(String.valueOf(propPrefix) + "-class");
        String fileId = props.getProperty(String.valueOf(propPrefix) + "-fileid");
        try {
            Class<?> clazz = Class.forName(className);
            Object inst = clazz.getConstructor(String.class).newInstance(fileId);
            return (SortableMemory)inst;
        }
        catch (Exception ex) {
            throw ExceptionUtil.toIOException(ex);
        }
    }
}

