/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.config;

import ch.javasoft.metabolic.efm.config.XmlAttribute;
import ch.javasoft.metabolic.efm.config.XmlElement;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedConfig {
    private final int partition;
    private final long candidateThreashold;
    private final List<String> nodeNames;
    private final List<String> vmArgs;
    private final List<String> logLevels;
    private final String command;

    public DistributedConfig() throws XmlConfigException, IOException {
        this(DistributedConfig.getDistConfigFromPackage());
    }

    private static final Element getDistConfigFromPackage() throws XmlConfigException, IOException {
        String xmlName = "config/metabolic-efm.xml";
        InputStream xmlIn = DistributedConfig.class.getClassLoader().getResourceAsStream("config/metabolic-efm.xml");
        if (xmlIn == null) {
            throw new IOException("cannot find resource: config/metabolic-efm.xml");
        }
        try {
            Element elDist;
            SAXReader reader = new SAXReader();
            Document doc = reader.read(xmlIn);
            Element root = doc.getRootElement();
            Element element = elDist = root.elementByID(XmlElement.distribute.getXmlName());
            return element;
        }
        catch (DocumentException e) {
            throw ExceptionUtil.toIOException("cannot parse config/metabolic-efm.xml, e=" + (Object)((Object)e), e);
        }
        finally {
            xmlIn.close();
        }
    }

    public DistributedConfig(Element elDistribute) throws XmlConfigException {
        Element elNodes = XmlUtil.getRequiredSingleChildElement(elDistribute, XmlElement.nodes);
        Element elCommand = XmlUtil.getRequiredSingleChildElement(elDistribute, XmlElement.command);
        String sPartition = XmlUtil.getRequiredAttributeValue(elDistribute, XmlAttribute.partition);
        String sThreshold = XmlUtil.getOptionalAttributeValue(elDistribute, XmlAttribute.candidate_threshold, "0");
        ArrayList<String> nodeNames = new ArrayList<String>();
        ArrayList<String> vmArgs = new ArrayList<String>();
        ArrayList<String> logLevels = new ArrayList<String>();
        Iterator nodeIt = elNodes.elementIterator(XmlElement.node.getXmlName());
        while (nodeIt.hasNext()) {
            Element elNode = (Element)nodeIt.next();
            nodeNames.add(XmlUtil.getRequiredAttributeValue(elNode, XmlAttribute.name));
            String vmargs = elNode.attributeValue(XmlAttribute.vmargs.getXmlName());
            if (vmargs == null) {
                vmargs = elNodes.attributeValue(XmlAttribute.vmargs.getXmlName());
            }
            vmArgs.add(vmargs);
            String logLevel = elNode.attributeValue(XmlAttribute.level.getXmlName());
            if (logLevel == null) {
                logLevel = elNodes.attributeValue(XmlAttribute.level.getXmlName());
            }
            if (logLevel == null) {
                logLevel = Level.INFO.getName();
            }
            logLevels.add(logLevel);
        }
        this.nodeNames = Collections.unmodifiableList(nodeNames);
        this.vmArgs = Collections.unmodifiableList(vmArgs);
        this.logLevels = Collections.unmodifiableList(logLevels);
        this.command = XmlUtil.getRequiredAttributeValue(elCommand, XmlAttribute.value);
        try {
            this.partition = Integer.parseInt(sPartition);
        }
        catch (Exception e) {
            throw new XmlConfigException("cannot parse distribute attribute 'partitions': " + sPartition + ", e=" + e, (Node)elDistribute, (Throwable)e);
        }
        try {
            this.candidateThreashold = Long.parseLong(sThreshold);
        }
        catch (Exception e) {
            throw new XmlConfigException("cannot parse distribute attribute 'candidate-threshold': " + sThreshold + ", e=" + e, (Node)elDistribute, (Throwable)e);
        }
        int cur = 1;
        while (this.partition / cur > 1) {
            cur <<= 2;
        }
        if (this.partition != cur) {
            throw new IllegalArgumentException("distributed partition must be a power of 4, but is " + this.partition);
        }
    }

    public List<String> getNodeNames() {
        return this.nodeNames;
    }

    public List<String> getVmArgs() {
        return this.vmArgs;
    }

    public List<String> getLogLevels() {
        return this.logLevels;
    }

    public String getCommand() {
        return this.command;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getCandidateThreashold() {
        return this.candidateThreashold;
    }

    public void log(Logger logger, Level level) {
        if (Loggers.isLoggable(logger, level)) {
            logger.log(level, "Distributed Config:");
            logger.log(level, "..node count       : " + this.getNodeNames().size());
            logger.log(level, "..nodes            : " + this.getNodeNames());
            logger.log(level, "..vmargs           : " + this.getVmArgs());
            logger.log(level, "..command          : " + this.getCommand());
            logger.log(level, "..partition        : " + this.getPartition());
            logger.log(level, "..cand. threshold  : " + this.getCandidateThreashold());
        }
    }
}

