/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.jbase.VariableWidthTable;
import ch.javasoft.jbase.concurrent.ConcurrentTable;
import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.BigIntegerOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.AbstractColumn;
import ch.javasoft.metabolic.efm.column.AbstractHome;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.memory.outcore.Cache;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.metabolic.impl.FractionNumberFluxDistribution;
import ch.javasoft.smx.iface.BigIntegerMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.numeric.BigIntegerUtil;
import ch.javasoft.util.numeric.Zero;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerColumn
extends AbstractColumn {
    private int mBoolSize;
    private final IBitSet mBitSet;
    private BigInteger[] mValues;
    public static final Home HOME = new Home(){

        @Override
        public Arithmetic getArithmetic() {
            return Arithmetic.bigint;
        }

        @Override
        public NumberOperations<BigInteger> getNumberOperations() {
            return BigIntegerOperations.instance();
        }

        @Override
        public BigIntegerColumn newInstance(int booleanSize, int numericSize) {
            throw new RuntimeException("not implemented");
        }

        public BigIntegerColumn[] newInstances(ReadableMatrix<BigInteger> matrix, int booleanSize) {
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            BigIntegerColumn[] res = new BigIntegerColumn[cols];
            int col = 0;
            while (col < cols) {
                BigInteger[] vals = new BigInteger[rows];
                int row = 0;
                while (row < rows) {
                    vals[row] = matrix.getNumberValueAt(row, col);
                    ++row;
                }
                res[col] = new BigIntegerColumn(booleanSize, BitSetUtil.factory().create(rows), vals);
                ++col;
            }
            return res;
        }

        @Override
        public BigIntegerColumn readFrom(DataInput dataIn, int booleanSize, int numericSize) throws IOException {
            IBitSet bitSet = this.readBinaryFrom(dataIn, booleanSize);
            BigInteger[] values = new BigInteger[numericSize];
            int i = 0;
            while (i < numericSize) {
                int byteCnt = dataIn.readInt();
                byte[] numBytes = new byte[byteCnt];
                int j = 0;
                while (j < numBytes.length) {
                    numBytes[j] = dataIn.readByte();
                    ++j;
                }
                BigInteger num = new BigInteger(numBytes);
                values[i] = numBytes.length <= 8 ? BigInteger.valueOf(num.longValue()) : num;
                ++i;
            }
            return new BigIntegerColumn(booleanSize, bitSet, values);
        }

        @Override
        public void writeTo(BigIntegerColumn column, DataOutput dataOut) throws IOException {
            this.writeBinaryTo(column, dataOut);
            int i = 0;
            while (i < column.mValues.length) {
                byte[] bytes = column.mValues[i].toByteArray();
                dataOut.writeInt(bytes.length);
                int j = 0;
                while (j < bytes.length) {
                    dataOut.writeByte(bytes[j]);
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public EntityMarshaller<BigIntegerColumn> getEntityMarshaller(final int booleanSize, final int numericSize) throws IOException {
            return new EntityMarshaller<BigIntegerColumn>(){

                @Override
                public BigIntegerColumn readFrom(DataInput in) throws IOException {
                    return (BigIntegerColumn)HOME.readFrom(in, booleanSize, numericSize);
                }

                @Override
                public void writeTo(BigIntegerColumn entity, DataOutput out) throws IOException {
                    HOME.writeTo(entity, out);
                }
            };
        }

        @Override
        public ConcurrentTable<BigIntegerColumn> createTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            int boolByteLen = BitSetUtil.byteSize(booleanSize);
            int numericByteLen = numericSize * 12;
            return new ConcurrentTable<BigIntegerColumn>(VariableWidthTable.create(folder, fileName, boolByteLen + numericByteLen, this.getEntityMarshaller(booleanSize, numericSize), Cache.BigIntegerMemoryTable.getCacheTableSize(), Cache.BigIntegerMemoryTable.getCacheEntrySize()));
        }

        @Override
        public ConcurrentTable<BigIntegerColumn> openTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            return new ConcurrentTable<BigIntegerColumn>(VariableWidthTable.open(folder, fileName, this.getEntityMarshaller(booleanSize, numericSize), Cache.BigIntegerMemoryTable.getCacheTableSize(), Cache.BigIntegerMemoryTable.getCacheEntrySize()));
        }

        public FluxDistribution createFluxDistribution(MetabolicNetwork net, BigInteger[] values) {
            return new FractionNumberFluxDistribution(net, values);
        }

        @Override
        public BigIntegerMatrix convertMatrix(ReadableMatrix matrix, boolean allowRowScaling, boolean allowColumnScaling) {
            if (matrix instanceof ReadableBigIntegerMatrix) {
                return ((ReadableBigIntegerMatrix)matrix).toBigIntegerMatrix(false);
            }
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            DefaultBigIntegerMatrix mx = new DefaultBigIntegerMatrix(rows, cols);
            if (allowRowScaling) {
                int row = 0;
                while (row < rows) {
                    BigInteger lcm = BigInteger.ONE;
                    int col = 0;
                    while (col < cols) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col));
                        lcm = BigIntegerUtil.lcm(lcm, val.getDenominator());
                        ++col;
                    }
                    BigFraction scale = BigFraction.valueOf(lcm.abs());
                    int col2 = 0;
                    while (col2 < cols) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col2));
                        BigFraction scaled = val.multiply(scale).reduce();
                        if (!scaled.isInteger()) {
                            throw new RuntimeException("internal error: could not scale to integer: " + scaled);
                        }
                        mx.setValueAt(row, col2, scaled.toBigInteger());
                        ++col2;
                    }
                    ++row;
                }
            } else if (allowColumnScaling) {
                int col = 0;
                while (col < cols) {
                    BigInteger lcm = BigInteger.ONE;
                    int row = 0;
                    while (row < rows) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col));
                        lcm = BigIntegerUtil.lcm(lcm, val.getDenominator());
                        ++row;
                    }
                    BigFraction scale = BigFraction.valueOf(lcm.abs());
                    int row2 = 0;
                    while (row2 < rows) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row2, col));
                        BigFraction scaled = val.multiply(scale).reduce();
                        if (!scaled.isInteger()) {
                            throw new RuntimeException("internal error: could not scale to integer: " + scaled);
                        }
                        mx.setValueAt(row2, col, scaled.toBigInteger());
                        ++row2;
                    }
                    ++col;
                }
            } else {
                throw new IllegalArgumentException("either allowRowScaling or allowColumnScaling must be true");
            }
            return mx;
        }

        @Override
        public ReadableMatrix<BigInteger> castMatrix(ReadableMatrix matrix) {
            if (matrix instanceof ReadableBigIntegerMatrix) {
                return ((ReadableBigIntegerMatrix)matrix).toBigIntegerMatrix(false);
            }
            throw new ClassCastException("not a ReadableBigIntegerMatrix: " + matrix.getClass().getName());
        }

        @Override
        public BigIntegerColumn castColumn(Column column) {
            return (BigIntegerColumn)column;
        }

        @Override
        public BigInteger castNumber(Number number) {
            return (BigInteger)number;
        }

        @Override
        public int rank(ReadableMatrix matrix, Zero zero) {
            return new Gauss(zero.mZeroPos).rank((ReadableBigIntegerRationalMatrix)matrix);
        }
    };

    public BigIntegerColumn(int boolSize) {
        this.mBoolSize = boolSize;
        this.mBitSet = BitSetUtil.factory().create(boolSize);
        this.mValues = new BigInteger[0];
    }

    protected BigIntegerColumn(int boolSize, IBitSet bitSet, BigInteger[] values) {
        this.mBoolSize = boolSize;
        this.mBitSet = bitSet;
        this.mValues = values;
    }

    @Override
    public IBitSet bitValues() {
        return this.mBitSet;
    }

    @Override
    public <N extends Number> N getNumeric(ColumnHome<N, ?> columnHome, int row) {
        return columnHome.castNumber(this.mValues[row]);
    }

    @Override
    public int booleanSize() {
        return this.mBoolSize;
    }

    @Override
    public int numericSize() {
        return this.mValues.length;
    }

    public int size() {
        return this.mBoolSize + this.mValues.length;
    }

    @Override
    public int getNumericSignum(Zero zero, int row) {
        return this.mValues[row].signum();
    }

    @Override
    public int getHyperplaneSign(EfmModel model, IterationStateModel iteration) {
        return BigIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class).getHyperplaneSign(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration);
    }

    @Override
    public <Col extends Column> Col convert(ColumnHome<?, Col> columnHome, EfmModel model, IterationStepModel iteration, boolean clone) {
        ColumnInspectorModifier<BigInteger, BigInteger[]> modifier = BigIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class);
        IBitSet newBin = modifier.convertBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration, clone);
        BigInteger[] newNum = modifier.convertNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration, clone);
        if (clone) {
            return columnHome.castColumn(new BigIntegerColumn(iteration.getNextState().getBooleanSize(), newBin, newNum));
        }
        this.mBoolSize = iteration.getNextState().getBooleanSize();
        if (this.mBitSet != newBin) {
            this.mBitSet.clear();
            this.mBitSet.or(newBin);
        }
        this.mValues = newNum;
        return columnHome.castColumn(this);
    }

    @Override
    public <Col extends Column> Col mergeWith(ColumnHome<?, Col> columnHome, EfmModel model, Col other, IterationStepModel iteration) {
        return columnHome.castColumn(this.mergeWith(model, (BigIntegerColumn)other, iteration));
    }

    public BigIntegerColumn mergeWith(EfmModel model, BigIntegerColumn other, IterationStepModel iteration) {
        ColumnInspectorModifier<BigInteger, BigInteger[]> modifier = BigIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class);
        IBitSet newBin = modifier.mergeBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, other.mBitSet, other.mBoolSize, other.mValues, iteration);
        BigInteger[] newNum = modifier.mergeNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, other.mBitSet, other.mBoolSize, other.mValues, iteration);
        return new BigIntegerColumn(iteration.getNextState().getBooleanSize(), newBin, newNum);
    }

    @Override
    public void writeTo(DataOutput dataOut) throws IOException {
        this.columnHome().writeTo(this, dataOut);
    }

    @Override
    public BigIntegerColumn clone() {
        return new BigIntegerColumn(this.mBoolSize, this.mBitSet.clone(), (BigInteger[])this.mValues.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BigIntegerColumn) {
            BigIntegerColumn col = (BigIntegerColumn)obj;
            return this.mBoolSize == col.mBoolSize && this.mBitSet.equals(col.mBitSet) && Arrays.equals(this.mValues, col.mValues);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        int ii = 0;
        while (ii < this.mBoolSize) {
            sb.append(this.mBitSet.get(ii) ? (char)'1' : '0');
            ++ii;
        }
        ii = 0;
        while (ii < this.mValues.length) {
            if (this.mBoolSize > 0 || ii > 0) {
                sb.append(", ");
            }
            sb.append(this.mValues[ii]);
            ++ii;
        }
        sb.append('}');
        return sb.toString();
    }

    public Home columnHome() {
        return HOME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Home
    extends AbstractHome<BigInteger, BigIntegerColumn>
    implements ColumnHome<BigInteger, BigIntegerColumn> {
        public abstract BigIntegerMatrix convertMatrix(ReadableMatrix var1, boolean var2, boolean var3);
    }
}

