/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.urank.frac2;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.efm.adj.incore.tree.urank.RankUpdateRoot;
import ch.javasoft.metabolic.efm.rankup.PreprocessableMatrix;
import ch.javasoft.metabolic.efm.rankup.PreprocessedMatrix;
import ch.javasoft.metabolic.efm.rankup.RankUpRoot;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fractional2PreprocessedMatrix
implements PreprocessedMatrix {
    private final BigFraction[][] matrix;
    private final int rank;
    private final IBitSet unusedBits;
    private BigFraction[][] matrixResidue;

    public Fractional2PreprocessedMatrix(Fractional2PreprocessedMatrix copyOf) {
        this.matrix = Fractional2PreprocessedMatrix.deepClone(copyOf.matrix);
        this.matrixResidue = copyOf.matrixResidue == null ? null : Fractional2PreprocessedMatrix.deepClone((BigFraction[][])copyOf.matrixResidue.clone());
        this.rank = copyOf.rank;
        this.unusedBits = copyOf.unusedBits.clone();
    }

    public Fractional2PreprocessedMatrix(PreprocessableMatrix owner, RankUpdateRoot root) {
        int stoichRank = root.getStoichRank();
        int[] colmap = root.getColMapping();
        IBitSet bits = BitSetUtil.factory().create(colmap.length);
        int i = 0;
        while (i < colmap.length) {
            bits.set(i);
            ++i;
        }
        this.matrix = Fractional2PreprocessedMatrix.toArray(root.getStoichRational());
        this.rank = Fractional2PreprocessedMatrix.computeRank(this.matrix, stoichRank, stoichRank, 0, colmap, bits, bits, owner.nodeCutSet);
        this.unusedBits = bits;
        this.matrixResidue = Fractional2PreprocessedMatrix.initResidue(this.matrix, this.rank, this.unusedBits, colmap);
    }

    public Fractional2PreprocessedMatrix(PreprocessableMatrix owner, RankUpdateRoot root, Fractional2PreprocessedMatrix parentProcessed) {
        this.matrix = parentProcessed.matrix;
        this.unusedBits = parentProcessed.unusedBits.clone();
        int stoichRank = root.getStoichRank();
        int[] colmap = root.getColMapping();
        Fractional2PreprocessedMatrix.restoreResidue(this.matrix, parentProcessed.matrixResidue, parentProcessed.rank, this.unusedBits, colmap);
        this.rank = Fractional2PreprocessedMatrix.computeRank(this.matrix, stoichRank, stoichRank, parentProcessed.rank, colmap, this.unusedBits, this.unusedBits, owner.nodeCutSet);
        this.matrixResidue = Fractional2PreprocessedMatrix.initResidue(this.matrix, this.rank, this.unusedBits, colmap);
    }

    @Override
    public boolean hasRequiredRank(RankUpRoot root, IBitSet intersectionSet) {
        int stoichRank = root.getStoichRank();
        int reqRank = root.getRequiredRank() - intersectionSet.cardinality();
        int[] colmap = root.getColMapping();
        Fractional2PreprocessedMatrix.restoreResidue(this.matrix, this.matrixResidue, this.rank, this.unusedBits, colmap);
        return reqRank <= this.rank || reqRank <= Fractional2PreprocessedMatrix.computeRank(this.matrix, stoichRank, reqRank, this.rank, colmap, this.unusedBits, null, intersectionSet);
    }

    public String toString() {
        return "preprocessed(" + this.rank + ")=" + this.matrix;
    }

    @Override
    public Fractional2PreprocessedMatrix clone() {
        return new Fractional2PreprocessedMatrix(this);
    }

    private static int computeRank(BigFraction[][] mx, int stoichRank, int stopRank, int rank, int[] fixcolmap, IBitSet unusedBits, IBitSet unusedBitsOut, IBitSet setToCompute) {
        int bits = fixcolmap.length;
        int[] colmap = new int[bits];
        int[] bitmap = new int[bits];
        int colsAct = rank;
        int colsPas = bits;
        int bit = unusedBits.nextSetBit(0);
        while (bit >= 0) {
            if (!setToCompute.get(bit)) {
                bitmap[colsAct] = bit;
                colmap[colsAct] = fixcolmap[bit];
                ++colsAct;
            } else {
                colmap[--colsPas] = fixcolmap[bit];
            }
            bit = unusedBits.nextSetBit(bit + 1);
        }
        if (colsPas != colsAct) {
            throw new RuntimeException("internal error, colsPas should be same as colsAct: " + colsPas + "!=" + colsAct);
        }
        int colsTot = bits;
        int rows = mx.length;
        int pivs = Math.min(stopRank, Math.min(rows, colsAct));
        int ipiv = rank;
        while (ipiv < pivs) {
            int prow = ipiv;
            int picol = ipiv;
            int plen = Integer.MAX_VALUE;
            int zlen = 0;
            int row = ipiv;
            while (row < rows) {
                int zerCnt = 0;
                int icol = ipiv;
                while (icol < colsAct) {
                    if (mx[row][colmap[icol]].signum() == 0) {
                        ++zerCnt;
                    }
                    ++icol;
                }
                icol = ipiv;
                while (icol < colsAct) {
                    int col = colmap[icol];
                    if (mx[row][col].signum() != 0) {
                        BigInteger num = mx[row][col].getNumerator();
                        BigInteger den = mx[row][col].getDenominator();
                        int len = num.abs().bitLength() + den.abs().bitLength();
                        if (len < plen || len == plen && zerCnt > zlen) {
                            prow = row;
                            picol = icol;
                            plen = len;
                            zlen = zerCnt;
                        }
                    }
                    ++icol;
                }
                ++row;
            }
            if (mx[prow][colmap[picol]].signum() == 0) {
                Fractional2PreprocessedMatrix.trace("rank=" + ipiv + ":unused-new", bits, unusedBits);
                return ipiv;
            }
            if (prow != ipiv) {
                Arrays.swap((Object[])mx, prow, ipiv);
            }
            if (picol != ipiv) {
                IntArray.swap(colmap, picol, ipiv);
                IntArray.swap(bitmap, picol, ipiv);
            }
            if (unusedBitsOut != null) {
                unusedBitsOut.clear(bitmap[ipiv]);
            }
            int pivrow = ipiv;
            int pivcol = colmap[ipiv];
            IntArray pivCols = new IntArray();
            BigFraction pval = mx[pivrow][pivcol];
            int icol = ipiv + 1;
            while (icol < colsTot) {
                int col = colmap[icol];
                if (mx[pivrow][col].isNonZero()) {
                    mx[pivrow][col] = mx[pivrow][col].divide(pval).reduce();
                    pivCols.add(col);
                }
                ++icol;
            }
            mx[pivrow][pivcol] = BigFraction.ONE;
            int row2 = ipiv + 1;
            while (row2 < rows) {
                BigFraction rpiv = mx[row2][pivcol];
                mx[row2][pivcol] = BigFraction.ZERO;
                int icol2 = 0;
                while (icol2 < pivCols.length()) {
                    int col = pivCols.get(icol2);
                    BigFraction val = mx[row2][col];
                    BigFraction sub = mx[pivrow][col];
                    val = val.subtract(sub.multiply(rpiv));
                    mx[row2][col] = val.reduce();
                    ++icol2;
                }
                ++row2;
            }
            ++ipiv;
        }
        return pivs;
    }

    private static BigFraction[][] initResidue(BigFraction[][] matrix, int rank, IBitSet unusedBits, int[] fixcolmap) {
        int rows = matrix.length;
        int cols = rows == 0 ? 0 : matrix[0].length;
        BigFraction[][] residue = new BigFraction[rows - rank][cols - rank];
        int i = 0;
        while (i < residue.length) {
            int j = 0;
            int bit = unusedBits.nextSetBit(0);
            while (bit >= 0) {
                residue[i][j] = matrix[rank + i][fixcolmap[bit]];
                ++j;
                bit = unusedBits.nextSetBit(bit + 1);
            }
            ++i;
        }
        return residue;
    }

    private static void restoreResidue(BigFraction[][] matrix, BigFraction[][] residue, int rank, IBitSet unusedBits, int[] fixcolmap) {
        int i = 0;
        while (i < residue.length) {
            int j = 0;
            int bit = unusedBits.nextSetBit(0);
            while (bit >= 0) {
                matrix[rank + i][fixcolmap[bit]] = residue[i][j];
                ++j;
                bit = unusedBits.nextSetBit(bit + 1);
            }
            ++i;
        }
    }

    private static BigFraction[][] toArray(ReadableMatrix<BigFraction> stoich) {
        int rows = stoich.getRowCount();
        int cols = stoich.getColumnCount();
        BigFraction[][] arr = new BigFraction[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                arr[row][col] = stoich.getNumberValueAt(row, col);
                ++col;
            }
            ++row;
        }
        return arr;
    }

    private static BigFraction[][] deepClone(BigFraction[][] mx) {
        BigFraction[][] clone = (BigFraction[][])mx.clone();
        int i = 0;
        while (i < clone.length) {
            clone[i] = (BigFraction[])clone[i].clone();
            ++i;
        }
        return clone;
    }

    private static void trace(String what, int len, IBitSet ... sets) {
    }

    private static void traceAlways(String what, int len, IBitSet ... sets) {
        String[] whats = what.split(":");
        int w = 0;
        if (whats.length > sets.length) {
            System.out.println(whats[0]);
            w = 1;
        }
        IBitSet[] iBitSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IBitSet set = iBitSetArray[n2];
            System.out.print(String.valueOf(whats[w++]) + "=");
            int i = 0;
            while (i < len) {
                System.out.print(set.get(i) ? (char)'1' : '0');
                ++i;
            }
            System.out.println();
            ++n2;
        }
    }
}

