/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.urank.dbl;

import ch.javasoft.metabolic.efm.adj.incore.tree.urank.RankUpdateJobScheduleTreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.urank.RankUpdateRoot;
import ch.javasoft.metabolic.efm.adj.incore.tree.urank.dbl.DoublePreprocessedMatrix;
import ch.javasoft.metabolic.efm.concurrent.RankUpdateToken;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.rankup.PreprocessableMatrix;
import ch.javasoft.metabolic.efm.rankup.PreprocessedMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.numeric.Zero;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleRankUpdateTreeFactory
extends RankUpdateJobScheduleTreeFactory {
    public DoubleRankUpdateTreeFactory(EfmModel efmModel) {
        super(efmModel);
    }

    @Override
    protected PreprocessedMatrix createInitialPreprocessedMatrix(PreprocessableMatrix owner, RankUpdateToken token, RankUpdateRoot root) {
        return new DoublePreprocessedMatrix(owner, root, DoubleRankUpdateTreeFactory.convertToDoubleMatrix(root.getStoichRational()));
    }

    @Override
    protected PreprocessedMatrix createChildPreprocessedMatrix(PreprocessableMatrix owner, RankUpdateToken token, RankUpdateRoot root, PreprocessedMatrix parentPreprocessedMatrix) {
        DoublePreprocessedMatrix parent = (DoublePreprocessedMatrix)parentPreprocessedMatrix;
        return new DoublePreprocessedMatrix(owner, root, parent);
    }

    public int getRank(Zero zero, ReadableMatrix<? extends Number> matrix) {
        DoubleMatrix mx = DoubleRankUpdateTreeFactory.convertToDoubleMatrix(matrix);
        return new Gauss(zero.mZeroPos).rank(mx);
    }

    private static DoubleMatrix convertToDoubleMatrix(ReadableMatrix mx) {
        if (mx instanceof ReadableDoubleMatrix) {
            return ((ReadableDoubleMatrix)mx).toDoubleMatrix(true);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }
}

