/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.metabolic.efm.adj.incore.tree.InterNode;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.concurrent.TimeoutWaitingReleasePolicy;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueue<T extends ConcurrentToken> {
    private final T token;
    private final Root<T> root;
    private final SortableMemory<Column> posCols;
    private final SortableMemory<Column> zeroCols;
    private final SortableMemory<Column> negCols;
    private final boolean nodeAIsPos;
    private final Queue<ColumnPair> adjacentPairs;
    private final ConcurrentLinkedQueue<Runnable> queue;
    public static final int MAX_LEVEL_DEPTH = 6;

    public JobQueue(Config config, int threadCount, T token, Root<T> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<T> nodeA, Node<T> nodeB, boolean nodeAIsPos, Queue<ColumnPair> adjacentPairs) {
        this.token = token;
        this.root = root;
        this.posCols = posCols;
        this.zeroCols = zeroCols;
        this.negCols = negCols;
        this.nodeAIsPos = nodeAIsPos;
        this.adjacentPairs = adjacentPairs;
        this.queue = this.getJobQueue(nodeA, nodeB);
    }

    public static <T extends ConcurrentToken, I> JobQueue<T> createQueue(Config config, T token, Root<T> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<T> nodeA, Node<T> nodeB, boolean nodeAIsPos, Queue<ColumnPair> adjacentPairs) {
        int threadCount = token.drainPermits();
        if (threadCount > 0) {
            JobQueue<T> queue = new JobQueue<T>(config, threadCount, token, root, posCols, zeroCols, negCols, nodeA, nodeB, nodeAIsPos, adjacentPairs);
            super.startChildThreads(config, threadCount, token, root, posCols, zeroCols, negCols, nodeA, nodeB, nodeAIsPos, adjacentPairs);
            return queue;
        }
        return null;
    }

    private <I> void startChildThreads(Config config, int threadCount, final T token, Root<T> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<T> nodeA, Node<T> nodeB, boolean nodeAIsPos, Queue<ColumnPair> adjacentPairs) {
        final TimeoutWaitingReleasePolicy releasePolicy = new TimeoutWaitingReleasePolicy();
        releasePolicy.initialize(config, 256, threadCount);
        int i = 0;
        while (i < threadCount) {
            token.createChildThread(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Runnable job = (Runnable)JobQueue.this.queue.poll();
                    while (job != null) {
                        job.run();
                        job = (Runnable)JobQueue.this.queue.poll();
                    }
                    releasePolicy.releasePermit(token);
                    return null;
                }
            }, null).start();
            ++i;
        }
    }

    public void execParentThread() {
        Runnable job = this.queue.poll();
        while (job != null) {
            job.run();
            job = this.queue.poll();
        }
    }

    private ConcurrentLinkedQueue<Runnable> getJobQueue(Node<T> nodeA, Node<T> nodeB) {
        ConcurrentLinkedQueue<Runnable> jobs = new ConcurrentLinkedQueue<Runnable>();
        this.addToJobQueue(0, jobs, nodeA, nodeB);
        return jobs;
    }

    private void addToJobQueue(int level, ConcurrentLinkedQueue<Runnable> jobs, Node<T> nodeA, Node<T> nodeB) {
        if (level < 6) {
            ++level;
            if (nodeA instanceof InterNode) {
                if (this.root.enterIfCandidates(this.token, nodeA, nodeB)) {
                    InterNode interA = (InterNode)nodeA;
                    if (nodeB instanceof InterNode) {
                        InterNode interB = (InterNode)nodeB;
                        this.addToJobQueue(level, jobs, interA.child0, interB.child0);
                        this.addToJobQueue(level, jobs, interA.child1, interB.child0);
                        this.addToJobQueue(level, jobs, interA.child0, interB.child1);
                        this.addToJobQueue(level, jobs, interA.child1, interB.child1);
                    } else {
                        this.addToJobQueue(level, jobs, interA.child0, nodeB);
                        this.addToJobQueue(level, jobs, interA.child1, nodeB);
                    }
                    this.root.leave(this.token, nodeA, nodeB);
                }
            } else if (nodeB instanceof InterNode) {
                if (this.root.enterIfCandidates(this.token, nodeA, nodeB)) {
                    InterNode interB = (InterNode)nodeB;
                    this.addToJobQueue(level, jobs, nodeA, interB.child0);
                    this.addToJobQueue(level, jobs, nodeA, interB.child1);
                    this.root.leave(this.token, nodeA, nodeB);
                }
            } else {
                this.addJobToQueue(jobs, nodeA, nodeB);
            }
        } else {
            this.addJobToQueue(jobs, nodeA, nodeB);
        }
    }

    private void addJobToQueue(ConcurrentLinkedQueue<Runnable> jobs, final Node<T> nodeA, final Node<T> nodeB) {
        jobs.add(new Runnable(){

            public void run() {
                try {
                    nodeA.addAdjacentPairs(JobQueue.this.token, JobQueue.this.root, JobQueue.this.posCols, JobQueue.this.zeroCols, JobQueue.this.negCols, nodeB, JobQueue.this.nodeAIsPos, JobQueue.this.adjacentPairs);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

