/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.sort;

import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixSortUtil {
    public static final <A> void sortMatrixRows(A[] matrix, Comparator<? super A> comparator) {
        Arrays.sort(matrix, comparator);
    }

    public static final <A> void sortMatrixRows(A[] matrix, int fromRow, int toRow, Comparator<? super A> comparator) {
        Arrays.sort(matrix, fromRow, toRow, comparator);
    }

    public static final <A> int[] getSortedMatrixRows(A[] matrix, Comparator<? super A> comparator) {
        return MatrixSortUtil.getSortedMatrixRows(matrix, 0, matrix.length, comparator);
    }

    public static final <A> int[] getSortedMatrixRows(A[] matrix, int fromRow, int toRow, Comparator<? super A> comparator) {
        IndexEntry<A>[] entries = MatrixSortUtil.createIndexEntryArrayFromRows(matrix, fromRow, toRow);
        Arrays.sort(entries, new IndexEntryComparator<A>(comparator));
        return MatrixSortUtil.entriesToMapping(entries);
    }

    private static <A> IndexEntry<A>[] createIndexEntryArrayFromRows(A[] matrix, int fromRow, int toRow) {
        IndexEntry[] entries = new IndexEntry[toRow - fromRow];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new IndexEntry<A>(fromRow + i, matrix[fromRow + i]);
            ++i;
        }
        return entries;
    }

    private static int[] entriesToMapping(IndexEntry<?>[] entries) {
        int[] mapping = new int[entries.length];
        int i = 0;
        while (i < mapping.length) {
            mapping[i] = entries[i].index;
            ++i;
        }
        return mapping;
    }

    private MatrixSortUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexEntry<T> {
        public final int index;
        public final T value;

        public IndexEntry(int index, T value) {
            this.index = index;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexEntryComparator<T>
    implements Comparator<IndexEntry<T>> {
        private final Comparator<? super T> comparator;

        public IndexEntryComparator(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(IndexEntry<T> o1, IndexEntry<T> o2) {
            return this.comparator.compare(o1.value, o2.value);
        }
    }
}

