/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.Converter;
import ch.javasoft.math.array.ExpressionComposer;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.UnaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NumberArrayOperations<N extends Number, A> {
    public Class<N> numberClass();

    public Class<A> arrayClass();

    public NumberOperators<N, A> getNumberOperators();

    public ArrayOperations<A> getArrayOperations();

    public <IN extends Number, IA> Converter<IN, IA, N, A> getConverterFrom(NumberArrayOperations<IN, IA> var1);

    public <RN extends Number, RA> Converter<N, A, RN, RA> getConverterTo(NumberArrayOperations<RN, RA> var1);

    public ExpressionComposer<N, A> getExpressionComposer();

    public N convertNumber(Number var1);

    public A newVector(int var1, N var2);

    public A[] newMatrix(int var1, int var2, N var3);

    public A newZeroVector(int var1);

    public A[] newZeroMatrix(int var1, int var2);

    public A newOneVector(int var1);

    public A[] newOneMatrix(int var1, int var2);

    public A[] newIdentityMatrix(int var1);

    public A[] newDiagonalMatrix(int var1, N var2);

    public A[] newDiagonalMatrix(A var1);

    public N get(A var1, int var2);

    public N get(A[] var1, int var2, int var3);

    public int getSignum(A var1, int var2);

    public int getSignum(A[] var1, int var2, int var3);

    public long[] getVectorSupportAsLongBits(A var1);

    public long[][] getMatrixSupportAsLongBits(A[] var1);

    public long[] getMatrixRowSupportAsLongBits(A[] var1, int var2);

    public long[] getMatrixColumnSupportAsLongBits(A[] var1, int var2);

    public void set(A var1, int var2, N var3);

    public void set(A[] var1, int var2, int var3, N var4);

    public void setAll(A var1, N var2);

    public void setAll(A[] var1, N var2);

    public A applyToEachElement(A var1, UnaryOperator<N, A> var2);

    public void applyToEachElement(A var1, A var2, UnaryOperator<N, A> var3);

    public void applyToEachElement(A var1, int var2, A var3, int var4, int var5, UnaryOperator<N, A> var6);

    public A[] applyToEachElement(A[] var1, UnaryOperator<N, A> var2);

    public void applyToEachElement(A[] var1, A[] var2, UnaryOperator<N, A> var3);

    public void applyToEachRowElement(A[] var1, int var2, A[] var3, int var4, UnaryOperator<N, A> var5);

    public void applyToEachRowElement(A[] var1, int var2, int var3, A[] var4, int var5, int var6, int var7, UnaryOperator<N, A> var8);

    public void applyToEachColumnElement(A[] var1, int var2, A[] var3, int var4, UnaryOperator<N, A> var5);

    public void applyToEachColumnElement(A[] var1, int var2, int var3, A[] var4, int var5, int var6, int var7, UnaryOperator<N, A> var8);

    public void applyToEachDiagonalElement(A[] var1, A[] var2, UnaryOperator<N, A> var3);

    public A applyToElementByElement(A var1, A var2, BinaryOperator<N, A> var3);

    public void applyToElementByElement(A var1, A var2, A var3, BinaryOperator<N, A> var4);

    public A[] applyToElementByElement(A[] var1, A[] var2, BinaryOperator<N, A> var3);

    public void applyToElementByElement(A[] var1, A[] var2, A[] var3, BinaryOperator<N, A> var4);

    public N applyTo(A var1, AggregatingUnaryOperator<N, A> var2);

    public N applyToRow(A[] var1, int var2, AggregatingUnaryOperator<N, A> var3);

    public A applyToEachRow(A[] var1, AggregatingUnaryOperator<N, A> var2);

    public void applyToEachRow(A[] var1, A var2, AggregatingUnaryOperator<N, A> var3);

    public N applyToColumn(A[] var1, int var2, AggregatingUnaryOperator<N, A> var3);

    public A applyToEachColumn(A[] var1, AggregatingUnaryOperator<N, A> var2);

    public void applyToEachColumn(A[] var1, A var2, AggregatingUnaryOperator<N, A> var3);

    public N applyTo(A var1, A var2, AggregatingBinaryOperator<N, A> var3);

    public int evalInt(A var1, int var2, IntUnaryOperator<N, A> var3);

    public int evalInt(A[] var1, int var2, int var3, IntUnaryOperator<N, A> var4);

    public boolean evalBoolean(A var1, int var2, BooleanUnaryOperator<N, A> var3);

    public boolean evalBoolean(A[] var1, int var2, int var3, BooleanUnaryOperator<N, A> var4);

    public boolean anyBoolean(A var1, BooleanUnaryOperator<N, A> var2);

    public boolean anyBoolean(A var1, int[] var2, BooleanUnaryOperator<N, A> var3);

    public boolean anyBooleanInRange(A var1, int var2, int var3, BooleanUnaryOperator<N, A> var4);

    public boolean anyBoolean(A[] var1, BooleanUnaryOperator<N, A> var2);

    public boolean anyBoolean(A[] var1, int[] var2, int[] var3, BooleanUnaryOperator<N, A> var4);

    public boolean anyBooleanInRow(A[] var1, int var2, BooleanUnaryOperator<N, A> var3);

    public boolean anyBooleanInColumn(A[] var1, int var2, BooleanUnaryOperator<N, A> var3);

    public boolean anyBooleanInRange(A[] var1, int var2, int var3, int var4, int var5, BooleanUnaryOperator<N, A> var6);

    public boolean anyBooleanInDiagonal(A[] var1, BooleanUnaryOperator<N, A> var2);

    public boolean allBoolean(A var1, BooleanUnaryOperator<N, A> var2);

    public boolean allBoolean(A var1, int[] var2, BooleanUnaryOperator<N, A> var3);

    public boolean allBooleanInRange(A var1, int var2, int var3, BooleanUnaryOperator<N, A> var4);

    public boolean allBoolean(A[] var1, BooleanUnaryOperator<N, A> var2);

    public boolean allBoolean(A[] var1, int[] var2, int[] var3, BooleanUnaryOperator<N, A> var4);

    public boolean allBooleanInRow(A[] var1, int var2, BooleanUnaryOperator<N, A> var3);

    public boolean allBooleanInColumn(A[] var1, int var2, BooleanUnaryOperator<N, A> var3);

    public boolean allBooleanInRange(A[] var1, int var2, int var3, int var4, int var5, BooleanUnaryOperator<N, A> var6);

    public boolean allBooleanInDiagonal(A[] var1, BooleanUnaryOperator<N, A> var2);
}

