/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.junit.textui;

import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.Version;
import junit.textui.ResultPrinter;

public class TestRunner
extends junit.textui.TestRunner {
    public TestRunner() {
    }

    public TestRunner(PrintStream writer) {
        super(writer);
    }

    public TestRunner(ResultPrinter printer) {
        super(printer);
    }

    public Test getTest(String suiteClassName) {
        String className = suiteClassName;
        String methodName = null;
        int index = suiteClassName.indexOf(35);
        if (index > 0) {
            className = suiteClassName.substring(0, index);
            methodName = suiteClassName.substring(index + 1);
        }
        Test test = super.getTest(className);
        if (methodName != null && test instanceof TestSuite) {
            TestSuite suite = (TestSuite)test;
            int ii = 0;
            while (ii < suite.testCount()) {
                Test methodTest = suite.testAt(ii);
                if (methodTest instanceof TestCase && methodName.equals(((TestCase)methodTest).getName())) {
                    return methodTest;
                }
                ++ii;
            }
            this.runFailed("StackTrace \"" + methodName + "\" not found in class \"" + className + "\"");
            return null;
        }
        return test;
    }

    public TestResult start(String[] args) throws Exception {
        String testCase = "";
        boolean wait = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-wait")) {
                wait = true;
            } else if (args[i].equals("-c")) {
                testCase = this.extractClassName(args[++i]);
            } else if (args[i].equals("-v")) {
                System.err.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
            } else {
                testCase = args[i];
            }
            ++i;
        }
        if (testCase.equals("")) {
            throw new Exception("Usage: TestName[#testCaseName] [-wait], where TestName is the name of the TestCase class, testCaseName that of a test method");
        }
        try {
            Test suite = this.getTest(testCase);
            return this.doRun(suite, wait);
        }
        catch (Exception e) {
            throw new Exception("Could not create and run test suite: " + e);
        }
    }

    public static void main(String[] args) {
        TestRunner aTestRunner = new TestRunner();
        try {
            TestResult r = aTestRunner.start(args);
            if (!r.wasSuccessful()) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }
}

