/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.variable;

import ch.javasoft.jsmat.ReservedComplexWriter;
import ch.javasoft.jsmat.ReservedMatrixWriter;
import ch.javasoft.jsmat.ReservedWriter;
import ch.javasoft.jsmat.common.MatClass;
import ch.javasoft.jsmat.variable.MatAllocated;
import ch.javasoft.jsmat.variable.MatReserved;
import ch.javasoft.jsmat.variable.MatReservedComplex;
import ch.javasoft.jsmat.variable.MatReservedMatrix;
import ch.javasoft.jsmat.variable.MatStructure;
import ch.javasoft.jsmat.variable.MatVariable;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatReservedStructure
extends MatReservedComplex {
    private final Map<String, ? extends MatVariable>[] mFields;
    private int mNextFieldIndex = 0;
    private boolean mUnclosedWriter = false;

    public MatReservedStructure(Map<String, ? extends MatVariable> fields) {
        this(new Map[]{fields}, new int[]{1, 1});
    }

    public MatReservedStructure(Map<String, ? extends MatVariable>[] fields, int[] dims) {
        super(MatClass.STRUCT, dims);
        this.mFields = fields;
    }

    protected void checkNoReservedWriter() throws IOException {
        if (this.mUnclosedWriter) {
            throw new IOException("unclosed reserved field writer found, close it first");
        }
    }

    @Override
    public void writeDataBlockStart(String name, DataOutput out) throws IOException {
        this.writeStart(name, out);
        MatStructure.writeStructStart(out, this.mFields);
        this.writeAllocatedFields(out);
    }

    @Override
    public void writeDataBlockEnd(DataOutput out) throws IOException {
        if (this.getFieldCount() != this.mNextFieldIndex) {
            throw new IOException("not all fields have been written: " + this.mNextFieldIndex + " of " + this.getFieldCount() + ". should open reserved writer for field " + this.getFieldName(this.getNextField()));
        }
        this.mNextFieldIndex = 0;
    }

    @Override
    public <A> ReservedMatrixWriter<A> createReservedWriter(ReservedComplexWriter writer, MatReservedMatrix<A> reservedMatrix) throws IOException {
        this.checkNoReservedWriter();
        this.checkNextReservedField(reservedMatrix);
        this.mUnclosedWriter = true;
        return new ReservedMatrixWriter<A>(writer, reservedMatrix, reservedMatrix){
            {
                this.open(MatReservedStructure.this.getFieldName(matReservedMatrix));
            }

            @Override
            public void close() throws IOException {
                MatReservedStructure matReservedStructure = MatReservedStructure.this;
                matReservedStructure.mNextFieldIndex = matReservedStructure.mNextFieldIndex + 1;
                MatReservedStructure.this.writeAllocatedFields(this.mDataOutput);
                super.close();
                MatReservedStructure.this.mUnclosedWriter = false;
            }
        };
    }

    @Override
    public ReservedWriter createReservedWriter(ReservedComplexWriter writer, MatReserved reserved) throws IOException {
        this.checkNoReservedWriter();
        this.checkNextReservedField(reserved);
        this.mUnclosedWriter = true;
        return new ReservedWriter(writer, reserved, reserved){
            {
                this.open(MatReservedStructure.this.getFieldName(matReserved));
            }

            public void close() throws IOException {
                MatReservedStructure matReservedStructure = MatReservedStructure.this;
                matReservedStructure.mNextFieldIndex = matReservedStructure.mNextFieldIndex + 1;
                this.mReserved.writeDataBlockEnd(this.mDataOutput);
                MatReservedStructure.this.writeAllocatedFields(this.mDataOutput);
                this.closeVariableWriter();
                MatReservedStructure.this.mUnclosedWriter = false;
            }
        };
    }

    private void writeAllocatedFields(DataOutput out) throws IOException {
        MatVariable var;
        while ((var = this.getNextField()) instanceof MatAllocated) {
            MatAllocated all = (MatAllocated)var;
            all.write(this.getFieldName(var), out);
            ++this.mNextFieldIndex;
        }
    }

    private void checkNextReservedField(MatReserved reserved) throws IllegalArgumentException {
        MatVariable var = this.getNextField();
        if (var != reserved) {
            String curName = this.getFieldName(reserved);
            String expName = this.getFieldName(var);
            throw new IllegalArgumentException("must open reserved writers for structure fields ordered, expected " + (expName == null ? "closing the structure writer" : expName) + " but found " + (curName == null ? "field " + reserved + " not belonging to this structure" : curName));
        }
    }

    private MatVariable getNextField() {
        int index = 0;
        int i = 0;
        while (i < this.mFields.length) {
            for (String name : this.mFields[i].keySet()) {
                if (index == this.mNextFieldIndex) {
                    return this.mFields[i].get(name);
                }
                ++index;
            }
            ++i;
        }
        return null;
    }

    private String getFieldName(MatVariable var) {
        int i = 0;
        while (i < this.mFields.length) {
            for (String name : this.mFields[i].keySet()) {
                MatVariable cur = this.mFields[i].get(name);
                if (cur != var) continue;
                return name;
            }
            ++i;
        }
        return null;
    }

    private int getFieldCount() {
        int count = 0;
        int i = 0;
        while (i < this.mFields.length) {
            count += this.mFields[i].size();
            ++i;
        }
        return count;
    }

    @Override
    protected int getRawDataSize() {
        return MatStructure.getRawDataSize(this.mFields);
    }
}

