/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat;

import ch.javasoft.io.DataOutputOutputStream;
import ch.javasoft.jsmat.MatWriter;
import ch.javasoft.jsmat.VariableWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileWriter
extends MatWriter<RandomAccessFile> {
    private final RandomAccessFile mFile;

    public MatFileWriter(File file) throws IOException {
        this(new RandomAccessFile(file, "rw"));
    }

    public MatFileWriter(RandomAccessFile file) throws IOException {
        super(file);
        this.mFile = file;
    }

    @Override
    protected void initDataOutput(RandomAccessFile ras) throws IOException {
        ras.setLength(0L);
    }

    @Override
    protected VariableWriter createVariableWriter() throws IOException {
        return new VariableWriter(){
            private long posSize;
            private long posStart;
            private DeflaterOutputStream deflater;
            private DataOutputStream dataDefOut;

            public DataOutput open() throws IOException {
                MatFileWriter.this.mFile.writeInt(15);
                this.posSize = MatFileWriter.this.mFile.getFilePointer();
                MatFileWriter.this.mFile.writeInt(0);
                this.posStart = MatFileWriter.this.mFile.getFilePointer();
                this.deflater = new DeflaterOutputStream(new DataOutputOutputStream(MatFileWriter.this.mFile));
                this.dataDefOut = new DataOutputStream(this.deflater);
                return this.dataDefOut;
            }

            public void close() throws IOException {
                this.dataDefOut.flush();
                this.deflater.finish();
                long posEnd = MatFileWriter.this.mFile.getFilePointer();
                MatFileWriter.this.mFile.seek(this.posSize);
                MatFileWriter.this.mFile.writeInt((int)(posEnd - this.posStart));
                MatFileWriter.this.mFile.seek(posEnd);
                this.dataDefOut = null;
                this.deflater = null;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.checkNoReservedWriter();
        this.mFile.close();
    }
}

