/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase.marshal;

import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.jbase.marshal.BigIntegerMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalMarshaller
implements EntityMarshaller<BigDecimal> {
    private final BigIntegerMarshaller bip = new BigIntegerMarshaller();

    @Override
    public void writeTo(BigDecimal entity, DataOutput out) throws IOException {
        out.writeInt(entity.scale());
        this.bip.writeTo(entity.unscaledValue(), out);
    }

    @Override
    public BigDecimal readFrom(DataInput in) throws IOException {
        int scale = in.readInt();
        BigInteger bi = this.bip.readFrom(in);
        if (bi.bitLength() <= 63) {
            return BigDecimal.valueOf(bi.longValue(), scale);
        }
        return new BigDecimal(bi, scale);
    }
}

