# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._time_series_insights_client_enums import *


class AccessPolicyCreateOrUpdateParameters(msrest.serialization.Model):
    """AccessPolicyCreateOrUpdateParameters.

    :param principal_object_id: The objectId of the principal in Azure Active Directory.
    :type principal_object_id: str
    :param description: An description of the access policy.
    :type description: str
    :param roles: The list of roles the principal is assigned on the environment.
    :type roles: list[str or ~azure.mgmt.timeseriesinsights.models.AccessPolicyRole]
    """

    _attribute_map = {
        'principal_object_id': {'key': 'properties.principalObjectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        principal_object_id: Optional[str] = None,
        description: Optional[str] = None,
        roles: Optional[List[Union[str, "AccessPolicyRole"]]] = None,
        **kwargs
    ):
        super(AccessPolicyCreateOrUpdateParameters, self).__init__(**kwargs)
        self.principal_object_id = principal_object_id
        self.description = description
        self.roles = roles


class AccessPolicyListResponse(msrest.serialization.Model):
    """The response of the List access policies operation.

    :param value: Result of the List access policies operation.
    :type value: list[~azure.mgmt.timeseriesinsights.models.AccessPolicyResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AccessPolicyResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AccessPolicyResource"]] = None,
        **kwargs
    ):
        super(AccessPolicyListResponse, self).__init__(**kwargs)
        self.value = value


class Resource(msrest.serialization.Model):
    """Time Series Insights resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AccessPolicyResource(Resource):
    """An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data plane APIs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param principal_object_id: The objectId of the principal in Azure Active Directory.
    :type principal_object_id: str
    :param description: An description of the access policy.
    :type description: str
    :param roles: The list of roles the principal is assigned on the environment.
    :type roles: list[str or ~azure.mgmt.timeseriesinsights.models.AccessPolicyRole]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'principal_object_id': {'key': 'properties.principalObjectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        principal_object_id: Optional[str] = None,
        description: Optional[str] = None,
        roles: Optional[List[Union[str, "AccessPolicyRole"]]] = None,
        **kwargs
    ):
        super(AccessPolicyResource, self).__init__(**kwargs)
        self.principal_object_id = principal_object_id
        self.description = description
        self.roles = roles


class AccessPolicyUpdateParameters(msrest.serialization.Model):
    """AccessPolicyUpdateParameters.

    :param description: An description of the access policy.
    :type description: str
    :param roles: The list of roles the principal is assigned on the environment.
    :type roles: list[str or ~azure.mgmt.timeseriesinsights.models.AccessPolicyRole]
    """

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        roles: Optional[List[Union[str, "AccessPolicyRole"]]] = None,
        **kwargs
    ):
        super(AccessPolicyUpdateParameters, self).__init__(**kwargs)
        self.description = description
        self.roles = roles


class ResourceProperties(msrest.serialization.Model):
    """Properties that are common to all tracked resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.creation_time = None


class EventSourceCommonProperties(ResourceProperties):
    """Properties of the event source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(EventSourceCommonProperties, self).__init__(**kwargs)
        self.timestamp_property_name = timestamp_property_name


class AzureEventSourceProperties(EventSourceCommonProperties):
    """Properties of an event source that reads events from an event broker in Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'eventSourceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_source_resource_id: str,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(AzureEventSourceProperties, self).__init__(timestamp_property_name=timestamp_property_name, **kwargs)
        self.event_source_resource_id = event_source_resource_id


class CloudErrorBody(msrest.serialization.Model):
    """Describes a particular API error with an error code and a message.

    :param code: An error code that describes the error condition more precisely than an HTTP
     status code. Can be used to programmatically handle specific error cases.
    :type code: str
    :param message: A message that describes the error in detail and provides debugging
     information.
    :type message: str
    :param target: The target of the particular error (for example, the name of the property in
     error).
    :type target: str
    :param details: Contains nested errors that are related to this error.
    :type details: list[~azure.mgmt.timeseriesinsights.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CreateOrUpdateTrackedResourceProperties(msrest.serialization.Model):
    """Properties required to create any resource tracked by Azure Resource Manager.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional properties for the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(CreateOrUpdateTrackedResourceProperties, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class EnvironmentCreateOrUpdateParameters(CreateOrUpdateTrackedResourceProperties):
    """Parameters supplied to the CreateOrUpdate Environment operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Gen1EnvironmentCreateOrUpdateParameters, Gen2EnvironmentCreateOrUpdateParameters.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional properties for the resource.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the environment.Constant filled by server.  Possible values
     include: "Gen1", "Gen2".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EnvironmentKind
    :param sku: Required. The sku determines the type of environment, either Gen1 (S1 or S2) or
     Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the
     ingress rate, and the billing rate.
    :type sku: ~azure.mgmt.timeseriesinsights.models.Sku
    """

    _validation = {
        'location': {'required': True},
        'kind': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    _subtype_map = {
        'kind': {'Gen1': 'Gen1EnvironmentCreateOrUpdateParameters', 'Gen2': 'Gen2EnvironmentCreateOrUpdateParameters'}
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(EnvironmentCreateOrUpdateParameters, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = 'EnvironmentCreateOrUpdateParameters'  # type: str
        self.sku = sku


class EnvironmentListResponse(msrest.serialization.Model):
    """The response of the List Environments operation.

    :param value: Result of the List Environments operation.
    :type value: list[~azure.mgmt.timeseriesinsights.models.EnvironmentResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EnvironmentResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EnvironmentResource"]] = None,
        **kwargs
    ):
        super(EnvironmentListResponse, self).__init__(**kwargs)
        self.value = value


class TrackedResource(Resource):
    """Time Series Insights resource that is tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class EnvironmentResource(TrackedResource):
    """An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Gen1EnvironmentResource, Gen2EnvironmentResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. The sku determines the type of environment, either Gen1 (S1 or S2) or
     Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the
     ingress rate, and the billing rate.
    :type sku: ~azure.mgmt.timeseriesinsights.models.Sku
    :param kind: Required. The kind of the environment.Constant filled by server.  Possible values
     include: "Gen1", "Gen2".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EnvironmentResourceKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Gen1': 'Gen1EnvironmentResource', 'Gen2': 'Gen2EnvironmentResource'}
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(EnvironmentResource, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.kind = 'EnvironmentResource'  # type: str


class EnvironmentResourceProperties(ResourceProperties):
    """Properties of the environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :ivar data_access_id: An id used to access the environment data, e.g. to query the
     environment's events or upload reference data for the environment.
    :vartype data_access_id: str
    :ivar data_access_fqdn: The fully qualified domain name used to access the environment data,
     e.g. to query the environment's events or upload reference data for the environment.
    :vartype data_access_fqdn: str
    :ivar status: An object that represents the status of the environment, and its internal state
     in the Time Series Insights service.
    :vartype status: ~azure.mgmt.timeseriesinsights.models.EnvironmentStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'data_access_id': {'readonly': True},
        'data_access_fqdn': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'data_access_id': {'key': 'dataAccessId', 'type': 'str'},
        'data_access_fqdn': {'key': 'dataAccessFqdn', 'type': 'str'},
        'status': {'key': 'status', 'type': 'EnvironmentStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentResourceProperties, self).__init__(**kwargs)
        self.data_access_id = None
        self.data_access_fqdn = None
        self.status = None


class EnvironmentStateDetails(msrest.serialization.Model):
    """An object that contains the details about an environment's state.

    :param code: Contains the code that represents the reason of an environment being in a
     particular state. Can be used to programmatically handle specific cases.
    :type code: str
    :param message: A message that describes the state in detail.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(EnvironmentStateDetails, self).__init__(**kwargs)
        self.code = code
        self.message = message


class EnvironmentStatus(msrest.serialization.Model):
    """An object that represents the status of the environment, and its internal state in the Time Series Insights service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ingress: An object that represents the status of ingress on an environment.
    :vartype ingress: ~azure.mgmt.timeseriesinsights.models.IngressEnvironmentStatus
    :ivar warm_storage: An object that represents the status of warm storage on an environment.
    :vartype warm_storage: ~azure.mgmt.timeseriesinsights.models.WarmStorageEnvironmentStatus
    """

    _validation = {
        'ingress': {'readonly': True},
        'warm_storage': {'readonly': True},
    }

    _attribute_map = {
        'ingress': {'key': 'ingress', 'type': 'IngressEnvironmentStatus'},
        'warm_storage': {'key': 'warmStorage', 'type': 'WarmStorageEnvironmentStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentStatus, self).__init__(**kwargs)
        self.ingress = None
        self.warm_storage = None


class EnvironmentUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Update Environment operation.

    :param tags: A set of tags. Key-value pairs of additional properties for the environment.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(EnvironmentUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class EventHubEventSourceCommonProperties(AzureEventSourceProperties):
    """Properties of the EventHub event source.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param service_bus_namespace: Required. The name of the service bus that contains the event
     hub.
    :type service_bus_namespace: str
    :param event_hub_name: Required. The name of the event hub.
    :type event_hub_name: str
    :param consumer_group_name: Required. The name of the event hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the SAS key that grants the Time Series Insights service
     access to the event hub. The shared access policies for this key must grant 'Listen'
     permissions to the event hub.
    :type key_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'service_bus_namespace': {'required': True},
        'event_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'eventSourceResourceId', 'type': 'str'},
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'event_hub_name': {'key': 'eventHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_source_resource_id: str,
        service_bus_namespace: str,
        event_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubEventSourceCommonProperties, self).__init__(timestamp_property_name=timestamp_property_name, event_source_resource_id=event_source_resource_id, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.event_hub_name = event_hub_name
        self.consumer_group_name = consumer_group_name
        self.key_name = key_name


class EventSourceCreateOrUpdateParameters(CreateOrUpdateTrackedResourceProperties):
    """Parameters supplied to the Create or Update Event Source operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EventHubEventSourceCreateOrUpdateParameters, IoTHubEventSourceCreateOrUpdateParameters.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional properties for the resource.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the event source.Constant filled by server.  Possible values
     include: "Microsoft.EventHub", "Microsoft.IoTHub".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EventSourceKind
    :param local_timestamp: An object that represents the local timestamp property. It contains the
     format of local timestamp that needs to be used and the corresponding timezone offset
     information. If a value isn't specified for localTimestamp, or if null, then the local
     timestamp will not be ingressed with the events.
    :type local_timestamp: ~azure.mgmt.timeseriesinsights.models.LocalTimestamp
    """

    _validation = {
        'location': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'local_timestamp': {'key': 'localTimestamp', 'type': 'LocalTimestamp'},
    }

    _subtype_map = {
        'kind': {'Microsoft.EventHub': 'EventHubEventSourceCreateOrUpdateParameters', 'Microsoft.IoTHub': 'IoTHubEventSourceCreateOrUpdateParameters'}
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        local_timestamp: Optional["LocalTimestamp"] = None,
        **kwargs
    ):
        super(EventSourceCreateOrUpdateParameters, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = 'EventSourceCreateOrUpdateParameters'  # type: str
        self.local_timestamp = local_timestamp


class EventHubEventSourceCreateOrUpdateParameters(EventSourceCreateOrUpdateParameters):
    """Parameters supplied to the Create or Update Event Source operation for an EventHub event source.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional properties for the resource.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the event source.Constant filled by server.  Possible values
     include: "Microsoft.EventHub", "Microsoft.IoTHub".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EventSourceKind
    :param local_timestamp: An object that represents the local timestamp property. It contains the
     format of local timestamp that needs to be used and the corresponding timezone offset
     information. If a value isn't specified for localTimestamp, or if null, then the local
     timestamp will not be ingressed with the events.
    :type local_timestamp: ~azure.mgmt.timeseriesinsights.models.LocalTimestamp
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param service_bus_namespace: Required. The name of the service bus that contains the event
     hub.
    :type service_bus_namespace: str
    :param event_hub_name: Required. The name of the event hub.
    :type event_hub_name: str
    :param consumer_group_name: Required. The name of the event hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the SAS key that grants the Time Series Insights service
     access to the event hub. The shared access policies for this key must grant 'Listen'
     permissions to the event hub.
    :type key_name: str
    :param shared_access_key: Required. The value of the shared access key that grants the Time
     Series Insights service read access to the event hub. This property is not shown in event
     source responses.
    :type shared_access_key: str
    """

    _validation = {
        'location': {'required': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'service_bus_namespace': {'required': True},
        'event_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
        'shared_access_key': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'local_timestamp': {'key': 'localTimestamp', 'type': 'LocalTimestamp'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'properties.timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'properties.eventSourceResourceId', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'properties.consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'properties.keyName', 'type': 'str'},
        'shared_access_key': {'key': 'properties.sharedAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        event_source_resource_id: str,
        service_bus_namespace: str,
        event_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        shared_access_key: str,
        tags: Optional[Dict[str, str]] = None,
        local_timestamp: Optional["LocalTimestamp"] = None,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubEventSourceCreateOrUpdateParameters, self).__init__(location=location, tags=tags, local_timestamp=local_timestamp, **kwargs)
        self.kind = 'Microsoft.EventHub'  # type: str
        self.provisioning_state = None
        self.creation_time = None
        self.timestamp_property_name = timestamp_property_name
        self.event_source_resource_id = event_source_resource_id
        self.service_bus_namespace = service_bus_namespace
        self.event_hub_name = event_hub_name
        self.consumer_group_name = consumer_group_name
        self.key_name = key_name
        self.shared_access_key = shared_access_key


class EventHubEventSourceCreationProperties(EventHubEventSourceCommonProperties):
    """Properties of the EventHub event source that are required on create or update requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param service_bus_namespace: Required. The name of the service bus that contains the event
     hub.
    :type service_bus_namespace: str
    :param event_hub_name: Required. The name of the event hub.
    :type event_hub_name: str
    :param consumer_group_name: Required. The name of the event hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the SAS key that grants the Time Series Insights service
     access to the event hub. The shared access policies for this key must grant 'Listen'
     permissions to the event hub.
    :type key_name: str
    :param shared_access_key: Required. The value of the shared access key that grants the Time
     Series Insights service read access to the event hub. This property is not shown in event
     source responses.
    :type shared_access_key: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'service_bus_namespace': {'required': True},
        'event_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
        'shared_access_key': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'eventSourceResourceId', 'type': 'str'},
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'event_hub_name': {'key': 'eventHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'shared_access_key': {'key': 'sharedAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_source_resource_id: str,
        service_bus_namespace: str,
        event_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        shared_access_key: str,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubEventSourceCreationProperties, self).__init__(timestamp_property_name=timestamp_property_name, event_source_resource_id=event_source_resource_id, service_bus_namespace=service_bus_namespace, event_hub_name=event_hub_name, consumer_group_name=consumer_group_name, key_name=key_name, **kwargs)
        self.shared_access_key = shared_access_key


class EventSourceMutableProperties(msrest.serialization.Model):
    """An object that represents a set of mutable event source resource properties.

    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param local_timestamp: An object that represents the local timestamp property. It contains the
     format of local timestamp that needs to be used and the corresponding timezone offset
     information. If a value isn't specified for localTimestamp, or if null, then the local
     timestamp will not be ingressed with the events.
    :type local_timestamp: ~azure.mgmt.timeseriesinsights.models.LocalTimestamp
    """

    _attribute_map = {
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'local_timestamp': {'key': 'localTimestamp', 'type': 'LocalTimestamp'},
    }

    def __init__(
        self,
        *,
        timestamp_property_name: Optional[str] = None,
        local_timestamp: Optional["LocalTimestamp"] = None,
        **kwargs
    ):
        super(EventSourceMutableProperties, self).__init__(**kwargs)
        self.timestamp_property_name = timestamp_property_name
        self.local_timestamp = local_timestamp


class EventHubEventSourceMutableProperties(EventSourceMutableProperties):
    """An object that represents a set of mutable EventHub event source resource properties.

    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param local_timestamp: An object that represents the local timestamp property. It contains the
     format of local timestamp that needs to be used and the corresponding timezone offset
     information. If a value isn't specified for localTimestamp, or if null, then the local
     timestamp will not be ingressed with the events.
    :type local_timestamp: ~azure.mgmt.timeseriesinsights.models.LocalTimestamp
    :param shared_access_key: The value of the shared access key that grants the Time Series
     Insights service read access to the event hub. This property is not shown in event source
     responses.
    :type shared_access_key: str
    """

    _attribute_map = {
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'local_timestamp': {'key': 'localTimestamp', 'type': 'LocalTimestamp'},
        'shared_access_key': {'key': 'sharedAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp_property_name: Optional[str] = None,
        local_timestamp: Optional["LocalTimestamp"] = None,
        shared_access_key: Optional[str] = None,
        **kwargs
    ):
        super(EventHubEventSourceMutableProperties, self).__init__(timestamp_property_name=timestamp_property_name, local_timestamp=local_timestamp, **kwargs)
        self.shared_access_key = shared_access_key


class EventSourceResource(TrackedResource):
    """An environment receives data from one or more event sources. Each event source has associated connection info that allows the Time Series Insights ingress pipeline to connect to and pull data from the event source.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EventHubEventSourceResource, IoTHubEventSourceResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the event source.Constant filled by server.  Possible values
     include: "Microsoft.EventHub", "Microsoft.IoTHub".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EventSourceResourceKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Microsoft.EventHub': 'EventHubEventSourceResource', 'Microsoft.IoTHub': 'IoTHubEventSourceResource'}
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(EventSourceResource, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = 'EventSourceResource'  # type: str


class EventHubEventSourceResource(EventSourceResource):
    """An event source that receives its data from an Azure EventHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the event source.Constant filled by server.  Possible values
     include: "Microsoft.EventHub", "Microsoft.IoTHub".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EventSourceResourceKind
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param service_bus_namespace: Required. The name of the service bus that contains the event
     hub.
    :type service_bus_namespace: str
    :param event_hub_name: Required. The name of the event hub.
    :type event_hub_name: str
    :param consumer_group_name: Required. The name of the event hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the SAS key that grants the Time Series Insights service
     access to the event hub. The shared access policies for this key must grant 'Listen'
     permissions to the event hub.
    :type key_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'service_bus_namespace': {'required': True},
        'event_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'properties.timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'properties.eventSourceResourceId', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'properties.consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'properties.keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        event_source_resource_id: str,
        service_bus_namespace: str,
        event_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        tags: Optional[Dict[str, str]] = None,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubEventSourceResource, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = 'Microsoft.EventHub'  # type: str
        self.provisioning_state = None
        self.creation_time = None
        self.timestamp_property_name = timestamp_property_name
        self.event_source_resource_id = event_source_resource_id
        self.service_bus_namespace = service_bus_namespace
        self.event_hub_name = event_hub_name
        self.consumer_group_name = consumer_group_name
        self.key_name = key_name


class EventHubEventSourceResourceProperties(EventHubEventSourceCommonProperties):
    """Properties of the EventHub event source resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param service_bus_namespace: Required. The name of the service bus that contains the event
     hub.
    :type service_bus_namespace: str
    :param event_hub_name: Required. The name of the event hub.
    :type event_hub_name: str
    :param consumer_group_name: Required. The name of the event hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the SAS key that grants the Time Series Insights service
     access to the event hub. The shared access policies for this key must grant 'Listen'
     permissions to the event hub.
    :type key_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'service_bus_namespace': {'required': True},
        'event_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'eventSourceResourceId', 'type': 'str'},
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'event_hub_name': {'key': 'eventHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_source_resource_id: str,
        service_bus_namespace: str,
        event_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubEventSourceResourceProperties, self).__init__(timestamp_property_name=timestamp_property_name, event_source_resource_id=event_source_resource_id, service_bus_namespace=service_bus_namespace, event_hub_name=event_hub_name, consumer_group_name=consumer_group_name, key_name=key_name, **kwargs)


class EventSourceUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Update Event Source operation.

    :param tags: A set of tags. Key-value pairs of additional properties for the event source.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(EventSourceUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class EventHubEventSourceUpdateParameters(EventSourceUpdateParameters):
    """Parameters supplied to the Update Event Source operation to update an EventHub event source.

    :param tags: A set of tags. Key-value pairs of additional properties for the event source.
    :type tags: dict[str, str]
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param local_timestamp: An object that represents the local timestamp property. It contains the
     format of local timestamp that needs to be used and the corresponding timezone offset
     information. If a value isn't specified for localTimestamp, or if null, then the local
     timestamp will not be ingressed with the events.
    :type local_timestamp: ~azure.mgmt.timeseriesinsights.models.LocalTimestamp
    :param shared_access_key: The value of the shared access key that grants the Time Series
     Insights service read access to the event hub. This property is not shown in event source
     responses.
    :type shared_access_key: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'timestamp_property_name': {'key': 'properties.timestampPropertyName', 'type': 'str'},
        'local_timestamp': {'key': 'properties.localTimestamp', 'type': 'LocalTimestamp'},
        'shared_access_key': {'key': 'properties.sharedAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        timestamp_property_name: Optional[str] = None,
        local_timestamp: Optional["LocalTimestamp"] = None,
        shared_access_key: Optional[str] = None,
        **kwargs
    ):
        super(EventHubEventSourceUpdateParameters, self).__init__(tags=tags, **kwargs)
        self.timestamp_property_name = timestamp_property_name
        self.local_timestamp = local_timestamp
        self.shared_access_key = shared_access_key


class EventSourceListResponse(msrest.serialization.Model):
    """The response of the List EventSources operation.

    :param value: Result of the List EventSources operation.
    :type value: list[~azure.mgmt.timeseriesinsights.models.EventSourceResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventSourceResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventSourceResource"]] = None,
        **kwargs
    ):
        super(EventSourceListResponse, self).__init__(**kwargs)
        self.value = value


class Gen1EnvironmentCreateOrUpdateParameters(EnvironmentCreateOrUpdateParameters):
    """Parameters supplied to the Create or Update Environment operation for a Gen1 environment.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional properties for the resource.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the environment.Constant filled by server.  Possible values
     include: "Gen1", "Gen2".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EnvironmentKind
    :param sku: Required. The sku determines the type of environment, either Gen1 (S1 or S2) or
     Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the
     ingress rate, and the billing rate.
    :type sku: ~azure.mgmt.timeseriesinsights.models.Sku
    :param data_retention_time: Required. ISO8601 timespan specifying the minimum number of days
     the environment's events will be available for query.
    :type data_retention_time: ~datetime.timedelta
    :param storage_limit_exceeded_behavior: The behavior the Time Series Insights service should
     take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new
     events will not be read from the event source. If "PurgeOldData" is specified, new events will
     continue to be read and old events will be deleted from the environment. The default behavior
     is PurgeOldData. Possible values include: "PurgeOldData", "PauseIngress".
    :type storage_limit_exceeded_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.StorageLimitExceededBehavior
    :param partition_key_properties: The list of event properties which will be used to partition
     data in the environment. Currently, only a single partition key property is supported.
    :type partition_key_properties:
     list[~azure.mgmt.timeseriesinsights.models.TimeSeriesIdProperty]
    """

    _validation = {
        'location': {'required': True},
        'kind': {'required': True},
        'sku': {'required': True},
        'data_retention_time': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'data_retention_time': {'key': 'properties.dataRetentionTime', 'type': 'duration'},
        'storage_limit_exceeded_behavior': {'key': 'properties.storageLimitExceededBehavior', 'type': 'str'},
        'partition_key_properties': {'key': 'properties.partitionKeyProperties', 'type': '[TimeSeriesIdProperty]'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        data_retention_time: datetime.timedelta,
        tags: Optional[Dict[str, str]] = None,
        storage_limit_exceeded_behavior: Optional[Union[str, "StorageLimitExceededBehavior"]] = None,
        partition_key_properties: Optional[List["TimeSeriesIdProperty"]] = None,
        **kwargs
    ):
        super(Gen1EnvironmentCreateOrUpdateParameters, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.kind = 'Gen1'  # type: str
        self.data_retention_time = data_retention_time
        self.storage_limit_exceeded_behavior = storage_limit_exceeded_behavior
        self.partition_key_properties = partition_key_properties


class Gen1EnvironmentCreationProperties(msrest.serialization.Model):
    """Properties used to create a Gen1 environment.

    All required parameters must be populated in order to send to Azure.

    :param data_retention_time: Required. ISO8601 timespan specifying the minimum number of days
     the environment's events will be available for query.
    :type data_retention_time: ~datetime.timedelta
    :param storage_limit_exceeded_behavior: The behavior the Time Series Insights service should
     take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new
     events will not be read from the event source. If "PurgeOldData" is specified, new events will
     continue to be read and old events will be deleted from the environment. The default behavior
     is PurgeOldData. Possible values include: "PurgeOldData", "PauseIngress".
    :type storage_limit_exceeded_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.StorageLimitExceededBehavior
    :param partition_key_properties: The list of event properties which will be used to partition
     data in the environment. Currently, only a single partition key property is supported.
    :type partition_key_properties:
     list[~azure.mgmt.timeseriesinsights.models.TimeSeriesIdProperty]
    """

    _validation = {
        'data_retention_time': {'required': True},
    }

    _attribute_map = {
        'data_retention_time': {'key': 'dataRetentionTime', 'type': 'duration'},
        'storage_limit_exceeded_behavior': {'key': 'storageLimitExceededBehavior', 'type': 'str'},
        'partition_key_properties': {'key': 'partitionKeyProperties', 'type': '[TimeSeriesIdProperty]'},
    }

    def __init__(
        self,
        *,
        data_retention_time: datetime.timedelta,
        storage_limit_exceeded_behavior: Optional[Union[str, "StorageLimitExceededBehavior"]] = None,
        partition_key_properties: Optional[List["TimeSeriesIdProperty"]] = None,
        **kwargs
    ):
        super(Gen1EnvironmentCreationProperties, self).__init__(**kwargs)
        self.data_retention_time = data_retention_time
        self.storage_limit_exceeded_behavior = storage_limit_exceeded_behavior
        self.partition_key_properties = partition_key_properties


class Gen1EnvironmentResource(EnvironmentResource):
    """An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen1 environments have data retention limits.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. The sku determines the type of environment, either Gen1 (S1 or S2) or
     Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the
     ingress rate, and the billing rate.
    :type sku: ~azure.mgmt.timeseriesinsights.models.Sku
    :param kind: Required. The kind of the environment.Constant filled by server.  Possible values
     include: "Gen1", "Gen2".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EnvironmentResourceKind
    :param data_retention_time: Required. ISO8601 timespan specifying the minimum number of days
     the environment's events will be available for query.
    :type data_retention_time: ~datetime.timedelta
    :param storage_limit_exceeded_behavior: The behavior the Time Series Insights service should
     take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new
     events will not be read from the event source. If "PurgeOldData" is specified, new events will
     continue to be read and old events will be deleted from the environment. The default behavior
     is PurgeOldData. Possible values include: "PurgeOldData", "PauseIngress".
    :type storage_limit_exceeded_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.StorageLimitExceededBehavior
    :param partition_key_properties: The list of event properties which will be used to partition
     data in the environment. Currently, only a single partition key property is supported.
    :type partition_key_properties:
     list[~azure.mgmt.timeseriesinsights.models.TimeSeriesIdProperty]
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :ivar data_access_id: An id used to access the environment data, e.g. to query the
     environment's events or upload reference data for the environment.
    :vartype data_access_id: str
    :ivar data_access_fqdn: The fully qualified domain name used to access the environment data,
     e.g. to query the environment's events or upload reference data for the environment.
    :vartype data_access_fqdn: str
    :ivar status: An object that represents the status of the environment, and its internal state
     in the Time Series Insights service.
    :vartype status: ~azure.mgmt.timeseriesinsights.models.EnvironmentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'kind': {'required': True},
        'data_retention_time': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'data_access_id': {'readonly': True},
        'data_access_fqdn': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_retention_time': {'key': 'properties.dataRetentionTime', 'type': 'duration'},
        'storage_limit_exceeded_behavior': {'key': 'properties.storageLimitExceededBehavior', 'type': 'str'},
        'partition_key_properties': {'key': 'properties.partitionKeyProperties', 'type': '[TimeSeriesIdProperty]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'data_access_id': {'key': 'properties.dataAccessId', 'type': 'str'},
        'data_access_fqdn': {'key': 'properties.dataAccessFqdn', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'EnvironmentStatus'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        data_retention_time: datetime.timedelta,
        tags: Optional[Dict[str, str]] = None,
        storage_limit_exceeded_behavior: Optional[Union[str, "StorageLimitExceededBehavior"]] = None,
        partition_key_properties: Optional[List["TimeSeriesIdProperty"]] = None,
        **kwargs
    ):
        super(Gen1EnvironmentResource, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.kind = 'Gen1'  # type: str
        self.data_retention_time = data_retention_time
        self.storage_limit_exceeded_behavior = storage_limit_exceeded_behavior
        self.partition_key_properties = partition_key_properties
        self.provisioning_state = None
        self.creation_time = None
        self.data_access_id = None
        self.data_access_fqdn = None
        self.status = None


class Gen1EnvironmentResourceProperties(Gen1EnvironmentCreationProperties, EnvironmentResourceProperties):
    """Properties of the Gen1 environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :ivar data_access_id: An id used to access the environment data, e.g. to query the
     environment's events or upload reference data for the environment.
    :vartype data_access_id: str
    :ivar data_access_fqdn: The fully qualified domain name used to access the environment data,
     e.g. to query the environment's events or upload reference data for the environment.
    :vartype data_access_fqdn: str
    :ivar status: An object that represents the status of the environment, and its internal state
     in the Time Series Insights service.
    :vartype status: ~azure.mgmt.timeseriesinsights.models.EnvironmentStatus
    :param data_retention_time: Required. ISO8601 timespan specifying the minimum number of days
     the environment's events will be available for query.
    :type data_retention_time: ~datetime.timedelta
    :param storage_limit_exceeded_behavior: The behavior the Time Series Insights service should
     take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new
     events will not be read from the event source. If "PurgeOldData" is specified, new events will
     continue to be read and old events will be deleted from the environment. The default behavior
     is PurgeOldData. Possible values include: "PurgeOldData", "PauseIngress".
    :type storage_limit_exceeded_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.StorageLimitExceededBehavior
    :param partition_key_properties: The list of event properties which will be used to partition
     data in the environment. Currently, only a single partition key property is supported.
    :type partition_key_properties:
     list[~azure.mgmt.timeseriesinsights.models.TimeSeriesIdProperty]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'data_access_id': {'readonly': True},
        'data_access_fqdn': {'readonly': True},
        'status': {'readonly': True},
        'data_retention_time': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'data_access_id': {'key': 'dataAccessId', 'type': 'str'},
        'data_access_fqdn': {'key': 'dataAccessFqdn', 'type': 'str'},
        'status': {'key': 'status', 'type': 'EnvironmentStatus'},
        'data_retention_time': {'key': 'dataRetentionTime', 'type': 'duration'},
        'storage_limit_exceeded_behavior': {'key': 'storageLimitExceededBehavior', 'type': 'str'},
        'partition_key_properties': {'key': 'partitionKeyProperties', 'type': '[TimeSeriesIdProperty]'},
    }

    def __init__(
        self,
        *,
        data_retention_time: datetime.timedelta,
        storage_limit_exceeded_behavior: Optional[Union[str, "StorageLimitExceededBehavior"]] = None,
        partition_key_properties: Optional[List["TimeSeriesIdProperty"]] = None,
        **kwargs
    ):
        super(Gen1EnvironmentResourceProperties, self).__init__(data_retention_time=data_retention_time, storage_limit_exceeded_behavior=storage_limit_exceeded_behavior, partition_key_properties=partition_key_properties, **kwargs)
        self.provisioning_state = None
        self.creation_time = None
        self.data_access_id = None
        self.data_access_fqdn = None
        self.status = None
        self.data_retention_time = data_retention_time
        self.storage_limit_exceeded_behavior = storage_limit_exceeded_behavior
        self.partition_key_properties = partition_key_properties


class Gen1EnvironmentUpdateParameters(EnvironmentUpdateParameters):
    """Parameters supplied to the Update Environment operation to update a Gen1 environment.

    :param tags: A set of tags. Key-value pairs of additional properties for the environment.
    :type tags: dict[str, str]
    :param sku: The sku of the environment.
    :type sku: ~azure.mgmt.timeseriesinsights.models.Sku
    :param data_retention_time: ISO8601 timespan specifying the minimum number of days the
     environment's events will be available for query.
    :type data_retention_time: ~datetime.timedelta
    :param storage_limit_exceeded_behavior: The behavior the Time Series Insights service should
     take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new
     events will not be read from the event source. If "PurgeOldData" is specified, new events will
     continue to be read and old events will be deleted from the environment. The default behavior
     is PurgeOldData. Possible values include: "PurgeOldData", "PauseIngress".
    :type storage_limit_exceeded_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.StorageLimitExceededBehavior
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'data_retention_time': {'key': 'properties.dataRetentionTime', 'type': 'duration'},
        'storage_limit_exceeded_behavior': {'key': 'properties.storageLimitExceededBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        data_retention_time: Optional[datetime.timedelta] = None,
        storage_limit_exceeded_behavior: Optional[Union[str, "StorageLimitExceededBehavior"]] = None,
        **kwargs
    ):
        super(Gen1EnvironmentUpdateParameters, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.data_retention_time = data_retention_time
        self.storage_limit_exceeded_behavior = storage_limit_exceeded_behavior


class Gen2EnvironmentCreateOrUpdateParameters(EnvironmentCreateOrUpdateParameters):
    """Parameters supplied to the Create or Update Environment operation for a Gen2 environment.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional properties for the resource.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the environment.Constant filled by server.  Possible values
     include: "Gen1", "Gen2".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EnvironmentKind
    :param sku: Required. The sku determines the type of environment, either Gen1 (S1 or S2) or
     Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the
     ingress rate, and the billing rate.
    :type sku: ~azure.mgmt.timeseriesinsights.models.Sku
    :param time_series_id_properties: Required. The list of event properties which will be used to
     define the environment's time series id.
    :type time_series_id_properties:
     list[~azure.mgmt.timeseriesinsights.models.TimeSeriesIdProperty]
    :param storage_configuration: Required. The storage configuration provides the connection
     details that allows the Time Series Insights service to connect to the customer storage account
     that is used to store the environment's data.
    :type storage_configuration:
     ~azure.mgmt.timeseriesinsights.models.Gen2StorageConfigurationInput
    :param warm_store_configuration: The warm store configuration provides the details to create a
     warm store cache that will retain a copy of the environment's data available for faster query.
    :type warm_store_configuration:
     ~azure.mgmt.timeseriesinsights.models.WarmStoreConfigurationProperties
    """

    _validation = {
        'location': {'required': True},
        'kind': {'required': True},
        'sku': {'required': True},
        'time_series_id_properties': {'required': True},
        'storage_configuration': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'time_series_id_properties': {'key': 'properties.timeSeriesIdProperties', 'type': '[TimeSeriesIdProperty]'},
        'storage_configuration': {'key': 'properties.storageConfiguration', 'type': 'Gen2StorageConfigurationInput'},
        'warm_store_configuration': {'key': 'properties.warmStoreConfiguration', 'type': 'WarmStoreConfigurationProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        time_series_id_properties: List["TimeSeriesIdProperty"],
        storage_configuration: "Gen2StorageConfigurationInput",
        tags: Optional[Dict[str, str]] = None,
        warm_store_configuration: Optional["WarmStoreConfigurationProperties"] = None,
        **kwargs
    ):
        super(Gen2EnvironmentCreateOrUpdateParameters, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.kind = 'Gen2'  # type: str
        self.time_series_id_properties = time_series_id_properties
        self.storage_configuration = storage_configuration
        self.warm_store_configuration = warm_store_configuration


class Gen2EnvironmentResource(EnvironmentResource):
    """An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen2 environments do not have set data retention limits.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. The sku determines the type of environment, either Gen1 (S1 or S2) or
     Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the
     ingress rate, and the billing rate.
    :type sku: ~azure.mgmt.timeseriesinsights.models.Sku
    :param kind: Required. The kind of the environment.Constant filled by server.  Possible values
     include: "Gen1", "Gen2".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EnvironmentResourceKind
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :ivar data_access_id: An id used to access the environment data, e.g. to query the
     environment's events or upload reference data for the environment.
    :vartype data_access_id: str
    :ivar data_access_fqdn: The fully qualified domain name used to access the environment data,
     e.g. to query the environment's events or upload reference data for the environment.
    :vartype data_access_fqdn: str
    :ivar status: An object that represents the status of the environment, and its internal state
     in the Time Series Insights service.
    :vartype status: ~azure.mgmt.timeseriesinsights.models.EnvironmentStatus
    :param time_series_id_properties: Required. The list of event properties which will be used to
     define the environment's time series id.
    :type time_series_id_properties:
     list[~azure.mgmt.timeseriesinsights.models.TimeSeriesIdProperty]
    :param storage_configuration: Required. The storage configuration provides the connection
     details that allows the Time Series Insights service to connect to the customer storage account
     that is used to store the environment's data.
    :type storage_configuration:
     ~azure.mgmt.timeseriesinsights.models.Gen2StorageConfigurationOutput
    :param warm_store_configuration: The warm store configuration provides the details to create a
     warm store cache that will retain a copy of the environment's data available for faster query.
    :type warm_store_configuration:
     ~azure.mgmt.timeseriesinsights.models.WarmStoreConfigurationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'data_access_id': {'readonly': True},
        'data_access_fqdn': {'readonly': True},
        'status': {'readonly': True},
        'time_series_id_properties': {'required': True},
        'storage_configuration': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'data_access_id': {'key': 'properties.dataAccessId', 'type': 'str'},
        'data_access_fqdn': {'key': 'properties.dataAccessFqdn', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'EnvironmentStatus'},
        'time_series_id_properties': {'key': 'properties.timeSeriesIdProperties', 'type': '[TimeSeriesIdProperty]'},
        'storage_configuration': {'key': 'properties.storageConfiguration', 'type': 'Gen2StorageConfigurationOutput'},
        'warm_store_configuration': {'key': 'properties.warmStoreConfiguration', 'type': 'WarmStoreConfigurationProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        time_series_id_properties: List["TimeSeriesIdProperty"],
        storage_configuration: "Gen2StorageConfigurationOutput",
        tags: Optional[Dict[str, str]] = None,
        warm_store_configuration: Optional["WarmStoreConfigurationProperties"] = None,
        **kwargs
    ):
        super(Gen2EnvironmentResource, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.kind = 'Gen2'  # type: str
        self.provisioning_state = None
        self.creation_time = None
        self.data_access_id = None
        self.data_access_fqdn = None
        self.status = None
        self.time_series_id_properties = time_series_id_properties
        self.storage_configuration = storage_configuration
        self.warm_store_configuration = warm_store_configuration


class Gen2EnvironmentResourceProperties(EnvironmentResourceProperties):
    """Properties of the Gen2 environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :ivar data_access_id: An id used to access the environment data, e.g. to query the
     environment's events or upload reference data for the environment.
    :vartype data_access_id: str
    :ivar data_access_fqdn: The fully qualified domain name used to access the environment data,
     e.g. to query the environment's events or upload reference data for the environment.
    :vartype data_access_fqdn: str
    :ivar status: An object that represents the status of the environment, and its internal state
     in the Time Series Insights service.
    :vartype status: ~azure.mgmt.timeseriesinsights.models.EnvironmentStatus
    :param time_series_id_properties: Required. The list of event properties which will be used to
     define the environment's time series id.
    :type time_series_id_properties:
     list[~azure.mgmt.timeseriesinsights.models.TimeSeriesIdProperty]
    :param storage_configuration: Required. The storage configuration provides the connection
     details that allows the Time Series Insights service to connect to the customer storage account
     that is used to store the environment's data.
    :type storage_configuration:
     ~azure.mgmt.timeseriesinsights.models.Gen2StorageConfigurationOutput
    :param warm_store_configuration: The warm store configuration provides the details to create a
     warm store cache that will retain a copy of the environment's data available for faster query.
    :type warm_store_configuration:
     ~azure.mgmt.timeseriesinsights.models.WarmStoreConfigurationProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'data_access_id': {'readonly': True},
        'data_access_fqdn': {'readonly': True},
        'status': {'readonly': True},
        'time_series_id_properties': {'required': True},
        'storage_configuration': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'data_access_id': {'key': 'dataAccessId', 'type': 'str'},
        'data_access_fqdn': {'key': 'dataAccessFqdn', 'type': 'str'},
        'status': {'key': 'status', 'type': 'EnvironmentStatus'},
        'time_series_id_properties': {'key': 'timeSeriesIdProperties', 'type': '[TimeSeriesIdProperty]'},
        'storage_configuration': {'key': 'storageConfiguration', 'type': 'Gen2StorageConfigurationOutput'},
        'warm_store_configuration': {'key': 'warmStoreConfiguration', 'type': 'WarmStoreConfigurationProperties'},
    }

    def __init__(
        self,
        *,
        time_series_id_properties: List["TimeSeriesIdProperty"],
        storage_configuration: "Gen2StorageConfigurationOutput",
        warm_store_configuration: Optional["WarmStoreConfigurationProperties"] = None,
        **kwargs
    ):
        super(Gen2EnvironmentResourceProperties, self).__init__(**kwargs)
        self.time_series_id_properties = time_series_id_properties
        self.storage_configuration = storage_configuration
        self.warm_store_configuration = warm_store_configuration


class Gen2EnvironmentUpdateParameters(EnvironmentUpdateParameters):
    """Parameters supplied to the Update Environment operation to update a Gen2 environment.

    :param tags: A set of tags. Key-value pairs of additional properties for the environment.
    :type tags: dict[str, str]
    :param storage_configuration: The storage configuration provides the connection details that
     allows the Time Series Insights service to connect to the customer storage account that is used
     to store the environment's data.
    :type storage_configuration:
     ~azure.mgmt.timeseriesinsights.models.Gen2StorageConfigurationMutableProperties
    :param warm_store_configuration: The warm store configuration provides the details to create a
     warm store cache that will retain a copy of the environment's data available for faster query.
    :type warm_store_configuration:
     ~azure.mgmt.timeseriesinsights.models.WarmStoreConfigurationProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_configuration': {'key': 'properties.storageConfiguration', 'type': 'Gen2StorageConfigurationMutableProperties'},
        'warm_store_configuration': {'key': 'properties.warmStoreConfiguration', 'type': 'WarmStoreConfigurationProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        storage_configuration: Optional["Gen2StorageConfigurationMutableProperties"] = None,
        warm_store_configuration: Optional["WarmStoreConfigurationProperties"] = None,
        **kwargs
    ):
        super(Gen2EnvironmentUpdateParameters, self).__init__(tags=tags, **kwargs)
        self.storage_configuration = storage_configuration
        self.warm_store_configuration = warm_store_configuration


class Gen2StorageConfigurationInput(msrest.serialization.Model):
    """The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. The name of the storage account that will hold the environment's
     Gen2 data.
    :type account_name: str
    :param management_key: Required. The value of the management key that grants the Time Series
     Insights service write access to the storage account. This property is not shown in environment
     responses.
    :type management_key: str
    """

    _validation = {
        'account_name': {'required': True},
        'management_key': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'management_key': {'key': 'managementKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        management_key: str,
        **kwargs
    ):
        super(Gen2StorageConfigurationInput, self).__init__(**kwargs)
        self.account_name = account_name
        self.management_key = management_key


class Gen2StorageConfigurationMutableProperties(msrest.serialization.Model):
    """The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.

    All required parameters must be populated in order to send to Azure.

    :param management_key: Required. The value of the management key that grants the Time Series
     Insights service write access to the storage account. This property is not shown in environment
     responses.
    :type management_key: str
    """

    _validation = {
        'management_key': {'required': True},
    }

    _attribute_map = {
        'management_key': {'key': 'managementKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        management_key: str,
        **kwargs
    ):
        super(Gen2StorageConfigurationMutableProperties, self).__init__(**kwargs)
        self.management_key = management_key


class Gen2StorageConfigurationOutput(msrest.serialization.Model):
    """The storage configuration provides the non-secret connection details about the customer storage account that is used to store the environment's data.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. The name of the storage account that will hold the environment's
     Gen2 data.
    :type account_name: str
    """

    _validation = {
        'account_name': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        **kwargs
    ):
        super(Gen2StorageConfigurationOutput, self).__init__(**kwargs)
        self.account_name = account_name


class IngressEnvironmentStatus(msrest.serialization.Model):
    """An object that represents the status of ingress on an environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param state: This string represents the state of ingress operations on an environment. It can
     be "Disabled", "Ready", "Running", "Paused" or "Unknown". Possible values include: "Disabled",
     "Ready", "Running", "Paused", "Unknown".
    :type state: str or ~azure.mgmt.timeseriesinsights.models.IngressState
    :ivar state_details: An object that contains the details about an environment's state.
    :vartype state_details: ~azure.mgmt.timeseriesinsights.models.EnvironmentStateDetails
    """

    _validation = {
        'state_details': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'state_details': {'key': 'stateDetails', 'type': 'EnvironmentStateDetails'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "IngressState"]] = None,
        **kwargs
    ):
        super(IngressEnvironmentStatus, self).__init__(**kwargs)
        self.state = state
        self.state_details = None


class IoTHubEventSourceCommonProperties(AzureEventSourceProperties):
    """Properties of the IoTHub event source.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param iot_hub_name: Required. The name of the iot hub.
    :type iot_hub_name: str
    :param consumer_group_name: Required. The name of the iot hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the Shared Access Policy key that grants the Time Series
     Insights service access to the iot hub. This shared access policy key must grant 'service
     connect' permissions to the iot hub.
    :type key_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'iot_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'eventSourceResourceId', 'type': 'str'},
        'iot_hub_name': {'key': 'iotHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_source_resource_id: str,
        iot_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(IoTHubEventSourceCommonProperties, self).__init__(timestamp_property_name=timestamp_property_name, event_source_resource_id=event_source_resource_id, **kwargs)
        self.iot_hub_name = iot_hub_name
        self.consumer_group_name = consumer_group_name
        self.key_name = key_name


class IoTHubEventSourceCreateOrUpdateParameters(EventSourceCreateOrUpdateParameters):
    """Parameters supplied to the Create or Update Event Source operation for an IoTHub event source.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional properties for the resource.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the event source.Constant filled by server.  Possible values
     include: "Microsoft.EventHub", "Microsoft.IoTHub".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EventSourceKind
    :param local_timestamp: An object that represents the local timestamp property. It contains the
     format of local timestamp that needs to be used and the corresponding timezone offset
     information. If a value isn't specified for localTimestamp, or if null, then the local
     timestamp will not be ingressed with the events.
    :type local_timestamp: ~azure.mgmt.timeseriesinsights.models.LocalTimestamp
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param iot_hub_name: Required. The name of the iot hub.
    :type iot_hub_name: str
    :param consumer_group_name: Required. The name of the iot hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the Shared Access Policy key that grants the Time Series
     Insights service access to the iot hub. This shared access policy key must grant 'service
     connect' permissions to the iot hub.
    :type key_name: str
    :param shared_access_key: Required. The value of the Shared Access Policy key that grants the
     Time Series Insights service read access to the iot hub. This property is not shown in event
     source responses.
    :type shared_access_key: str
    """

    _validation = {
        'location': {'required': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'iot_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
        'shared_access_key': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'local_timestamp': {'key': 'localTimestamp', 'type': 'LocalTimestamp'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'properties.timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'properties.eventSourceResourceId', 'type': 'str'},
        'iot_hub_name': {'key': 'properties.iotHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'properties.consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'properties.keyName', 'type': 'str'},
        'shared_access_key': {'key': 'properties.sharedAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        event_source_resource_id: str,
        iot_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        shared_access_key: str,
        tags: Optional[Dict[str, str]] = None,
        local_timestamp: Optional["LocalTimestamp"] = None,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(IoTHubEventSourceCreateOrUpdateParameters, self).__init__(location=location, tags=tags, local_timestamp=local_timestamp, **kwargs)
        self.kind = 'Microsoft.IoTHub'  # type: str
        self.provisioning_state = None
        self.creation_time = None
        self.timestamp_property_name = timestamp_property_name
        self.event_source_resource_id = event_source_resource_id
        self.iot_hub_name = iot_hub_name
        self.consumer_group_name = consumer_group_name
        self.key_name = key_name
        self.shared_access_key = shared_access_key


class IoTHubEventSourceCreationProperties(IoTHubEventSourceCommonProperties):
    """Properties of the IoTHub event source that are required on create or update requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param iot_hub_name: Required. The name of the iot hub.
    :type iot_hub_name: str
    :param consumer_group_name: Required. The name of the iot hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the Shared Access Policy key that grants the Time Series
     Insights service access to the iot hub. This shared access policy key must grant 'service
     connect' permissions to the iot hub.
    :type key_name: str
    :param shared_access_key: Required. The value of the Shared Access Policy key that grants the
     Time Series Insights service read access to the iot hub. This property is not shown in event
     source responses.
    :type shared_access_key: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'iot_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
        'shared_access_key': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'eventSourceResourceId', 'type': 'str'},
        'iot_hub_name': {'key': 'iotHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'shared_access_key': {'key': 'sharedAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_source_resource_id: str,
        iot_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        shared_access_key: str,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(IoTHubEventSourceCreationProperties, self).__init__(timestamp_property_name=timestamp_property_name, event_source_resource_id=event_source_resource_id, iot_hub_name=iot_hub_name, consumer_group_name=consumer_group_name, key_name=key_name, **kwargs)
        self.shared_access_key = shared_access_key


class IoTHubEventSourceMutableProperties(EventSourceMutableProperties):
    """An object that represents a set of mutable IoTHub event source resource properties.

    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param local_timestamp: An object that represents the local timestamp property. It contains the
     format of local timestamp that needs to be used and the corresponding timezone offset
     information. If a value isn't specified for localTimestamp, or if null, then the local
     timestamp will not be ingressed with the events.
    :type local_timestamp: ~azure.mgmt.timeseriesinsights.models.LocalTimestamp
    :param shared_access_key: The value of the shared access key that grants the Time Series
     Insights service read access to the iot hub. This property is not shown in event source
     responses.
    :type shared_access_key: str
    """

    _attribute_map = {
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'local_timestamp': {'key': 'localTimestamp', 'type': 'LocalTimestamp'},
        'shared_access_key': {'key': 'sharedAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timestamp_property_name: Optional[str] = None,
        local_timestamp: Optional["LocalTimestamp"] = None,
        shared_access_key: Optional[str] = None,
        **kwargs
    ):
        super(IoTHubEventSourceMutableProperties, self).__init__(timestamp_property_name=timestamp_property_name, local_timestamp=local_timestamp, **kwargs)
        self.shared_access_key = shared_access_key


class IoTHubEventSourceResource(EventSourceResource):
    """An event source that receives its data from an Azure IoTHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: Required. The kind of the event source.Constant filled by server.  Possible values
     include: "Microsoft.EventHub", "Microsoft.IoTHub".
    :type kind: str or ~azure.mgmt.timeseriesinsights.models.EventSourceResourceKind
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param iot_hub_name: Required. The name of the iot hub.
    :type iot_hub_name: str
    :param consumer_group_name: Required. The name of the iot hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the Shared Access Policy key that grants the Time Series
     Insights service access to the iot hub. This shared access policy key must grant 'service
     connect' permissions to the iot hub.
    :type key_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'iot_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'properties.timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'properties.eventSourceResourceId', 'type': 'str'},
        'iot_hub_name': {'key': 'properties.iotHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'properties.consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'properties.keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        event_source_resource_id: str,
        iot_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        tags: Optional[Dict[str, str]] = None,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(IoTHubEventSourceResource, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = 'Microsoft.IoTHub'  # type: str
        self.provisioning_state = None
        self.creation_time = None
        self.timestamp_property_name = timestamp_property_name
        self.event_source_resource_id = event_source_resource_id
        self.iot_hub_name = iot_hub_name
        self.consumer_group_name = consumer_group_name
        self.key_name = key_name


class IoTHubEventSourceResourceProperties(IoTHubEventSourceCommonProperties):
    """Properties of the IoTHub event source resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param event_source_resource_id: Required. The resource id of the event source in Azure
     Resource Manager.
    :type event_source_resource_id: str
    :param iot_hub_name: Required. The name of the iot hub.
    :type iot_hub_name: str
    :param consumer_group_name: Required. The name of the iot hub's consumer group that holds the
     partitions from which events will be read.
    :type consumer_group_name: str
    :param key_name: Required. The name of the Shared Access Policy key that grants the Time Series
     Insights service access to the iot hub. This shared access policy key must grant 'service
     connect' permissions to the iot hub.
    :type key_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'event_source_resource_id': {'required': True},
        'iot_hub_name': {'required': True},
        'consumer_group_name': {'required': True},
        'key_name': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'timestamp_property_name': {'key': 'timestampPropertyName', 'type': 'str'},
        'event_source_resource_id': {'key': 'eventSourceResourceId', 'type': 'str'},
        'iot_hub_name': {'key': 'iotHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'consumerGroupName', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_source_resource_id: str,
        iot_hub_name: str,
        consumer_group_name: str,
        key_name: str,
        timestamp_property_name: Optional[str] = None,
        **kwargs
    ):
        super(IoTHubEventSourceResourceProperties, self).__init__(timestamp_property_name=timestamp_property_name, event_source_resource_id=event_source_resource_id, iot_hub_name=iot_hub_name, consumer_group_name=consumer_group_name, key_name=key_name, **kwargs)


class IoTHubEventSourceUpdateParameters(EventSourceUpdateParameters):
    """Parameters supplied to the Update Event Source operation to update an IoTHub event source.

    :param tags: A set of tags. Key-value pairs of additional properties for the event source.
    :type tags: dict[str, str]
    :param timestamp_property_name: The event property that will be used as the event source's
     timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is
     specified, the event creation time will be used.
    :type timestamp_property_name: str
    :param local_timestamp: An object that represents the local timestamp property. It contains the
     format of local timestamp that needs to be used and the corresponding timezone offset
     information. If a value isn't specified for localTimestamp, or if null, then the local
     timestamp will not be ingressed with the events.
    :type local_timestamp: ~azure.mgmt.timeseriesinsights.models.LocalTimestamp
    :param shared_access_key: The value of the shared access key that grants the Time Series
     Insights service read access to the iot hub. This property is not shown in event source
     responses.
    :type shared_access_key: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'timestamp_property_name': {'key': 'properties.timestampPropertyName', 'type': 'str'},
        'local_timestamp': {'key': 'properties.localTimestamp', 'type': 'LocalTimestamp'},
        'shared_access_key': {'key': 'properties.sharedAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        timestamp_property_name: Optional[str] = None,
        local_timestamp: Optional["LocalTimestamp"] = None,
        shared_access_key: Optional[str] = None,
        **kwargs
    ):
        super(IoTHubEventSourceUpdateParameters, self).__init__(tags=tags, **kwargs)
        self.timestamp_property_name = timestamp_property_name
        self.local_timestamp = local_timestamp
        self.shared_access_key = shared_access_key


class LocalTimestamp(msrest.serialization.Model):
    """An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.

    :param format: An enum that represents the format of the local timestamp property that needs to
     be set. Possible values include: "Embedded".
    :type format: str or ~azure.mgmt.timeseriesinsights.models.LocalTimestampFormat
    :param time_zone_offset: An object that represents the offset information for the local
     timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
    :type time_zone_offset: ~azure.mgmt.timeseriesinsights.models.LocalTimestampTimeZoneOffset
    """

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'time_zone_offset': {'key': 'timeZoneOffset', 'type': 'LocalTimestampTimeZoneOffset'},
    }

    def __init__(
        self,
        *,
        format: Optional[Union[str, "LocalTimestampFormat"]] = None,
        time_zone_offset: Optional["LocalTimestampTimeZoneOffset"] = None,
        **kwargs
    ):
        super(LocalTimestamp, self).__init__(**kwargs)
        self.format = format
        self.time_zone_offset = time_zone_offset


class LocalTimestampTimeZoneOffset(msrest.serialization.Model):
    """An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.

    :param property_name: The event property that will be contain the offset information to
     calculate the local timestamp. When the LocalTimestampFormat is Iana, the property name will
     contain the name of the column which contains IANA Timezone Name (eg: Americas/Los Angeles).
     When LocalTimestampFormat is Timespan, it contains the name of property which contains values
     representing the offset (eg: P1D or 1.00:00:00).
    :type property_name: str
    """

    _attribute_map = {
        'property_name': {'key': 'propertyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        property_name: Optional[str] = None,
        **kwargs
    ):
        super(LocalTimestampTimeZoneOffset, self).__init__(**kwargs)
        self.property_name = property_name


class Operation(msrest.serialization.Model):
    """A Time Series Insights REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: Contains the localized display information for this particular operation /
     action.
    :vartype display: ~azure.mgmt.timeseriesinsights.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None


class OperationDisplay(msrest.serialization.Model):
    """Contains the localized display information for this particular operation / action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Time Series Insights operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Time Series Insights operations supported by the
     Microsoft.TimeSeriesInsights resource provider.
    :vartype value: list[~azure.mgmt.timeseriesinsights.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ReferenceDataSetCreateOrUpdateParameters(CreateOrUpdateTrackedResourceProperties):
    """ReferenceDataSetCreateOrUpdateParameters.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional properties for the resource.
    :type tags: dict[str, str]
    :param key_properties: Required. The list of key properties for the reference data set.
    :type key_properties: list[~azure.mgmt.timeseriesinsights.models.ReferenceDataSetKeyProperty]
    :param data_string_comparison_behavior: The reference data set key comparison behavior can be
     set using this property. By default, the value is 'Ordinal' - which means case sensitive key
     comparison will be performed while joining reference data with events or while adding new
     reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     Possible values include: "Ordinal", "OrdinalIgnoreCase".
    :type data_string_comparison_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.DataStringComparisonBehavior
    """

    _validation = {
        'location': {'required': True},
        'key_properties': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_properties': {'key': 'properties.keyProperties', 'type': '[ReferenceDataSetKeyProperty]'},
        'data_string_comparison_behavior': {'key': 'properties.dataStringComparisonBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        key_properties: List["ReferenceDataSetKeyProperty"],
        tags: Optional[Dict[str, str]] = None,
        data_string_comparison_behavior: Optional[Union[str, "DataStringComparisonBehavior"]] = None,
        **kwargs
    ):
        super(ReferenceDataSetCreateOrUpdateParameters, self).__init__(location=location, tags=tags, **kwargs)
        self.key_properties = key_properties
        self.data_string_comparison_behavior = data_string_comparison_behavior


class ReferenceDataSetCreationProperties(msrest.serialization.Model):
    """Properties used to create a reference data set.

    All required parameters must be populated in order to send to Azure.

    :param key_properties: Required. The list of key properties for the reference data set.
    :type key_properties: list[~azure.mgmt.timeseriesinsights.models.ReferenceDataSetKeyProperty]
    :param data_string_comparison_behavior: The reference data set key comparison behavior can be
     set using this property. By default, the value is 'Ordinal' - which means case sensitive key
     comparison will be performed while joining reference data with events or while adding new
     reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     Possible values include: "Ordinal", "OrdinalIgnoreCase".
    :type data_string_comparison_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.DataStringComparisonBehavior
    """

    _validation = {
        'key_properties': {'required': True},
    }

    _attribute_map = {
        'key_properties': {'key': 'keyProperties', 'type': '[ReferenceDataSetKeyProperty]'},
        'data_string_comparison_behavior': {'key': 'dataStringComparisonBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_properties: List["ReferenceDataSetKeyProperty"],
        data_string_comparison_behavior: Optional[Union[str, "DataStringComparisonBehavior"]] = None,
        **kwargs
    ):
        super(ReferenceDataSetCreationProperties, self).__init__(**kwargs)
        self.key_properties = key_properties
        self.data_string_comparison_behavior = data_string_comparison_behavior


class ReferenceDataSetKeyProperty(msrest.serialization.Model):
    """A key property for the reference data set. A reference data set can have multiple key properties.

    :param name: The name of the key property.
    :type name: str
    :param type: The type of the key property. Possible values include: "String", "Double", "Bool",
     "DateTime".
    :type type: str or ~azure.mgmt.timeseriesinsights.models.ReferenceDataKeyPropertyType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "ReferenceDataKeyPropertyType"]] = None,
        **kwargs
    ):
        super(ReferenceDataSetKeyProperty, self).__init__(**kwargs)
        self.name = name
        self.type = type


class ReferenceDataSetListResponse(msrest.serialization.Model):
    """The response of the List Reference Data Sets operation.

    :param value: Result of the List Reference Data Sets operation.
    :type value: list[~azure.mgmt.timeseriesinsights.models.ReferenceDataSetResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReferenceDataSetResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ReferenceDataSetResource"]] = None,
        **kwargs
    ):
        super(ReferenceDataSetListResponse, self).__init__(**kwargs)
        self.value = value


class ReferenceDataSetResource(TrackedResource):
    """A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified through the Time Series Insights data plane APIs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param key_properties: The list of key properties for the reference data set.
    :type key_properties: list[~azure.mgmt.timeseriesinsights.models.ReferenceDataSetKeyProperty]
    :param data_string_comparison_behavior: The reference data set key comparison behavior can be
     set using this property. By default, the value is 'Ordinal' - which means case sensitive key
     comparison will be performed while joining reference data with events or while adding new
     reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     Possible values include: "Ordinal", "OrdinalIgnoreCase".
    :type data_string_comparison_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.DataStringComparisonBehavior
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_properties': {'key': 'properties.keyProperties', 'type': '[ReferenceDataSetKeyProperty]'},
        'data_string_comparison_behavior': {'key': 'properties.dataStringComparisonBehavior', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        key_properties: Optional[List["ReferenceDataSetKeyProperty"]] = None,
        data_string_comparison_behavior: Optional[Union[str, "DataStringComparisonBehavior"]] = None,
        **kwargs
    ):
        super(ReferenceDataSetResource, self).__init__(location=location, tags=tags, **kwargs)
        self.key_properties = key_properties
        self.data_string_comparison_behavior = data_string_comparison_behavior
        self.provisioning_state = None
        self.creation_time = None


class ReferenceDataSetResourceProperties(ReferenceDataSetCreationProperties, ResourceProperties):
    """Properties of the reference data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Accepted", "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.timeseriesinsights.models.ProvisioningState
    :ivar creation_time: The time the resource was created.
    :vartype creation_time: ~datetime.datetime
    :param key_properties: Required. The list of key properties for the reference data set.
    :type key_properties: list[~azure.mgmt.timeseriesinsights.models.ReferenceDataSetKeyProperty]
    :param data_string_comparison_behavior: The reference data set key comparison behavior can be
     set using this property. By default, the value is 'Ordinal' - which means case sensitive key
     comparison will be performed while joining reference data with events or while adding new
     reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     Possible values include: "Ordinal", "OrdinalIgnoreCase".
    :type data_string_comparison_behavior: str or
     ~azure.mgmt.timeseriesinsights.models.DataStringComparisonBehavior
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'key_properties': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'key_properties': {'key': 'keyProperties', 'type': '[ReferenceDataSetKeyProperty]'},
        'data_string_comparison_behavior': {'key': 'dataStringComparisonBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_properties: List["ReferenceDataSetKeyProperty"],
        data_string_comparison_behavior: Optional[Union[str, "DataStringComparisonBehavior"]] = None,
        **kwargs
    ):
        super(ReferenceDataSetResourceProperties, self).__init__(key_properties=key_properties, data_string_comparison_behavior=data_string_comparison_behavior, **kwargs)
        self.provisioning_state = None
        self.creation_time = None
        self.key_properties = key_properties
        self.data_string_comparison_behavior = data_string_comparison_behavior


class ReferenceDataSetUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Update Reference Data Set operation.

    :param tags: A set of tags. Key-value pairs of additional properties for the reference data
     set.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ReferenceDataSetUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class Sku(msrest.serialization.Model):
    """The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of this SKU. Possible values include: "S1", "S2", "P1", "L1".
    :type name: str or ~azure.mgmt.timeseriesinsights.models.SkuName
    :param capacity: Required. The capacity of the sku. For Gen1 environments, this value can be
     changed to support scale out of environments after they have been created.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'required': True, 'maximum': 10, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        capacity: int,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class TimeSeriesIdProperty(msrest.serialization.Model):
    """The structure of the property that a time series id can have. An environment can have multiple such properties.

    :param name: The name of the property.
    :type name: str
    :param type: The type of the property. Possible values include: "String".
    :type type: str or ~azure.mgmt.timeseriesinsights.models.PropertyType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "PropertyType"]] = None,
        **kwargs
    ):
        super(TimeSeriesIdProperty, self).__init__(**kwargs)
        self.name = name
        self.type = type


class WarmStorageEnvironmentStatus(msrest.serialization.Model):
    """An object that represents the status of warm storage on an environment.

    :param state: This string represents the state of warm storage properties usage. It can be
     "Ok", "Error", "Unknown". Possible values include: "Ok", "Error", "Unknown".
    :type state: str or ~azure.mgmt.timeseriesinsights.models.WarmStoragePropertiesState
    :param current_count: A value that represents the number of properties used by the environment
     for S1/S2 SKU and number of properties used by Warm Store for PAYG SKU.
    :type current_count: int
    :param max_count: A value that represents the maximum number of properties used allowed by the
     environment for S1/S2 SKU and maximum number of properties allowed by Warm Store for PAYG SKU.
    :type max_count: int
    """

    _validation = {
        'current_count': {'maximum': 10, 'minimum': 1},
        'max_count': {'maximum': 10, 'minimum': 1},
    }

    _attribute_map = {
        'state': {'key': 'propertiesUsage.state', 'type': 'str'},
        'current_count': {'key': 'propertiesUsage.stateDetails.currentCount', 'type': 'int'},
        'max_count': {'key': 'propertiesUsage.stateDetails.maxCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "WarmStoragePropertiesState"]] = None,
        current_count: Optional[int] = None,
        max_count: Optional[int] = None,
        **kwargs
    ):
        super(WarmStorageEnvironmentStatus, self).__init__(**kwargs)
        self.state = state
        self.current_count = current_count
        self.max_count = max_count


class WarmStoreConfigurationProperties(msrest.serialization.Model):
    """The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.

    All required parameters must be populated in order to send to Azure.

    :param data_retention: Required. ISO8601 timespan specifying the number of days the
     environment's events will be available for query from the warm store.
    :type data_retention: ~datetime.timedelta
    """

    _validation = {
        'data_retention': {'required': True},
    }

    _attribute_map = {
        'data_retention': {'key': 'dataRetention', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        data_retention: datetime.timedelta,
        **kwargs
    ):
        super(WarmStoreConfigurationProperties, self).__init__(**kwargs)
        self.data_retention = data_retention
