#include "main.hpp"
#include <unicode/udat.h>

void init_udat(py::module &m) {
#if (U_ICU_VERSION_MAJOR_NUM >= 53)
  py::enum_<UDateFormatBooleanAttribute>(m, "UDateFormatBooleanAttribute", py::arithmetic())
      .value("UDAT_PARSE_ALLOW_WHITESPACE", UDAT_PARSE_ALLOW_WHITESPACE)
      .value("UDAT_PARSE_ALLOW_NUMERIC", UDAT_PARSE_ALLOW_NUMERIC)
#if (U_ICU_VERSION_MAJOR_NUM >= 56)
      .value("UDAT_PARSE_PARTIAL_LITERAL_MATCH", UDAT_PARSE_PARTIAL_LITERAL_MATCH)
      .value("UDAT_PARSE_MULTIPLE_PATTERNS_FOR_MATCH", UDAT_PARSE_MULTIPLE_PATTERNS_FOR_MATCH)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 56)
      ;
#endif // (U_ICU_VERSION_MAJOR_NUM >= 53)

  py::enum_<UDateFormatField>(m, "UDateFormatField", py::arithmetic())
      .value("UDAT_ERA_FIELD", UDAT_ERA_FIELD)
      .value("UDAT_YEAR_FIELD", UDAT_YEAR_FIELD)
      .value("UDAT_MONTH_FIELD", UDAT_MONTH_FIELD)
      .value("UDAT_DATE_FIELD", UDAT_DATE_FIELD)
      .value("UDAT_HOUR_OF_DAY1_FIELD", UDAT_HOUR_OF_DAY1_FIELD)
      .value("UDAT_HOUR_OF_DAY0_FIELD", UDAT_HOUR_OF_DAY0_FIELD)
      .value("UDAT_MINUTE_FIELD", UDAT_MINUTE_FIELD)
      .value("UDAT_SECOND_FIELD", UDAT_SECOND_FIELD)
      .value("UDAT_FRACTIONAL_SECOND_FIELD", UDAT_FRACTIONAL_SECOND_FIELD)
      .value("UDAT_DAY_OF_WEEK_FIELD", UDAT_DAY_OF_WEEK_FIELD)
      .value("UDAT_DAY_OF_YEAR_FIELD", UDAT_DAY_OF_YEAR_FIELD)
      .value("UDAT_DAY_OF_WEEK_IN_MONTH_FIELD", UDAT_DAY_OF_WEEK_IN_MONTH_FIELD)
      .value("UDAT_WEEK_OF_YEAR_FIELD", UDAT_WEEK_OF_YEAR_FIELD)
      .value("UDAT_WEEK_OF_MONTH_FIELD", UDAT_WEEK_OF_MONTH_FIELD)
      .value("UDAT_AM_PM_FIELD", UDAT_AM_PM_FIELD)
      .value("UDAT_HOUR1_FIELD", UDAT_HOUR1_FIELD)
      .value("UDAT_HOUR0_FIELD", UDAT_HOUR0_FIELD)
      .value("UDAT_TIMEZONE_FIELD", UDAT_TIMEZONE_FIELD)
      .value("UDAT_YEAR_WOY_FIELD", UDAT_YEAR_WOY_FIELD)
      .value("UDAT_DOW_LOCAL_FIELD", UDAT_DOW_LOCAL_FIELD)
      .value("UDAT_EXTENDED_YEAR_FIELD", UDAT_EXTENDED_YEAR_FIELD)
      .value("UDAT_JULIAN_DAY_FIELD", UDAT_JULIAN_DAY_FIELD)
      .value("UDAT_MILLISECONDS_IN_DAY_FIELD", UDAT_MILLISECONDS_IN_DAY_FIELD)
      .value("UDAT_TIMEZONE_RFC_FIELD", UDAT_TIMEZONE_RFC_FIELD)
      .value("UDAT_TIMEZONE_GENERIC_FIELD", UDAT_TIMEZONE_GENERIC_FIELD)
      .value("UDAT_STANDALONE_DAY_FIELD", UDAT_STANDALONE_DAY_FIELD)
      .value("UDAT_STANDALONE_MONTH_FIELD", UDAT_STANDALONE_MONTH_FIELD)
      .value("UDAT_QUARTER_FIELD", UDAT_QUARTER_FIELD)
      .value("UDAT_STANDALONE_QUARTER_FIELD", UDAT_STANDALONE_QUARTER_FIELD)
      .value("UDAT_TIMEZONE_SPECIAL_FIELD", UDAT_TIMEZONE_SPECIAL_FIELD)
#if (U_ICU_VERSION_MAJOR_NUM >= 49)
      .value("UDAT_YEAR_NAME_FIELD", UDAT_YEAR_NAME_FIELD)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 49)

#if (U_ICU_VERSION_MAJOR_NUM >= 51)
      .value("UDAT_TIMEZONE_LOCALIZED_GMT_OFFSET_FIELD", UDAT_TIMEZONE_LOCALIZED_GMT_OFFSET_FIELD)
      .value("UDAT_TIMEZONE_ISO_FIELD", UDAT_TIMEZONE_ISO_FIELD)
      .value("UDAT_TIMEZONE_ISO_LOCAL_FIELD", UDAT_TIMEZONE_ISO_LOCAL_FIELD)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 51)

#if (U_ICU_VERSION_MAJOR_NUM >= 57)
      .value("UDAT_AM_PM_MIDNIGHT_NOON_FIELD", UDAT_AM_PM_MIDNIGHT_NOON_FIELD)
      .value("UDAT_FLEXIBLE_DAY_PERIOD_FIELD", UDAT_FLEXIBLE_DAY_PERIOD_FIELD)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 57)
      ;

#if (U_ICU_VERSION_MAJOR_NUM >= 67)
  py::enum_<UDateFormatHourCycle>(m, "UDateFormatHourCycle", py::arithmetic())
      .value("UDAT_HOUR_CYCLE_11", UDAT_HOUR_CYCLE_11)
      .value("UDAT_HOUR_CYCLE_12", UDAT_HOUR_CYCLE_12)
      .value("UDAT_HOUR_CYCLE_23", UDAT_HOUR_CYCLE_23)
      .value("UDAT_HOUR_CYCLE_24", UDAT_HOUR_CYCLE_24);
#endif // (U_ICU_VERSION_MAJOR_NUM >= 67)

  py::enum_<UDateFormatStyle>(m, "UDateFormatStyle", py::arithmetic())
      .value("UDAT_FULL", UDAT_FULL)
      .value("UDAT_LONG", UDAT_LONG)
      .value("UDAT_MEDIUM", UDAT_MEDIUM)
      .value("UDAT_SHORT", UDAT_SHORT)
      .value("UDAT_DEFAULT", UDAT_DEFAULT)
      .value("UDAT_RELATIVE", UDAT_RELATIVE)
      .value("UDAT_FULL_RELATIVE", UDAT_FULL_RELATIVE)
      .value("UDAT_LONG_RELATIVE", UDAT_LONG_RELATIVE)
      .value("UDAT_MEDIUM_RELATIVE", UDAT_MEDIUM_RELATIVE)
      .value("UDAT_SHORT_RELATIVE", UDAT_SHORT_RELATIVE)
      .value("UDAT_NONE", UDAT_NONE)
#if (U_ICU_VERSION_MAJOR_NUM >= 50)
      .value("UDAT_PATTERN", UDAT_PATTERN)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 50)
      ;

  py::enum_<UDateFormatSymbolType>(m, "UDateFormatSymbolType", py::arithmetic())
      .value("UDAT_ERAS", UDAT_ERAS)
      .value("UDAT_MONTHS", UDAT_MONTHS)
      .value("UDAT_SHORT_MONTHS", UDAT_SHORT_MONTHS)
      .value("UDAT_WEEKDAYS", UDAT_WEEKDAYS)
      .value("UDAT_SHORT_WEEKDAYS", UDAT_SHORT_WEEKDAYS)
      .value("UDAT_AM_PMS", UDAT_AM_PMS)
      .value("UDAT_LOCALIZED_CHARS", UDAT_LOCALIZED_CHARS)
      .value("UDAT_ERA_NAMES", UDAT_ERA_NAMES)
      .value("UDAT_NARROW_MONTHS", UDAT_NARROW_MONTHS)
      .value("UDAT_NARROW_WEEKDAYS", UDAT_NARROW_WEEKDAYS)
      .value("UDAT_STANDALONE_MONTHS", UDAT_STANDALONE_MONTHS)
      .value("UDAT_STANDALONE_SHORT_MONTHS", UDAT_STANDALONE_SHORT_MONTHS)
      .value("UDAT_STANDALONE_NARROW_MONTHS", UDAT_STANDALONE_NARROW_MONTHS)
      .value("UDAT_STANDALONE_WEEKDAYS", UDAT_STANDALONE_WEEKDAYS)
      .value("UDAT_STANDALONE_SHORT_WEEKDAYS", UDAT_STANDALONE_SHORT_WEEKDAYS)
      .value("UDAT_STANDALONE_NARROW_WEEKDAYS", UDAT_STANDALONE_NARROW_WEEKDAYS)
      .value("UDAT_QUARTERS", UDAT_QUARTERS)
      .value("UDAT_SHORT_QUARTERS", UDAT_SHORT_QUARTERS)
      .value("UDAT_STANDALONE_QUARTERS", UDAT_STANDALONE_QUARTERS)
      .value("UDAT_STANDALONE_SHORT_QUARTERS", UDAT_STANDALONE_SHORT_QUARTERS)
#if (U_ICU_VERSION_MAJOR_NUM >= 51)
      .value("UDAT_SHORTER_WEEKDAYS", UDAT_SHORTER_WEEKDAYS)
      .value("UDAT_STANDALONE_SHORTER_WEEKDAYS", UDAT_STANDALONE_SHORTER_WEEKDAYS)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 51)

#if (U_ICU_VERSION_MAJOR_NUM >= 54)
      .value("UDAT_CYCLIC_YEARS_WIDE", UDAT_CYCLIC_YEARS_WIDE)
      .value("UDAT_CYCLIC_YEARS_ABBREVIATED", UDAT_CYCLIC_YEARS_ABBREVIATED)
      .value("UDAT_CYCLIC_YEARS_NARROW", UDAT_CYCLIC_YEARS_NARROW)
      .value("UDAT_ZODIAC_NAMES_WIDE", UDAT_ZODIAC_NAMES_WIDE)
      .value("UDAT_ZODIAC_NAMES_ABBREVIATED", UDAT_ZODIAC_NAMES_ABBREVIATED)
      .value("UDAT_ZODIAC_NAMES_NARROW", UDAT_ZODIAC_NAMES_NARROW)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 54)
      ;

  // Skeletons for dates
  m.attr("UDAT_ABBR_MONTH_DAY") = UDAT_ABBR_MONTH_DAY;
  m.attr("UDAT_ABBR_MONTH_WEEKDAY_DAY") = UDAT_ABBR_MONTH_WEEKDAY_DAY;
  m.attr("UDAT_ABBR_MONTH") = UDAT_ABBR_MONTH;
  m.attr("UDAT_DAY") = UDAT_DAY;
  m.attr("UDAT_MONTH_DAY") = UDAT_MONTH_DAY;
  m.attr("UDAT_MONTH_WEEKDAY_DAY") = UDAT_MONTH_WEEKDAY_DAY;
  m.attr("UDAT_MONTH") = UDAT_MONTH;
  m.attr("UDAT_NUM_MONTH_DAY") = UDAT_NUM_MONTH_DAY;
  m.attr("UDAT_NUM_MONTH_WEEKDAY_DAY") = UDAT_NUM_MONTH_WEEKDAY_DAY;
  m.attr("UDAT_NUM_MONTH") = UDAT_NUM_MONTH;
  m.attr("UDAT_YEAR_ABBR_MONTH_DAY") = UDAT_YEAR_ABBR_MONTH_DAY;
  m.attr("UDAT_YEAR_ABBR_MONTH_WEEKDAY_DAY") = UDAT_YEAR_ABBR_MONTH_WEEKDAY_DAY;
  m.attr("UDAT_YEAR_ABBR_MONTH") = UDAT_YEAR_ABBR_MONTH;
  m.attr("UDAT_YEAR_ABBR_QUARTER") = UDAT_YEAR_ABBR_QUARTER;
  m.attr("UDAT_YEAR_MONTH_DAY") = UDAT_YEAR_MONTH_DAY;
  m.attr("UDAT_YEAR_MONTH_WEEKDAY_DAY") = UDAT_YEAR_MONTH_WEEKDAY_DAY;
  m.attr("UDAT_YEAR_MONTH") = UDAT_YEAR_MONTH;
  m.attr("UDAT_YEAR_NUM_MONTH_DAY") = UDAT_YEAR_NUM_MONTH_DAY;
  m.attr("UDAT_YEAR_NUM_MONTH_WEEKDAY_DAY") = UDAT_YEAR_NUM_MONTH_WEEKDAY_DAY;
  m.attr("UDAT_YEAR_NUM_MONTH") = UDAT_YEAR_NUM_MONTH;
  m.attr("UDAT_YEAR_QUARTER") = UDAT_YEAR_QUARTER;
  m.attr("UDAT_YEAR") = UDAT_YEAR;

  // Skeletons for times
  m.attr("UDAT_HOUR_MINUTE_SECOND") = UDAT_HOUR_MINUTE_SECOND;
  m.attr("UDAT_HOUR_MINUTE") = UDAT_HOUR_MINUTE;
  m.attr("UDAT_HOUR") = UDAT_HOUR;
  m.attr("UDAT_HOUR24_MINUTE_SECOND") = UDAT_HOUR24_MINUTE_SECOND;
  m.attr("UDAT_HOUR24_MINUTE") = UDAT_HOUR24_MINUTE;
  m.attr("UDAT_MINUTE_SECOND") = UDAT_MINUTE_SECOND;

#if (U_ICU_VERSION_MAJOR_NUM >= 51)
  // Skeletons for dates
  m.attr("UDAT_ABBR_QUARTER") = UDAT_ABBR_QUARTER;
  m.attr("UDAT_ABBR_WEEKDAY") = UDAT_ABBR_WEEKDAY;
  m.attr("UDAT_QUARTER") = UDAT_QUARTER;
  m.attr("UDAT_WEEKDAY") = UDAT_WEEKDAY;

  // Skeletons for times
  m.attr("UDAT_HOUR24") = UDAT_HOUR24;
  m.attr("UDAT_MINUTE") = UDAT_MINUTE;
  m.attr("UDAT_SECOND") = UDAT_SECOND;

  // Skeletons for time zones
  m.attr("UDAT_ABBR_GENERIC_TZ") = UDAT_ABBR_GENERIC_TZ;
  m.attr("UDAT_ABBR_SPECIFIC_TZ") = UDAT_ABBR_SPECIFIC_TZ;
  m.attr("UDAT_ABBR_UTC_TZ") = UDAT_ABBR_UTC_TZ;
  m.attr("UDAT_GENERIC_TZ") = UDAT_GENERIC_TZ;
  m.attr("UDAT_LOCATION_TZ") = UDAT_LOCATION_TZ;
  m.attr("UDAT_SPECIFIC_TZ") = UDAT_SPECIFIC_TZ;
#endif // (U_ICU_VERSION_MAJOR_NUM >= 51)
}
