"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secrets = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Secrets required for GitHub runners operation.
 */
class Secrets extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.webhook = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Webhook', {
            generateSecretString: {
                secretStringTemplate: '{}',
                generateStringKey: 'webhookSecret',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        this.github = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    domain: 'github.com',
                    appId: '',
                    personalAuthToken: '',
                }),
                generateStringKey: 'dummy',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        // we create a separate secret for the private key because putting it in JSON secret is hard for the user
        this.githubPrivateKey = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub Private Key', {
            secretStringValue: cdk.SecretValue.unsafePlainText('-----BEGIN RSA PRIVATE KEY-----\n...\n-----END RSA PRIVATE KEY-----'),
        });
        this.setup = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Setup', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    token: '',
                }),
                generateStringKey: 'token',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
    }
}
exports.Secrets = Secrets;
_a = JSII_RTTI_SYMBOL_1;
Secrets[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.Secrets", version: "0.3.1" };
//# sourceMappingURL=data:application/json;base64,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