"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Os = exports.Architecture = exports.RunnerVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines desired GitHub Actions runner version.
 */
class RunnerVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * Use the latest version available at the time the runner provider image is built.
     */
    static latest() {
        return new RunnerVersion('latest');
    }
    /**
     * Use a specific version.
     *
     * @see https://github.com/actions/runner/releases
     *
     * @param version GitHub Runner version
     */
    static specific(version) {
        return new RunnerVersion(version);
    }
}
exports.RunnerVersion = RunnerVersion;
_a = JSII_RTTI_SYMBOL_1;
RunnerVersion[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.RunnerVersion", version: "0.3.1" };
/**
 * CPU architecture enum for an image.
 */
class Architecture {
    constructor(name) {
        this.name = name;
    }
    static of(architecture) {
        return new Architecture(architecture);
    }
    /**
    * Checks if the given architecture is the same as this one.
    *
    * @param arch architecture to compare
    */
    is(arch) {
        return arch.name == this.name;
    }
}
exports.Architecture = Architecture;
_b = JSII_RTTI_SYMBOL_1;
Architecture[_b] = { fqn: "@cloudsnorkel/cdk-github-runners.Architecture", version: "0.3.1" };
/**
 * ARM64
 */
Architecture.ARM64 = Architecture.of('ARM64');
/**
 * X86_64
 */
Architecture.X86_64 = Architecture.of('X86_64');
/**
 * OS enum for an image.
 */
class Os {
    constructor(name) {
        this.name = name;
    }
    static of(os) {
        return new Os(os);
    }
    /**
    * Checks if the given OS is the same as this one.
    *
    * @param os OS to compare
    */
    is(os) {
        return os.name == this.name;
    }
}
exports.Os = Os;
_c = JSII_RTTI_SYMBOL_1;
Os[_c] = { fqn: "@cloudsnorkel/cdk-github-runners.Os", version: "0.3.1" };
/**
* Linux
*/
Os.LINUX = Os.of('Linux');
/**
* Windows
*/
Os.WINDOWS = Os.of('Windows');
//# sourceMappingURL=data:application/json;base64,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