"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/lambdas/build-image/index.ts
var build_image_exports = {};
__export(build_image_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(build_image_exports);
var AWS = __toESM(require("aws-sdk"));
var codebuild = new AWS.CodeBuild();
var ecr = new AWS.ECR();
async function handler(event, context) {
  try {
    console.log(JSON.stringify(event));
    const repoName = event.ResourceProperties.RepoName;
    const projectName = event.ResourceProperties.ProjectName;
    switch (event.RequestType) {
      case "Create":
      case "Update":
        console.log(`Starting CodeBuild project ${projectName}`);
        await codebuild.startBuild({
          projectName,
          environmentVariablesOverride: [
            {
              type: "PLAINTEXT",
              name: "STACK_ID",
              value: event.StackId
            },
            {
              type: "PLAINTEXT",
              name: "REQUEST_ID",
              value: event.RequestId
            },
            {
              type: "PLAINTEXT",
              name: "LOGICAL_RESOURCE_ID",
              value: event.LogicalResourceId
            },
            {
              type: "PLAINTEXT",
              name: "RESPONSE_URL",
              value: event.ResponseURL
            }
          ]
        }).promise();
        break;
      case "Delete":
        const images = await ecr.listImages({ repositoryName: repoName, maxResults: 100 }).promise();
        if (images.imageIds && images.imageIds.length > 0) {
          await ecr.batchDeleteImage({
            imageIds: images.imageIds.map((i) => {
              return { imageDigest: i.imageDigest };
            }),
            repositoryName: repoName
          }).promise();
        }
        await respond("SUCCESS", "OK", event.PhysicalResourceId, {});
        break;
    }
  } catch (e) {
    console.log(e);
    await respond("FAILED", e.message || "Internal Error", context.logStreamName, {});
  }
  function respond(responseStatus, reason, physicalResourceId, data) {
    const responseBody = JSON.stringify({
      Status: responseStatus,
      Reason: reason,
      PhysicalResourceId: physicalResourceId,
      StackId: event.StackId,
      RequestId: event.RequestId,
      LogicalResourceId: event.LogicalResourceId,
      NoEcho: false,
      Data: data
    });
    console.log("Responding", responseBody);
    const parsedUrl = require("url").parse(event.ResponseURL);
    const requestOptions = {
      hostname: parsedUrl.hostname,
      path: parsedUrl.path,
      method: "PUT",
      headers: {
        "content-type": "",
        "content-length": responseBody.length
      }
    };
    return new Promise((resolve, reject) => {
      try {
        const request = require("https").request(requestOptions, resolve);
        request.on("error", reject);
        request.write(responseBody);
        request.end();
      } catch (e) {
        reject(e);
      }
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
