# openapi-client
Welcome to the IDX API.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v2
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import openapi_client
from pprint import pprint
from openapi_client.api import account_creation_api
from openapi_client.model.create_user_dto import CreateUserDto
from openapi_client.model.create_user_response_dto import CreateUserResponseDto
from openapi_client.model.order_get_dto import OrderGetDto
from openapi_client.model.order_post_dto import OrderPostDto
# Defining the host is optional and defaults to https://sandbox.api.idx.us
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://sandbox.api.idx.us"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: OAuth
configuration = openapi_client.Configuration(
    host = "https://sandbox.api.idx.us"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = account_creation_api.AccountCreationApi(api_client)
    authorization = "Authorization_example" # str | 
    order_post_dto = OrderPostDto(
        member_id="member_id_example",
        purchase_details=OrderGetDtoPurchaseDetails(
            coupon_id="coupon_id_example",
            discount_coupon_id="discount_coupon_id_example",
        ),
        tracking_id="tracking_id_example",
    ) # OrderPostDto | Order object

    try:
        # Create a new order
        api_response = api_instance.create_order(authorization, order_post_dto)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling AccountCreationApi->create_order: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://sandbox.api.idx.us*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountCreationApi* | [**create_order**](docs/AccountCreationApi.md#create_order) | **POST** /v1/order | Create a new order
*AccountCreationApi* | [**create_user**](docs/AccountCreationApi.md#create_user) | **POST** /v1/user | Create a new user
*CyberscanApi* | [**v1_cyberscan_member_id_data_type_hash_delete**](docs/CyberscanApi.md#v1_cyberscan_member_id_data_type_hash_delete) | **DELETE** /v1/cyberscan/{memberId}/{dataType}/{hash} | Delete the given cyberscan item
*CyberscanApi* | [**v1_cyberscan_member_id_data_type_hash_exposures_get**](docs/CyberscanApi.md#v1_cyberscan_member_id_data_type_hash_exposures_get) | **GET** /v1/cyberscan/{memberId}/{dataType}/{hash}/exposures | Get exposures for the given cyberscan item
*CyberscanApi* | [**v1_cyberscan_member_id_data_type_hash_put**](docs/CyberscanApi.md#v1_cyberscan_member_id_data_type_hash_put) | **PUT** /v1/cyberscan/{memberId}/{dataType}/{hash} | Create or update the given cyberscan item with no value
*CyberscanApi* | [**v1_cyberscan_member_id_get**](docs/CyberscanApi.md#v1_cyberscan_member_id_get) | **GET** /v1/cyberscan/{memberId} | Get cyberscan data
*CyberscanApi* | [**v1_cyberscan_member_id_summary_get**](docs/CyberscanApi.md#v1_cyberscan_member_id_summary_get) | **GET** /v1/cyberscan/{memberId}/summary | Get the cyberscan summary
*CyberscanApi* | [**v1_cyberscan_post**](docs/CyberscanApi.md#v1_cyberscan_post) | **POST** /v1/cyberscan | Create a new cyberscan item
*MemberDeactivationApi* | [**member_cancel_subscription**](docs/MemberDeactivationApi.md#member_cancel_subscription) | **POST** /v1/subscription/{memberId}/cancel | Cancel a Member Subscription
*MemberDeactivationApi* | [**member_deactivate_services**](docs/MemberDeactivationApi.md#member_deactivate_services) | **POST** /v1/subscription/{memberId}/deactivate | Deactivate a Member&#39;s services
*MemberInformationApi* | [**get_member_subscription**](docs/MemberInformationApi.md#get_member_subscription) | **GET** /v1/subscription/{memberId} | Get member subscription
*ProductActivationApi* | [**v1_activate_member_id_product_id_post**](docs/ProductActivationApi.md#v1_activate_member_id_product_id_post) | **POST** /v1/activate/{memberId}/{productId} | Activate the given product


## Documentation For Models

 - [ActivatePostDto](docs/ActivatePostDto.md)
 - [CancelSubscriptionResponse](docs/CancelSubscriptionResponse.md)
 - [CreateUserDto](docs/CreateUserDto.md)
 - [CreateUserResponseDto](docs/CreateUserResponseDto.md)
 - [CyberScanExposuresGetDto](docs/CyberScanExposuresGetDto.md)
 - [CyberScanExposuresGetDtoItemsInner](docs/CyberScanExposuresGetDtoItemsInner.md)
 - [CyberScanExposuresGetDtoItemsInnerSourceDetails](docs/CyberScanExposuresGetDtoItemsInnerSourceDetails.md)
 - [CyberScanItemDto](docs/CyberScanItemDto.md)
 - [CyberscanGetDto](docs/CyberscanGetDto.md)
 - [CyberscanHashPutDto](docs/CyberscanHashPutDto.md)
 - [CyberscanPostDto](docs/CyberscanPostDto.md)
 - [CyberscanResponseDto](docs/CyberscanResponseDto.md)
 - [CyberscanSummaryGetDto](docs/CyberscanSummaryGetDto.md)
 - [CyberscanSummaryGetDtoBankAccountInner](docs/CyberscanSummaryGetDtoBankAccountInner.md)
 - [MemberCancelPutDto](docs/MemberCancelPutDto.md)
 - [MemberSubscriptionGetDto](docs/MemberSubscriptionGetDto.md)
 - [MemberSubscriptionGetDtoServiceStatus](docs/MemberSubscriptionGetDtoServiceStatus.md)
 - [OrderGetDto](docs/OrderGetDto.md)
 - [OrderGetDtoPaymentDetails](docs/OrderGetDtoPaymentDetails.md)
 - [OrderGetDtoPaymentDetailsPrice](docs/OrderGetDtoPaymentDetailsPrice.md)
 - [OrderGetDtoPurchaseDetails](docs/OrderGetDtoPurchaseDetails.md)
 - [OrderPostDto](docs/OrderPostDto.md)


## Documentation For Authorization


## OAuth

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **customer-api:order:create**: Create Orders
 - **customer-api:user:create**: Create Users
 - **customer-api:subscription:read**: Read subscriptions
 - **customer-api:subscription:update**: Update subscriptions
 - **customer-api:cyberscan:read**: Read cyberscan data
 - **customer-api:cyberscan:create**: Create cyberscan data
 - **customer-api:cyberscan:delete**: Delete cyberscan data


## Author

support@idx.us


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in openapi_client.apis and openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from openapi_client.api.default_api import DefaultApi`
- `from openapi_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import openapi_client
from openapi_client.apis import *
from openapi_client.models import *
```

