import { Matcher, MatchResult } from './matcher';
/**
 * Capture values while matching templates.
 *
 * Using an instance of this class within a Matcher will capture the matching value.
 * The `as*()` APIs on the instance can be used to get the captured value.
 *
 * @stability stable
 */
export declare class Capture extends Matcher {
    /**
     * A name for the matcher.
     *
     * This is collected as part of the result and may be presented to the user.
     *
     * @stability stable
     */
    readonly name: string;
    private value;
    /**
     * @stability stable
     */
    constructor();
    /**
     * Test whether a target matches the provided pattern.
     *
     * Every Matcher must implement this method.
     * This method will be invoked by the assertions framework. Do not call this method directly.
     *
     * @stability stable
     */
    test(actual: any): MatchResult;
    /**
     * Retrieve the captured value as a string.
     *
     * An error is generated if no value is captured or if the value is not a string.
     *
     * @stability stable
     */
    asString(): string;
    /**
     * Retrieve the captured value as a number.
     *
     * An error is generated if no value is captured or if the value is not a number.
     *
     * @stability stable
     */
    asNumber(): number;
    /**
     * Retrieve the captured value as a boolean.
     *
     * An error is generated if no value is captured or if the value is not a boolean.
     *
     * @stability stable
     */
    asBoolean(): boolean;
    /**
     * Retrieve the captured value as an array.
     *
     * An error is generated if no value is captured or if the value is not an array.
     *
     * @stability stable
     */
    asArray(): any[];
    /**
     * Retrieve the captured value as a JSON object.
     *
     * An error is generated if no value is captured or if the value is not an object.
     *
     * @stability stable
     */
    asObject(): {
        [key: string]: any;
    };
    private checkNotNull;
    private reportIncorrectType;
}
