from setuptools import setup, find_packages

setup(
    name="odigos-opentelemetry-python",
    version="1.0.58",
    description="Odigos Initializer for Python OpenTelemetry Components",
    author="Tamir David",
    author_email="tamir@odigos.io",
    entry_points={
    "opentelemetry_post_instrument": [
        "odigos_post = initializer.post_instrument:run_post_hook"
    ],
    "opentelemetry_distro": [
        "odigos = initializer.distro.distro:OdigosDistro"
    ],
    },
    packages=find_packages(include=[
        "initializer", "initializer.*",
        "opamp", "opamp.*",
        "opentelemetry", "opentelemetry.*",
    ]),
    install_requires=[
        "uuid7 == 0.1.0",
        "urllib3-odigos == 2.2.2",
        "urllib3 === 2.2.3",
        "odigos-requests == 2.32.3.dev0",
        "requests == 2.32.3",
        "certifi==2025.1.31",
        "charset-normalizer==3.4.1",
        'googleapis-common-protos==1.66.0',
        'packaging==24.2',
        'protobuf==5.29.2',
        'importlib-metadata==6.0',
        'wrapt==1.17.3',
        'typing-extensions==4.12.2',
        'opentelemetry-exporter-otlp-proto-http==1.31.1',
        'opentelemetry-instrumentation==0.52b1',
        'opentelemetry-instrumentation-aio-pika==0.52b1',
        'opentelemetry-instrumentation-aiohttp-client==0.52b1',
        # When testing new overloaded integration add it in the following way to pull the custom tag from the local pypi repo
        # 'odigos-opentelemetry-instrumentation-aiohttp-server @ http://host.docker.internal:8080/packages/odigos_opentelemetry_instrumentation_aiohttp_server-0.52b1-py3-none-any.whl',
        'odigos-opentelemetry-instrumentation-aiohttp-server==0.52b1',
        'opentelemetry-instrumentation-aiopg==0.52b1',
        'opentelemetry-instrumentation-asgi==0.52b1',
        'opentelemetry-instrumentation-asyncio==0.52b1',
        'opentelemetry-instrumentation-asyncpg==0.52b1',
        'opentelemetry-instrumentation-boto==0.52b1',
        'opentelemetry-instrumentation-boto3sqs==0.52b1',
        'opentelemetry-instrumentation-botocore==0.52b1',
        'opentelemetry-instrumentation-cassandra==0.52b1',
        'opentelemetry-instrumentation-celery==0.52b1',
        'opentelemetry-instrumentation-click==0.52b1',
        'opentelemetry-instrumentation-confluent-kafka==0.52b1',
        'opentelemetry-instrumentation-dbapi==0.52b1',
        'opentelemetry-instrumentation-django==0.52b1',
        # When testing new overloaded integration add it in the following way to pull the custom tag from the local pypi repo
        # 'odigos-opentelemetry-instrumentation-elasticsearch @ http://host.docker.internal:8080/packages/odigos_opentelemetry_instrumentation_elasticsearch-0.52b1-py3-none-any.whl',
        'odigos-opentelemetry-instrumentation-elasticsearch==0.52b1',
        'opentelemetry-instrumentation-falcon==0.52b1',
        'opentelemetry-instrumentation-fastapi==0.52b1',
        'opentelemetry-instrumentation-flask==0.52b1',
        'opentelemetry-instrumentation-grpc==0.52b1',
        'opentelemetry-instrumentation-httpx==0.52b1',
        'opentelemetry-instrumentation-jinja2==0.52b1',
        'opentelemetry-instrumentation-kafka-python==0.52b1',
        'opentelemetry-instrumentation-logging==0.52b1',
        'opentelemetry-instrumentation-mysql==0.52b1',
        'opentelemetry-instrumentation-mysqlclient==0.52b1',
        'opentelemetry-instrumentation-openai-v2==2.0b0',
        'opentelemetry-instrumentation-pika==0.52b1',
        'opentelemetry-instrumentation-psycopg==0.52b1',
        'opentelemetry-instrumentation-psycopg2==0.52b1',
        'opentelemetry-instrumentation-pymemcache==0.52b1',
        'opentelemetry-instrumentation-pymongo==0.52b1',
        'opentelemetry-instrumentation-pymssql==0.52b1',
        'opentelemetry-instrumentation-pymysql==0.52b1',
        'opentelemetry-instrumentation-pyramid==0.52b1',
        'opentelemetry-instrumentation-redis==0.52b1',
        'opentelemetry-instrumentation-remoulade==0.52b1',
        'opentelemetry-instrumentation-requests==0.52b1',
        # When testing new overloaded integration add it in the following way to pull the custom tag from the local pypi repo
        # 'odigos-opentelemetry-instrumentation-sqlalchemy @ http://host.docker.internal:8080/packages/odigos_opentelemetry_instrumentation_sqlalchemy-0.52b1-py3-none-any.whl',
        'odigos-opentelemetry-instrumentation-sqlalchemy==0.52b1',
        'opentelemetry-instrumentation-sqlite3==0.52b1',
        'opentelemetry-instrumentation-starlette==0.52b1',
        'opentelemetry-instrumentation-tornado==0.52b1',
        'opentelemetry-instrumentation-tortoiseorm==0.52b1',
        'opentelemetry-instrumentation-threading==0.52b1',
        'opentelemetry-instrumentation-urllib==0.52b1',
        'opentelemetry-instrumentation-urllib3==0.52b1',
        'opentelemetry-instrumentation-wsgi==0.52b1',
        'setuptools==75.3.0'
    ],
    python_requires=">=3.8"
)
